<?php
require_once __DIR__ . '/functions.php';

// Only logged-in teachers can view class details
if (!isLoggedIn()) {
    redirect('login.php');
}

$user = currentUser($pdo);
$classId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$class = getClassById($pdo, $classId);
if (!$class || $class['teacher_id'] !== $user['id']) {
    // Invalid class or no permission
    redirect('dashboard.php');
}

$students = getStudents($pdo, $classId);
$cycles = getCycles($pdo, $classId);
$error = '';

// Handle adding a new student
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['student_name'])) {
        $name = trim($_POST['student_name']);
        if ($name) {
            $stmt = $pdo->prepare('INSERT INTO students (class_id, name) VALUES (?, ?)');
            if ($stmt->execute([$classId, $name])) {
                // Refresh page to show new student
                redirect("class_detail.php?id=$classId");
            } else {
                $error = "Impossible d'ajouter l'élève.";
            }
        } else {
            $error = "Le nom de l'élève ne peut pas être vide.";
        }
    }
    // Optionally handle deletion here
    if (isset($_POST['delete_student_id'])) {
        $sid = (int)$_POST['delete_student_id'];
        $stmt = $pdo->prepare('DELETE FROM students WHERE id = ? AND class_id = ?');
        $stmt->execute([$sid, $classId]);
        redirect("class_detail.php?id=$classId");
    }
}

$pageTitle = 'Classe: ' . $class['name'];
include 'header.php';
?>

<h2>Détails de la classe: <?php echo htmlspecialchars($class['name']); ?></h2>

<p>Niveau: <?php echo htmlspecialchars($class['level']); ?></p>

<?php if ($error): ?>
    <div class="message error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<h3>Étudiants</h3>
<?php if (empty($students)): ?>
    <p>Aucun élève n'est enregistré pour cette classe.</p>
<?php else: ?>
    <div class="table-container">
    <table>
        <thead>
            <tr>
                <th>Nom</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($students as $student): ?>
            <tr>
                <td><?php echo htmlspecialchars($student['name']); ?></td>
                <td>
                    <form method="post" action="" style="display:inline" onsubmit="return confirmDelete('Supprimer cet élève ?');">
                        <input type="hidden" name="delete_student_id" value="<?php echo $student['id']; ?>">
                        <button type="submit">Supprimer</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    </div>
<?php endif; ?>

<h4>Ajouter un élève</h4>
<form method="post" action="">
    <label for="student_name">Nom de l'élève</label>
    <input type="text" id="student_name" name="student_name" required>
    <button type="submit">Ajouter</button>
</form>

<p><a href="import_students.php?class_id=<?php echo $classId; ?>">Importer des élèves depuis un CSV</a></p>

<h3>Cycles</h3>
<?php if (empty($cycles)): ?>
    <p>Aucun cycle n'est encore créé. <a href="create_cycle.php?class_id=<?php echo $classId; ?>">Créez un cycle</a>.</p>
<?php else: ?>
    <div class="table-container">
    <table>
        <thead>
            <tr>
                <th>Nom du cycle</th>
                <th>PPSAD (activité)</th>
                <th>Objet d'enseignement</th>
                <th>Type d'ECC</th>
                <th>Période</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($cycles as $cycle): ?>
            <tr>
                <td><?php echo htmlspecialchars($cycle['name']); ?></td>
                <td><?php echo htmlspecialchars($cycle['ppsad']); ?></td>
                <td><?php echo nl2br(htmlspecialchars($cycle['objective'])); ?></td>
                <td><?php echo htmlspecialchars($cycle['ecc_type']); ?></td>
                <td><?php echo htmlspecialchars($cycle['start_date'] . ' - ' . $cycle['end_date']); ?></td>
                <td>
                    <a href="cycle_detail.php?id=<?php echo $cycle['id']; ?>">Voir</a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    </div>
    <p><a href="create_cycle.php?class_id=<?php echo $classId; ?>">Ajouter un nouveau cycle</a></p>
<?php endif; ?>

<?php
include 'footer.php';
?>