<?php
require_once __DIR__ . '/functions.php';

// Only logged-in teachers can create a class
if (!isLoggedIn()) {
    redirect('login.php');
}

$user = currentUser($pdo);
$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $level = trim($_POST['level'] ?? '');
    if (!$name) {
        $error = "Le nom de la classe est requis.";
    } else {
        $stmt = $pdo->prepare('INSERT INTO classes (name, level, teacher_id) VALUES (?, ?, ?)');
        if ($stmt->execute([$name, $level, $user['id']])) {
            $success = "Classe créée avec succès.";
        } else {
            $error = "Une erreur est survenue lors de la création de la classe.";
        }
    }
}

$pageTitle = 'Créer une classe';
include 'header.php';
?>

<h2>Créer une nouvelle classe</h2>

<?php if ($error): ?>
    <div class="message error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>
<?php if ($success): ?>
    <div class="message success"><?php echo htmlspecialchars($success); ?></div>
<?php endif; ?>

<form method="post" action="">
    <label for="name">Nom de la classe</label>
    <input type="text" id="name" name="name" required>

    <label for="level">Niveau (facultatif)</label>
    <input type="text" id="level" name="level">

    <button type="submit">Créer la classe</button>
</form>

<?php
include 'footer.php';
?>