<?php
require_once __DIR__ . '/functions.php';

// Ensure user is logged in
if (!isLoggedIn()) {
    redirect('login.php');
}

$user = currentUser($pdo);
$classId = isset($_GET['class_id']) ? (int)$_GET['class_id'] : 0;
$class = getClassById($pdo, $classId);
if (!$class || $class['teacher_id'] !== $user['id']) {
    redirect('dashboard.php');
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $ppsad = trim($_POST['ppsad'] ?? '');
    $objective = trim($_POST['objective'] ?? '');
    $ecc = trim($_POST['ecc_type'] ?? '');
    $startDate = $_POST['start_date'] ?? null;
    $endDate = $_POST['end_date'] ?? null;
    $oeId = isset($_POST['oe_id']) && $_POST['oe_id'] !== '' ? (int)$_POST['oe_id'] : null;
    if (!$name || !$ppsad || !$objective) {
        $error = "Veuillez renseigner le nom, l'activité et l'objet d'enseignement.";
    } else {
        $stmt = $pdo->prepare('INSERT INTO cycles (class_id, name, ppsad, objective, ecc_type, start_date, end_date, oe_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)');
        if ($stmt->execute([$classId, $name, $ppsad, $objective, $ecc, $startDate ?: null, $endDate ?: null, $oeId])) {
            $success = "Cycle créé avec succès.";
        } else {
            $error = "Une erreur est survenue lors de la création du cycle.";
        }
    }
}

$pageTitle = 'Créer un cycle';
include 'header.php';
?>

<h2>Créer un nouveau cycle pour la classe <?php echo htmlspecialchars($class['name']); ?></h2>

<?php if ($error): ?>
    <div class="message error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>
<?php if ($success): ?>
    <div class="message success"><?php echo htmlspecialchars($success); ?></div>
<?php endif; ?>

<form method="post" action="">
    <?php $oeList = getOELibrary($pdo); ?>
    <label for="oe_id">Objet d'enseignement (bibliothèque)</label>
    <select id="oe_id" name="oe_id">
        <option value="">-- Aucun (personnalisé) --</option>
        <?php foreach ($oeList as $oe): ?>
            <option value="<?php echo $oe['id']; ?>"><?php echo htmlspecialchars($oe['ppsad'] . ' – ' . $oe['name']); ?></option>
        <?php endforeach; ?>
    </select>
    <small>Si vous sélectionnez un objet, il sera référencé pour ce cycle.</small>

    <label for="name">Nom du cycle</label>
    <input type="text" id="name" name="name" placeholder="ex: Cycle handball" required>

    <label for="ppsad">PPSAD (Activité support)</label>
    <input type="text" id="ppsad" name="ppsad" placeholder="ex: Handball" required>

    <label for="objective">Objet d'enseignement (objectif du cycle)</label>
    <textarea id="objective" name="objective" required></textarea>

    <label for="ecc_type">Type d'expérience (ECC)</label>
    <input type="text" id="ecc_type" name="ecc_type" placeholder="ex: confrontation, aventure, arts...">

    <label for="start_date">Date de début (facultatif)</label>
    <input type="date" id="start_date" name="start_date">

    <label for="end_date">Date de fin (facultatif)</label>
    <input type="date" id="end_date" name="end_date">

    <button type="submit">Créer le cycle</button>
</form>

<?php
include 'footer.php';
?>