<?php
require_once __DIR__ . '/functions.php';

// Ensure user is logged in
if (!isLoggedIn()) {
    redirect('login.php');
}
$user = currentUser($pdo);

$cycleId = isset($_GET['cycle_id']) ? (int)$_GET['cycle_id'] : 0;
$cycle = getCycleById($pdo, $cycleId);
if (!$cycle) {
    redirect('dashboard.php');
}
$class = getClassById($pdo, $cycle['class_id']);
if (!$class || $class['teacher_id'] !== $user['id']) {
    redirect('dashboard.php');
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $date = $_POST['lesson_date'] ?? '';
    $title = trim($_POST['title'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $fps = trim($_POST['fps'] ?? '');
    $cp = trim($_POST['cp'] ?? '');
    if (!$date || !$title) {
        $error = "La date et le titre de la leçon sont obligatoires.";
    } else {
        $stmt = $pdo->prepare('INSERT INTO lessons (cycle_id, lesson_date, title, description, fps, cp) VALUES (?, ?, ?, ?, ?, ?)');
        if ($stmt->execute([$cycleId, $date, $title, $description, $fps, $cp])) {
            $success = "Leçon créée avec succès.";
        } else {
            $error = "Erreur lors de la création de la leçon.";
        }
    }
}

$pageTitle = 'Créer une leçon';
include 'header.php';
?>

<h2>Ajouter une leçon pour le cycle <?php echo htmlspecialchars($cycle['name']); ?></h2>

<?php if ($error): ?>
    <div class="message error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>
<?php if ($success): ?>
    <div class="message success"><?php echo htmlspecialchars($success); ?></div>
<?php endif; ?>

<form method="post" action="">
    <label for="lesson_date">Date de la leçon</label>
    <input type="date" id="lesson_date" name="lesson_date" required>

    <label for="title">Titre de la leçon</label>
    <input type="text" id="title" name="title" required>

    <label for="description">Description / déroulement</label>
    <textarea id="description" name="description"></textarea>


    <label for="fps_select">FPS – sélectionner dans la bibliothèque (facultatif)</label>
    <?php $fpsList = getFPSLibrary($pdo); ?>
    <select id="fps_select" name="fps_select">
        <option value="">-- Choisir une forme prédéfinie --</option>
        <?php foreach ($fpsList as $fpsEntry): ?>
            <option value="<?php echo $fpsEntry['id']; ?>" data-description="<?php echo htmlspecialchars(str_replace('\n', ' ', $fpsEntry['description'])); ?>">
                <?php echo htmlspecialchars($fpsEntry['ppsad'] . ' – ' . $fpsEntry['name']); ?>
            </option>
        <?php endforeach; ?>
    </select>
    <small>Si vous sélectionnez une FPS, sa description sera copiée ci-dessous.</small>

    <label for="fps">FPS – Forme de Pratique Scolaire (jeu ou situation de référence)</label>
    <textarea id="fps" name="fps"></textarea>

    <label for="cp">CP – Contenus prioritaires (séparez-les par des sauts de ligne)</label>
    <textarea id="cp" name="cp"></textarea>

    <button type="submit">Créer la leçon</button>
</form>

<script>
// When selecting an FPS from the library, copy its description into the textarea
document.getElementById('fps_select').addEventListener('change', function () {
    var select = this;
    var selected = select.options[select.selectedIndex];
    var desc = selected.getAttribute('data-description') || '';
    // Decode HTML entities and replace escaped newlines
    var txt = desc.replace(/\\n/g, "\n");
    document.getElementById('fps').value = txt;
});
</script>

<?php
include 'footer.php';
?>