<?php
// This file outputs the top portion of the HTML layout.  It expects
// that the session has already been started and that functions.php
// has been included if you want to use currentUser().  It includes
// a simple navigation bar and links to the stylesheet and scripts.

// Determine the page title, or fall back to a default
$pageTitle = isset($pageTitle) ? $pageTitle : 'EPS Application';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?></title>
    <link rel="stylesheet" href="style.css">
    <!-- Lien vers le manifeste pour l'installation PWA -->
    <link rel="manifest" href="manifest.json">
</head>
<body>
    <header>
        <h1><?php echo htmlspecialchars($pageTitle); ?></h1>
        <nav>
            <ul>
                <?php if (isLoggedIn()): ?>
                    <li><a href="dashboard.php">Tableau de bord</a></li>
                    <li><a href="create_class.php">Nouvelle classe</a></li>
                    <li><a href="oe_library.php">Bibliothèque OE</a></li>
                    <li><a href="fps_library.php">Bibliothèque FPS</a></li>
                    <li><a href="reports.php">Rapports</a></li>
                    <li><a href="logout.php">Déconnexion</a></li>
                <?php else: ?>
                    <li><a href="login.php">Connexion</a></li>
                    <li><a href="register.php">Créer un compte</a></li>
                <?php endif; ?>
            </ul>
        </nav>
    </header>
    <main>