<?php
require_once __DIR__ . '/functions.php';

// Ensure user logged in
if (!isLoggedIn()) {
    redirect('login.php');
}
$user = currentUser($pdo);

$lessonId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$lesson = getLessonById($pdo, $lessonId);
if (!$lesson) {
    redirect('dashboard.php');
}
$cycle = getCycleById($pdo, $lesson['cycle_id']);
$class = getClassById($pdo, $cycle['class_id']);
if (!$class || $class['teacher_id'] !== $user['id']) {
    redirect('dashboard.php');
}

$students = getStudents($pdo, $class['id']);

// Fetch existing evaluations
$existingEvaluations = [];
$evals = getEvaluations($pdo, $lessonId);
foreach ($evals as $ev) {
    $existingEvaluations[$ev['student_id']] = $ev;
}

// Fetch roles and existing assignments
$rolesList = getRoles($pdo);
$lessonRoles = getLessonRoles($pdo, $lessonId);

$message = '';

// Handle evaluation submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['evaluate'])) {
        // Each student line has fields: score[student_id], remarks[student_id]
        // Extract multidimensional scores and comments
        $motricites   = $_POST['motricite']   ?? [];
        $intellis     = $_POST['intelligibilite'] ?? [];
        $sensibilites = $_POST['sensibilite'] ?? [];
        $sociabilites = $_POST['sociabilite'] ?? [];
        $generalComms = $_POST['general_comment'] ?? [];
        foreach ($students as $stu) {
            $sid = $stu['id'];
            $mot = trim($motricites[$sid] ?? '');
            $intell = trim($intellis[$sid] ?? '');
            $sens = trim($sensibilites[$sid] ?? '');
            $soc = trim($sociabilites[$sid] ?? '');
            $comm = trim($generalComms[$sid] ?? '');
            // Cast numeric strings to integers when provided
            $motVal = $mot === '' ? null : (int)$mot;
            $intellVal = $intell === '' ? null : (int)$intell;
            $sensVal = $sens === '' ? null : (int)$sens;
            $socVal = $soc === '' ? null : (int)$soc;
            if (isset($existingEvaluations[$sid])) {
                $stmt = $pdo->prepare('UPDATE evaluations SET motricite=?, intelligibilite=?, sensibilite=?, sociabilite=?, general_comment=? WHERE id = ?');
                $stmt->execute([$motVal, $intellVal, $sensVal, $socVal, $comm, $existingEvaluations[$sid]['id']]);
            } else {
                // Insert if at least one field is not empty
                if ($mot !== '' || $intell !== '' || $sens !== '' || $soc !== '' || $comm !== '') {
                    $stmt = $pdo->prepare('INSERT INTO evaluations (lesson_id, student_id, motricite, intelligibilite, sensibilite, sociabilite, general_comment) VALUES (?, ?, ?, ?, ?, ?, ?)');
                    $stmt->execute([$lessonId, $sid, $motVal, $intellVal, $sensVal, $socVal, $comm]);
                }
            }
        }
        $message = "Évaluations enregistrées.";
        // Refresh existing evaluations
        $evals = getEvaluations($pdo, $lessonId);
        $existingEvaluations = [];
        foreach ($evals as $ev) {
            $existingEvaluations[$ev['student_id']] = $ev;
        }
    }
    // Handle role assignment
    if (isset($_POST['assign_roles'])) {
        $assignments = $_POST['role'] ?? [];
        // Convert values to ints and ensure valid role ids
        $cleanAssign = [];
        foreach ($assignments as $sid => $rid) {
            $rid = (int)$rid;
            if ($rid > 0) {
                $cleanAssign[(int)$sid] = $rid;
            }
        }
        setLessonRoles($pdo, $lessonId, $cleanAssign);
        $lessonRoles = getLessonRoles($pdo, $lessonId);
        $message = ($message ? $message . ' ' : '') . "Rôles enregistrés.";
    }
}

$pageTitle = 'Leçon: ' . $lesson['title'];
include 'header.php';
?>

<h2>Détails de la leçon</h2>

<p><strong>Cycle:</strong> <?php echo htmlspecialchars($cycle['name']); ?> (Classe: <?php echo htmlspecialchars($class['name']); ?>)</p>
<p><strong>Date:</strong> <?php echo htmlspecialchars($lesson['lesson_date']); ?></p>
<p><strong>Titre:</strong> <?php echo htmlspecialchars($lesson['title']); ?></p>
<p><strong>Description:</strong><br><?php echo nl2br(htmlspecialchars($lesson['description'])); ?></p>
<p><strong>FPS:</strong><br><?php echo nl2br(htmlspecialchars($lesson['fps'])); ?></p>
<p><strong>CP:</strong><br><?php echo nl2br(htmlspecialchars($lesson['cp'])); ?></p>

<h3>Évaluations</h3>
<?php if ($message): ?>
    <div class="message success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<form method="post" action="">
    <input type="hidden" name="evaluate" value="1">
    <div class="table-container">
    <table>
        <thead>
            <tr>
                <th>Élève</th>
                <th>Motricité</th>
                <th>Intelligibilité</th>
                <th>Sensibilité</th>
                <th>Sociabilité</th>
                <th>Commentaire général</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($students as $stu): ?>
            <tr>
                <td><?php echo htmlspecialchars($stu['name']); ?></td>
                <td><input type="number" name="motricite[<?php echo $stu['id']; ?>]" min="0" max="20" value="<?php echo htmlspecialchars($existingEvaluations[$stu['id']]['motricite'] ?? ''); ?>"></td>
                <td><input type="number" name="intelligibilite[<?php echo $stu['id']; ?>]" min="0" max="20" value="<?php echo htmlspecialchars($existingEvaluations[$stu['id']]['intelligibilite'] ?? ''); ?>"></td>
                <td><input type="number" name="sensibilite[<?php echo $stu['id']; ?>]" min="0" max="20" value="<?php echo htmlspecialchars($existingEvaluations[$stu['id']]['sensibilite'] ?? ''); ?>"></td>
                <td><input type="number" name="sociabilite[<?php echo $stu['id']; ?>]" min="0" max="20" value="<?php echo htmlspecialchars($existingEvaluations[$stu['id']]['sociabilite'] ?? ''); ?>"></td>
                <td><input type="text" name="general_comment[<?php echo $stu['id']; ?>]" value="<?php echo htmlspecialchars($existingEvaluations[$stu['id']]['general_comment'] ?? ''); ?>"></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    </div>
    <button type="submit">Enregistrer les évaluations</button>
</form>

<h3>Attribution des rôles sociaux</h3>
<form method="post" action="">
    <input type="hidden" name="assign_roles" value="1">
    <div class="table-container">
    <table>
        <thead>
            <tr>
                <th>Élève</th>
                <th>Rôle attribué</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($students as $stu): ?>
            <tr>
                <td><?php echo htmlspecialchars($stu['name']); ?></td>
                <td>
                    <select name="role[<?php echo $stu['id']; ?>]">
                        <option value="">-- Aucune attribution --</option>
                        <?php foreach ($rolesList as $role): ?>
                            <option value="<?php echo $role['id']; ?>" <?php echo (isset($lessonRoles[$stu['id']]) && $lessonRoles[$stu['id']]['role_id'] == $role['id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($role['name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    </div>
    <button type="submit">Enregistrer les rôles</button>
</form>

<?php
include 'footer.php';
?>