// Service Worker simplifié pour l'application EPS
// Ce service worker met en cache les fichiers principaux de l'application
// afin de permettre un chargement plus rapide et un mode hors ligne basique.

const CACHE_NAME = 'eps-app-cache-v1';
const URLS_TO_CACHE = [
  './',
  'index.php',
  'style.css',
  'js/scripts.js'
];

self.addEventListener('install', (event) => {
  // Pré-cache les ressources essentielles
  event.waitUntil(
    caches.open(CACHE_NAME).then((cache) => {
      return cache.addAll(URLS_TO_CACHE);
    })
  );
});

self.addEventListener('activate', (event) => {
  // Nettoyer les caches anciens s'il y en a
  event.waitUntil(
    caches.keys().then((cacheNames) => {
      return Promise.all(
        cacheNames.map((cache) => {
          if (cache !== CACHE_NAME) {
            return caches.delete(cache);
          }
        })
      );
    })
  );
});

self.addEventListener('fetch', (event) => {
  event.respondWith(
    caches.match(event.request).then((response) => {
      // Retourner la ressource depuis le cache si disponible, sinon la récupérer depuis le réseau
      return response || fetch(event.request);
    })
  );
});