<?php
require_once __DIR__ . '/functions.php';

// Ensure logged in
if (!isLoggedIn()) {
    redirect('login.php');
}
$user = currentUser($pdo);

// Get cycle ID from query
$cycleId = isset($_GET['cycle_id']) ? (int)$_GET['cycle_id'] : 0;
$cycle = getCycleById($pdo, $cycleId);
if (!$cycle) {
    die('Cycle introuvable.');
}

// Check permission: teacher or admin
if ($user['role'] === 'teacher') {
    $class = getClassById($pdo, $cycle['class_id']);
    if (!$class || $class['teacher_id'] != $user['id']) {
        die('Accès refusé.');
    }
} elseif ($user['role'] !== 'admin') {
    die('Accès refusé.');
}

// Fetch students and evaluations for this cycle
$students = getStudents($pdo, $cycle['class_id']);
$lessons = getLessons($pdo, $cycleId);

// Build header row: Student, then each lesson's dimensions
$headers = ['Élève'];
foreach ($lessons as $lesson) {
    $lessonTitle = $lesson['title'] . ' (' . $lesson['lesson_date'] . ')';
    $headers[] = $lessonTitle . ' – Motricité';
    $headers[] = $lessonTitle . ' – Intelligibilité';
    $headers[] = $lessonTitle . ' – Sensibilité';
    $headers[] = $lessonTitle . ' – Sociabilité';
    $headers[] = $lessonTitle . ' – Commentaire';
}

// Prepare evaluation data keyed by lesson and student
$evalData = [];
foreach ($lessons as $lesson) {
    $evals = getEvaluations($pdo, $lesson['id']);
    foreach ($evals as $ev) {
        $evalData[$lesson['id']][$ev['student_id']] = $ev;
    }
}

// Set headers for CSV download
header('Content-Type: text/csv; charset=UTF-8');
header('Content-Disposition: attachment; filename="cycle_' . $cycleId . '_export.csv"');

$output = fopen('php://output', 'w');
// Write UTF‑8 BOM for Excel compatibility
fwrite($output, chr(0xEF) . chr(0xBB) . chr(0xBF));
// Write header row
fputcsv($output, $headers, ';');

// Write each student row
foreach ($students as $stu) {
    $row = [$stu['name']];
    foreach ($lessons as $lesson) {
        $ev = isset($evalData[$lesson['id']][$stu['id']]) ? $evalData[$lesson['id']][$stu['id']] : null;
        $row[] = $ev ? $ev['motricite'] : '';
        $row[] = $ev ? $ev['intelligibilite'] : '';
        $row[] = $ev ? $ev['sensibilite'] : '';
        $row[] = $ev ? $ev['sociabilite'] : '';
        $row[] = $ev ? $ev['general_comment'] : '';
    }
    fputcsv($output, $row, ';');
}

fclose($output);
exit;