<?php
require_once __DIR__ . '/functions.php';

// If already logged in redirect to dashboard
if (isLoggedIn()) {
    redirect('dashboard.php');
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    if (loginUser($pdo, $email, $password)) {
        redirect('dashboard.php');
    } else {
        $error = "Identifiants invalides. Veuillez réessayer.";
    }
}

$pageTitle = 'Connexion';
include 'header.php';
?>

<div class="mt-4">
    <h2>Connexion</h2>
    <?php if ($error): ?>
        <div class="alert alert-danger mt-3"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <form method="post" action="" class="mt-3">
        <div class="mb-3">
            <label for="email" class="form-label">Adresse email</label>
            <input type="email" id="email" name="email" class="form-control" required>
        </div>
        <div class="mb-3">
            <label for="password" class="form-label">Mot de passe</label>
            <input type="password" id="password" name="password" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-primary">Se connecter</button>
    </form>
    <p class="mt-2">Pas de compte ? <a href="register.php" class="link-primary">Inscrivez-vous ici</a>.</p>
</div>

<?php
include 'footer.php';
?>