<?php
require_once __DIR__ . '/functions.php';

// Ensure user is logged in
if (!isLoggedIn()) {
    redirect('login.php');
}

$user = currentUser($pdo);
$classId = isset($_GET['class_id']) ? (int)$_GET['class_id'] : 0;
$class = getClassById($pdo, $classId);
// Only teachers and coordinators assigned to the class may create cycles
if (!$class || !userCanAccessClass($pdo, $classId, $user['id']) || (!userHasRole($pdo, 'teacher') && !userHasRole($pdo, 'coordinator'))) {
    redirect('dashboard.php');
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $ppsad = trim($_POST['ppsad'] ?? '');
    $objective = trim($_POST['objective'] ?? '');
    $ecc = trim($_POST['ecc_type'] ?? '');
    // Additional fields for detailed cycle (activity code, title, OE, FPS, CP, assessment)
    $activity = trim($_POST['activity'] ?? '');
    $titleTxt = trim($_POST['title'] ?? '');
    $oeText = trim($_POST['oe'] ?? '');
    $fpsText = trim($_POST['fps'] ?? '');
    $goalsText = trim($_POST['goals'] ?? '');
    $assessmentText = trim($_POST['assessment'] ?? '');
    $startDate = $_POST['start_date'] ?? null;
    $endDate = $_POST['end_date'] ?? null;
    $oeId = isset($_POST['oe_id']) && $_POST['oe_id'] !== '' ? (int)$_POST['oe_id'] : null;
    if (!$name || !$ppsad || !$objective) {
        $error = "Veuillez renseigner le nom, l'activité et l'objet d'enseignement.";
    } else {
        // Insert with extended fields
        $stmt = $pdo->prepare('INSERT INTO cycles (class_id, name, ppsad, objective, ecc_type, start_date, end_date, activity, title, oe, fps, goals, assessment, oe_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)');
        if ($stmt->execute([
            $classId,
            $name,
            $ppsad,
            $objective,
            $ecc,
            $startDate ?: null,
            $endDate ?: null,
            $activity ?: null,
            $titleTxt ?: null,
            $oeText ?: null,
            $fpsText ?: null,
            $goalsText ?: null,
            $assessmentText ?: null,
            $oeId
        ])) {
            $success = "Cycle créé avec succès.";
        } else {
            $error = "Une erreur est survenue lors de la création du cycle.";
        }
    }
}

$pageTitle = 'Créer un cycle';
include 'header.php';
?>

<div class="mt-4">
    <h2>Créer un nouveau cycle pour la classe <?php echo htmlspecialchars($class['name']); ?></h2>

    <?php if ($error): ?>
        <div class="alert alert-danger mt-3"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <?php if ($success): ?>
        <div class="alert alert-success mt-3"><?php echo htmlspecialchars($success); ?></div>
    <?php endif; ?>

    <?php $oeList = getOELibrary($pdo); ?>
    <form method="post" action="" class="mt-3">
        <div class="mb-3">
            <label for="oe_id" class="form-label">Objet d'enseignement (bibliothèque)</label>
            <select id="oe_id" name="oe_id" class="form-select">
                <option value="">-- Aucun (personnalisé) --</option>
                <?php foreach ($oeList as $oe): ?>
                    <option value="<?php echo $oe['id']; ?>"><?php echo htmlspecialchars($oe['ppsad'] . ' – ' . $oe['name']); ?></option>
                <?php endforeach; ?>
            </select>
            <div class="form-text">Si vous sélectionnez un objet, il sera référencé pour ce cycle.</div>
        </div>
        <div class="mb-3">
            <label for="name" class="form-label">Nom du cycle</label>
            <input type="text" id="name" name="name" class="form-control" placeholder="ex : Cycle handball" required>
        </div>
        <div class="mb-3">
            <label for="ppsad" class="form-label">
                PPSAD (Activité support)
                <i class="bi bi-question-circle-fill ms-1 text-secondary" role="button" tabindex="0" data-bs-toggle="popover" data-bs-trigger="focus" title="PPSAD" data-bs-content="L'activité support est la discipline ou pratique physique servant de cadre au cycle (ex : basket-ball, gymnastique, course...)."></i>
            </label>
            <input type="text" id="ppsad" name="ppsad" class="form-control" placeholder="ex : Handball" required>
        </div>
        <div class="mb-3">
            <label for="objective" class="form-label">
                Objet d'enseignement (objectif du cycle)
                <i class="bi bi-question-circle-fill ms-1 text-secondary" role="button" tabindex="0" data-bs-toggle="popover" data-bs-trigger="focus" title="Objet d'enseignement" data-bs-content="Décrit le pas en avant qualitatif attendu chez l'élève. L'OE précise ce que l'élève doit intégrer ou maîtriser au cours du cycle (ex : s'organiser collectivement autour d'une stratégie, réguler son effort...)."></i>
            </label>
            <textarea id="objective" name="objective" class="form-control" rows="3" required></textarea>
        </div>
        <div class="mb-3">
            <label for="ecc_type" class="form-label">
                Type d'expérience (ECC)
                <i class="bi bi-question-circle-fill ms-1 text-secondary" role="button" tabindex="0" data-bs-toggle="popover" data-bs-trigger="focus" title="Type d'expérience" data-bs-content="L'ECC désigne la forme principale d'expérience pour ce cycle : performance, entretien, confrontation, expression artistique ou aventure. Cela oriente la logique d'apprentissage."></i>
            </label>
            <input type="text" id="ecc_type" name="ecc_type" class="form-control" placeholder="ex : Confrontation, Performance, Entretien...">
        </div>
        <!-- Additional fields for detailed cycle information -->
        <div class="mb-3">
            <label for="activity" class="form-label">Code d'activité (PPSAD code)</label>
            <input type="text" id="activity" name="activity" class="form-control" placeholder="ex : VB, CED, TT...">
            <div class="form-text">Code court de l'activité (ex : VB pour volley-ball). Facultatif.</div>
        </div>
        <div class="mb-3">
            <label for="title" class="form-label">Titre complet du cycle</label>
            <input type="text" id="title" name="title" class="form-control" placeholder="ex : Cycle Volley-ball – OE A & B">
            <div class="form-text">Ce titre sera affiché dans les listes et permet de détailler la progression.</div>
        </div>
        <div class="mb-3">
            <label for="oe" class="form-label">Objet d’enseignement détaillé</label>
            <textarea id="oe" name="oe" class="form-control" rows="4" placeholder="Décrivez le pas en avant attendu et les contraintes (emblématiques, micro/macro fils rouges)..."></textarea>
            <div class="form-text">Utilisez cette zone pour intégrer toutes les composantes de l’OE, y compris les fils rouges macro/micro et les contraintes emblématiques et d’étayage.</div>
        </div>
        <div class="mb-3">
            <label for="fps" class="form-label">Forme de pratique scolaire (FPS)</label>
            <textarea id="fps" name="fps" class="form-control" rows="4" placeholder="Décrivez la forme de pratique scolaire et les contraintes emblématiques."></textarea>
            <div class="form-text">Précisez les principales caractéristiques de la FPS, notamment les contraintes emblématiques et d’étayage.</div>
        </div>
        <div class="mb-3">
            <label for="goals" class="form-label">Contenus prioritaires (CP)</label>
            <textarea id="goals" name="goals" class="form-control" rows="4" placeholder="Décrivez les contenus prioritaires (CP1 à CP4) et leurs dimensions M/Se/I/So."></textarea>
            <div class="form-text">Listez les contenus prioritaires associés à l’OE avec leurs composantes motrices, sensorielles, intellectuelles et sociales.</div>
        </div>
        <div class="mb-3">
            <label for="assessment" class="form-label">Évaluation et contrats</label>
            <textarea id="assessment" name="assessment" class="form-control" rows="4" placeholder="Indiquez les critères d’évaluation, les contrats et les modalités d’évaluation."></textarea>
            <div class="form-text">Précisez les critères d’évaluation, les contrats de match et les modalités de suivi (fils rouges macro et micro).</div>
        </div>
        <div class="row g-3">
            <div class="col-md-6">
                <label for="start_date" class="form-label">Date de début (facultatif)</label>
                <input type="date" id="start_date" name="start_date" class="form-control">
            </div>
            <div class="col-md-6">
                <label for="end_date" class="form-label">Date de fin (facultatif)</label>
                <input type="date" id="end_date" name="end_date" class="form-control">
            </div>
        </div>
        <button type="submit" class="btn btn-primary mt-3">Créer le cycle</button>
    </form>
</div>

<?php
include 'footer.php';
?>