<?php
/**
 * Script pour créer un hash de mot de passe et tester la connexion
 * Utilisez ce fichier pour :
 * 1. Générer un hash pour un nouveau mot de passe
 * 2. Vérifier si un mot de passe correspond à un hash
 * 3. Créer directement un compte dans la base
 */

// =====================================================
// 1. GÉNÉRER UN NOUVEAU HASH
// =====================================================
echo "<h2>Générateur de hash de mot de passe</h2>";

// Changez ce mot de passe par celui que vous voulez
$nouveauMotDePasse = 'test123';

// Générer le hash
$hash = password_hash($nouveauMotDePasse, PASSWORD_DEFAULT);

echo "Mot de passe : <strong>$nouveauMotDePasse</strong><br>";
echo "Hash généré : <code>$hash</code><br><br>";
echo "Copiez cette ligne SQL :<br>";
echo "<textarea style='width:100%;height:60px;'>UPDATE users SET password = '$hash' WHERE email = 'demo@demo.com';</textarea>";
echo "<hr>";

// =====================================================
// 2. VÉRIFIER SI LE HASH EXISTANT FONCTIONNE
// =====================================================
echo "<h2>Vérification du hash existant</h2>";

// Le hash qui est dans votre base actuellement
$hashExistant = '$2y$10$mM4u9/4W1Fsx1q1n9wGvSuhxwWm1fpFv6Kj8n49CtoE7m8fJmGz6e';

// Tester différents mots de passe
$motsDePasseATester = ['Demo123!', 'demo123', 'password', 'test123', 'Demo123'];

foreach ($motsDePasseATester as $mdp) {
    if (password_verify($mdp, $hashExistant)) {
        echo "✅ Le mot de passe '<strong>$mdp</strong>' correspond au hash existant!<br>";
    } else {
        echo "❌ '$mdp' ne correspond pas<br>";
    }
}
echo "<hr>";

// =====================================================
// 3. CRÉER UN COMPTE DIRECTEMENT DANS LA BASE
// =====================================================
echo "<h2>Création directe d'un compte</h2>";

// Configuration de la base de données
require_once 'config.php';

try {
    // Créer un nouveau compte avec un mot de passe simple
    $email = 'test@test.com';
    $motDePasse = 'test123';
    $nom = 'Compte Test';
    $hashNouveau = password_hash($motDePasse, PASSWORD_DEFAULT);
    
    // Vérifier si le compte existe déjà
    $stmt = $pdo->prepare('SELECT id FROM users WHERE email = ?');
    $stmt->execute([$email]);
    
    if ($stmt->fetch()) {
        // Mettre à jour le mot de passe si le compte existe
        $stmt = $pdo->prepare('UPDATE users SET password = ? WHERE email = ?');
        $stmt->execute([$hashNouveau, $email]);
        echo "✅ Compte existant mis à jour<br>";
    } else {
        // Créer un nouveau compte
        $stmt = $pdo->prepare('INSERT INTO users (name, email, password, role) VALUES (?, ?, ?, ?)');
        $stmt->execute([$nom, $email, $hashNouveau, 'teacher']);
        echo "✅ Nouveau compte créé<br>";
    }
    
    echo "Email : <strong>$email</strong><br>";
    echo "Mot de passe : <strong>$motDePasse</strong><br>";
    echo "<br><a href='login.php'>Tester la connexion</a>";
    
} catch (PDOException $e) {
    echo "❌ Erreur : " . $e->getMessage();
}

echo "<hr>";
echo "<h2>Comptes recommandés à créer</h2>";
echo "<pre>";
echo "Email: test@test.com / Mot de passe: test123
Email: prof@eps.fr / Mot de passe: test123
Email: admin@admin.com / Mot de passe: admin123";
echo "</pre>";
?>

<style>
body {
    font-family: Arial, sans-serif;
    max-width: 800px;
    margin: 50px auto;
    padding: 20px;
    background: #f5f5f5;
}
h2 {
    color: #333;
    border-bottom: 2px solid #4CAF50;
    padding-bottom: 10px;
}
code {
    background: #e0e0e0;
    padding: 2px 5px;
    border-radius: 3px;
}
textarea {
    font-family: 'Courier New', monospace;
    padding: 10px;
}
pre {
    background: white;
    padding: 15px;
    border-left: 4px solid #4CAF50;
}
</style>
