// Basic JavaScript helpers for the EPS application

// Confirm deletion of an item
function confirmDelete(message) {
    return confirm(message || 'Êtes-vous sûr de vouloir supprimer cet élément ?');
}

// Initialize DataTables on tables with the "datatable" class once the DOM is ready.
document.addEventListener('DOMContentLoaded', function() {
    // Enable Bootstrap popovers for elements that define data-bs-toggle="popover"
    if (typeof bootstrap !== 'undefined' && bootstrap.Popover) {
        var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'));
        popoverTriggerList.forEach(function (popoverTriggerEl) {
            new bootstrap.Popover(popoverTriggerEl);
        });
    }
    // Check if jQuery and DataTables are loaded
    if (typeof $ !== 'undefined' && $.fn.DataTable) {
        const tables = document.querySelectorAll('table.datatable');
        tables.forEach(function(table) {
            $(table).DataTable({
                language: {
                    url: 'https://cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json'
                },
                pageLength: 10,
                lengthMenu: [[10, 25, 50, -1], [10, 25, 50, 'Tout']]
            });
        });
    }
});