<?php
require_once __DIR__ . '/functions.php';

// Only teachers or admins can access this page
if (!isLoggedIn()) {
    redirect('login.php');
}
$user = currentUser($pdo);
// Restrict to teacher or admin roles
if ($user['role'] !== 'teacher' && $user['role'] !== 'admin') {
    redirect('dashboard.php');
}

$error = '';
$success = '';

// Handle addition of a new FPS
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_fps'])) {
    $ppsad = trim($_POST['ppsad'] ?? '');
    $name = trim($_POST['name'] ?? '');
    $desc = trim($_POST['description'] ?? '');
    $constraints = trim($_POST['constraints'] ?? '');
    $ecc = trim($_POST['ecc_type'] ?? '');
    if (!$ppsad || !$name) {
        $error = "Les champs 'PPSAD' et 'Nom' sont obligatoires.";
    } else {
        $stmt = $pdo->prepare('INSERT INTO fps_library (ppsad, name, description, constraints, ecc_type) VALUES (?, ?, ?, ?, ?)');
        if ($stmt->execute([$ppsad, $name, $desc, $constraints, $ecc])) {
            $success = "FPS ajoutée à la bibliothèque.";
        } else {
            $error = "Erreur lors de l'ajout de la FPS.";
        }
    }
}

// Handle deletion of a FPS
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_fps_id'])) {
    $delId = (int)$_POST['delete_fps_id'];
    $stmt = $pdo->prepare('DELETE FROM fps_library WHERE id = ?');
    $stmt->execute([$delId]);
    $success = "FPS supprimée de la bibliothèque.";
}

// Retrieve library contents
$fpsList = getFPSLibrary($pdo);

$pageTitle = 'Bibliothèque des FPS';
include 'header.php';
?>

<h2>Bibliothèque des Formes de Pratique Scolaire (FPS)</h2>

<?php if ($error): ?>
    <div class="message error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>
<?php if ($success): ?>
    <div class="message success"><?php echo htmlspecialchars($success); ?></div>
<?php endif; ?>

<h3>Ajouter une nouvelle FPS</h3>
<form method="post" action="">
    <input type="hidden" name="add_fps" value="1">
    <label for="ppsad">PPSAD (Activité support)</label>
    <input type="text" id="ppsad" name="ppsad" required>

    <label for="name">Nom de la FPS</label>
    <input type="text" id="name" name="name" required>

    <label for="description">Description / déroulement</label>
    <textarea id="description" name="description"></textarea>

    <label for="constraints">Contraintes emblématiques (règles spécifiques, terrain, matériel)</label>
    <textarea id="constraints" name="constraints"></textarea>

    <label for="ecc_type">Type d'ECC</label>
    <input type="text" id="ecc_type" name="ecc_type">

    <button type="submit">Ajouter à la bibliothèque</button>
</form>

<h3>FPS enregistrées</h3>
<?php if (empty($fpsList)): ?>
    <p>Aucune FPS n'est enregistrée.</p>
<?php else: ?>
    <div class="table-container">
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>PPSAD</th>
                <th>Nom</th>
                <th>Description</th>
                <th>Contraintes</th>
                <th>ECC</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($fpsList as $fps): ?>
            <tr>
                <td><?php echo $fps['id']; ?></td>
                <td><?php echo htmlspecialchars($fps['ppsad']); ?></td>
                <td><?php echo htmlspecialchars($fps['name']); ?></td>
                <td><?php echo nl2br(htmlspecialchars($fps['description'])); ?></td>
                <td><?php echo nl2br(htmlspecialchars($fps['constraints'])); ?></td>
                <td><?php echo htmlspecialchars($fps['ecc_type']); ?></td>
                <td>
                    <form method="post" action="" onsubmit="return confirmDelete('Supprimer cette FPS ?');" style="display:inline">
                        <input type="hidden" name="delete_fps_id" value="<?php echo $fps['id']; ?>">
                        <button type="submit">Supprimer</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    </div>
<?php endif; ?>

<?php
include 'footer.php';
?>