# Application EPS – CEDREPS (version 2)

Cette application web est une solution complète pour l’enseignement de l’EPS conforme aux principes du **CEDREPS**.  La version 2 apporte une modernisation en profondeur : design responsive basé sur **Bootstrap 5**, tables interactives grâce à **DataTables**, graphiques dynamiques avec **Chart.js** et un système de rôles avancé permettant la collaboration entre professeurs, coordinateurs, inspecteurs et chefs d’établissement.  Des info‑bulles pédagogiques contextualisées aident les utilisateurs à saisir les notions clés du référentiel.  L’application fonctionne comme une **Progressive Web App (PWA)** et reste entièrement opérationnelle hors connexion.

## Pré‑requis

* Un hébergement mutualisé cPanel avec PHP 7.4 ou supérieur et une base de données MySQL disponible.  PHP 8 est également supporté.
* Un accès à phpMyAdmin ou à l'outil MySQL de votre hébergeur pour créer la base et importer le fichier SQL.
* Un client FTP ou le gestionnaire de fichiers cPanel pour transférer les fichiers.

## Installation pas à pas

1. **Créer la base de données**

   Connectez‑vous à votre cPanel puis ouvrez “Bases de données MySQL”.  Créez une nouvelle base (par exemple `eps_app_db`) et un utilisateur MySQL avec tous les privilèges sur cette base.  Notez bien le nom de la base, l'utilisateur et le mot de passe : ils seront utilisés dans le fichier de configuration.

2. **Importer le schéma**

   Ouvrez phpMyAdmin via cPanel.  Sélectionnez la base de données que vous venez de créer et utilisez l’onglet **Importer** pour importer les scripts suivants situés dans le dossier `app_v2` :

   * `install.sql` : crée la structure de base (tables `users`, `classes`, `cycles`, `lessons`, `evaluations`, etc.).
   * `install_v2.sql` : ajoute les éléments nécessaires à la version 2 (tables `roles`, `user_roles`, `class_teachers`, insertion des rôles « teacher », « coordinator », « principal », « inspector », etc., et colonne `user_id` dans `students`).  **Importez ce fichier après `install.sql`.**

3. **Configurer la connexion à la base**

   Dans le dossier `eps_app`, ouvrez le fichier `config.php` et modifiez les variables suivantes pour qu'elles correspondent aux paramètres de votre base :

   ```php
   $db_host = 'localhost';       // généralement localhost sur un hébergement cPanel
   $db_name = 'eps_app_db';      // nom de la base de données
   $db_user = 'eps_user';        // nom de l'utilisateur MySQL
   $db_pass = 'secret_password'; // mot de passe de cet utilisateur
   ```

   Enregistrez le fichier et fermez‑le.

4. **Déployer les fichiers**

   Transférez l'intégralité du dossier `eps_app` sur votre serveur via FTP ou le gestionnaire de fichiers cPanel.  Vous pouvez le placer à la racine `public_html` si vous souhaitez y accéder via `https://votredomaine.com/eps_app`, ou bien directement dans `public_html` pour y accéder à la racine du site.

5. **Créer un premier compte**

   Rendez‑vous dans votre navigateur à l’URL correspondant au dossier (`/app_v2/`).  Vous serez redirigé vers la page de connexion.  Utilisez le lien “Créer un compte” pour inscrire votre premier utilisateur.  Lors de l’inscription vous pourrez choisir le rôle principal (enseignant ou étudiant) ; si `install_v2.sql` a été importé, le rôle sélectionné sera également écrit dans la table `user_roles`.

   Pour créer des comptes « coordinateur », « principal » ou « inspecteur », créez d’abord un compte enseignant puis modifiez ses droits en base (table `user_roles`) ou en utilisant un outil d’administration que vous développerez.

6. **Commencer à utiliser l’application**

   Une fois connecté, vous accéderez au tableau de bord.  Vous pourrez créer vos classes, y ajouter des élèves, créer des cycles (saisir l'activité support, l'objectif d'enseignement, etc.), puis ajouter les leçons et saisir les évaluations pour chaque élève.

## Structure des fichiers

* `install.sql` : script SQL de base (version 1) pour créer la base de données.
* `install_v2.sql` : script SQL complémentaire pour la version 2 (ajoute les tables et rôles nécessaires à la collaboration multi‑enseignants et aux profils avancés).
* `config.php` : configuration de la connexion MySQL.
* `functions.php` : fonctions communes (authentification, accès aux données) incluant désormais la gestion des rôles multiples (`getUserRoles`, `userHasRole`, `userCanAccessClass`, etc.).
* `index.php` : redirection vers la connexion ou le tableau de bord.
* `login.php`, `register.php`, `logout.php` : authentification.
* `dashboard.php` : page d’accueil présentant les classes accessibles (multi‑enseignants) sous forme de tableau interactif.
* `create_class.php` : formulaire de création de classe.
* `class_detail.php` : gestion des élèves et cycles d’une classe.  Les listes sont interactives grâce à DataTables et la page respecte les droits selon le rôle de l’utilisateur.
* `create_cycle.php` : création d’un cycle pour une classe.
* `cycle_detail.php` : consultation des leçons d’un cycle et visualisation graphique de l’évolution des évaluations (graphique en ligne Chart.js) ainsi qu’export des données en CSV.
* `create_lesson.php` : création d’une leçon dans un cycle avec des info‑bulles pédagogiques expliquant chaque champ (FPS, CP, description…).
* `lesson_detail.php` : consultation d’une leçon et saisie des évaluations.  Les résultats sont présentés dans un tableau interactif et un radar Chart.js affiche les moyennes des 4 dimensions (motricité, intelligibilité, sensibilité, sociabilité).  L’enseignant peut également attribuer des rôles sociaux aux élèves.
* `style.css` : feuille de styles personnalisée pour compléter Bootstrap.
* `js/scripts.js` : fonctions JavaScript (confirmation de suppression, initialisation de DataTables, activation des info‑bulles Bootstrap, etc.).

## Sécurité et recommandations

* Les mots de passe sont stockés sous forme de hachage sécurisé (`password_hash`) dans la base.  Les sessions utilisateurs sont protégées via des vérifications systématiques des droits.
* Les actions de création et de consultation sont protégées par la vérification du statut de connexion.  Néanmoins, pour un usage en production, renforcez la sécurité : utilisez HTTPS, limitez les injections potentielles et mettez à jour PHP régulièrement.
* Cette application est une base complète mais extensible.  Vous pouvez ajouter des fonctionnalités telles que l’import/export de données, des formulaires encore plus assistés, ou l’intégration de nouveaux types d’analyses.  Pensez à maintenir les mesures de sécurité et à respecter le RGPD (anonymisation, durée de conservation, etc.).

## Nouveautés de la version 2

* **Design moderne et responsive** : intégration complète de Bootstrap 5 avec navigation adaptative, icônes vectorielles et composants harmonisés.
* **Tables interactives** : toutes les listes (classes, élèves, cycles, leçons) sont paginées, triables et filtrables grâce à DataTables.
* **Graphiques dynamiques** : utilisation de Chart.js pour visualiser les moyennes d’évaluations d’une leçon (radar) et la progression d’un cycle (graphique en lignes).  Le rapport global affiche un histogramme des types d’ECC déclarés.
* **Système de rôles avancé** : ajout des tables `roles`, `user_roles` et `class_teachers` pour permettre l’association de plusieurs enseignants à une classe et la coexistence de profils « coordinateur », « principal », « inspecteur », « admin ».  Les menus et droits d’accès s’adaptent selon les rôles.
* **Aide contextuelle intégrée** : des info‑bulles (popovers) expliquent les notions clés du CEDREPS (PPSAD, objet d’enseignement, type d’expérience, FPS, CP, etc.) directement dans les formulaires.
* **Tableau de bord enrichi** : les utilisateurs disposent d’un tableau de bord clair présentant leurs classes et cycles.  Un tableau de bord global (rapports) permet de visualiser la répartition des cycles par ECC.
* **Préparation PWA** : l’application contient un manifeste et un service worker permettant son installation comme application Web hors ligne.

Bonne utilisation !