<?php
require_once __DIR__ . '/functions.php';

// Ensure user is logged in
if (!isLoggedIn()) {
    redirect('login.php');
}
$user = currentUser($pdo);

$cycleId = isset($_GET['cycle_id']) ? (int)$_GET['cycle_id'] : 0;
$cycle = getCycleById($pdo, $cycleId);
if (!$cycle) {
    redirect('dashboard.php');
}
$class = getClassById($pdo, $cycle['class_id']);
// Only teachers or coordinators assigned to the class may create lessons
if (!$class || !userCanAccessClass($pdo, $cycle['class_id'], $user['id']) || (!userHasRole($pdo, 'teacher') && !userHasRole($pdo, 'coordinator'))) {
    redirect('dashboard.php');
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $date = $_POST['lesson_date'] ?? '';
    $title = trim($_POST['title'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $fps = trim($_POST['fps'] ?? '');
    $cp = trim($_POST['cp'] ?? '');
    if (!$date || !$title) {
        $error = "La date et le titre de la leçon sont obligatoires.";
    } else {
        $stmt = $pdo->prepare('INSERT INTO lessons (cycle_id, lesson_date, title, description, fps, cp) VALUES (?, ?, ?, ?, ?, ?)');
        if ($stmt->execute([$cycleId, $date, $title, $description, $fps, $cp])) {
            $success = "Leçon créée avec succès.";
        } else {
            $error = "Erreur lors de la création de la leçon.";
        }
    }
}

$pageTitle = 'Créer une leçon';
include 'header.php';
?>

<div class="mt-4">
    <h2>Ajouter une leçon pour le cycle <?php echo htmlspecialchars($cycle['name']); ?></h2>

    <?php if ($error): ?>
        <div class="alert alert-danger mt-3"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <?php if ($success): ?>
        <div class="alert alert-success mt-3"><?php echo htmlspecialchars($success); ?></div>
    <?php endif; ?>

    <?php $fpsList = getFPSLibrary($pdo); ?>
    <form method="post" action="" class="mt-3">
        <div class="mb-3">
            <label for="lesson_date" class="form-label">
                Date de la leçon
                <i class="bi bi-question-circle-fill ms-1 text-secondary" role="button" tabindex="0" data-bs-toggle="popover" data-bs-trigger="focus" title="Date" data-bs-content="La date de la séance permet de situer et d’ordonner les leçons dans le cycle."></i>
            </label>
            <input type="date" id="lesson_date" name="lesson_date" class="form-control" required>
        </div>
        <div class="mb-3">
            <label for="title" class="form-label">
                Titre de la leçon
                <i class="bi bi-question-circle-fill ms-1 text-secondary" role="button" tabindex="0" data-bs-toggle="popover" data-bs-trigger="focus" title="Titre" data-bs-content="Indiquez un titre court et explicite pour la leçon (ex : ‘Appuis renversés’)."></i>
            </label>
            <input type="text" id="title" name="title" class="form-control" required>
        </div>
        <div class="mb-3">
            <label for="description" class="form-label">
                Description / déroulement
                <i class="bi bi-question-circle-fill ms-1 text-secondary" role="button" tabindex="0" data-bs-toggle="popover" data-bs-trigger="focus" title="Description" data-bs-content="Précisez ici le déroulement de la séance : mise en route, phases d’apprentissage, dispositifs et consignes."></i>
            </label>
            <textarea id="description" name="description" class="form-control" rows="3"></textarea>
        </div>
        <div class="mb-3">
            <label for="fps_select" class="form-label">
                FPS – sélectionner dans la bibliothèque (facultatif)
                <i class="bi bi-question-circle-fill ms-1 text-secondary" role="button" tabindex="0" data-bs-toggle="popover" data-bs-trigger="focus" title="FPS" data-bs-content="La Forme de Pratique Scolaire est la situation de référence ou le jeu servant de support aux apprentissages. Vous pouvez choisir une FPS dans la bibliothèque ou en décrire une vous-même."></i>
            </label>
            <select id="fps_select" name="fps_select" class="form-select">
                <option value="">-- Choisir une forme prédéfinie --</option>
                <?php foreach ($fpsList as $fpsEntry): ?>
                    <option value="<?php echo $fpsEntry['id']; ?>" data-description="<?php echo htmlspecialchars(str_replace('\n', ' ', $fpsEntry['description'])); ?>">
                        <?php echo htmlspecialchars($fpsEntry['ppsad'] . ' – ' . $fpsEntry['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <div class="form-text">Si vous sélectionnez une FPS, sa description sera copiée ci-dessous.</div>
        </div>
        <div class="mb-3">
            <label for="fps" class="form-label">
                FPS – Forme de Pratique Scolaire (jeu ou situation de référence)
                <i class="bi bi-question-circle-fill ms-1 text-secondary" role="button" tabindex="0" data-bs-toggle="popover" data-bs-trigger="focus" title="FPS" data-bs-content="Décrivez ici la situation de référence utilisée pendant la séance : organisation, rôles, matériel. Cette forme doit permettre de travailler l’OE et les CP."></i>
            </label>
            <textarea id="fps" name="fps" class="form-control" rows="2"></textarea>
        </div>
        <div class="mb-3">
            <label for="cp" class="form-label">
                CP – Contenus prioritaires (séparez-les par des sauts de ligne)
                <i class="bi bi-question-circle-fill ms-1 text-secondary" role="button" tabindex="0" data-bs-toggle="popover" data-bs-trigger="focus" title="Contenus prioritaires" data-bs-content="Les contenus prioritaires regroupent les actions motrices, connaissances et attitudes que les élèves doivent acquérir au cours de cette séance. Listez-les séparés par des retours à la ligne."></i>
            </label>
            <textarea id="cp" name="cp" class="form-control" rows="3"></textarea>
        </div>
        <button type="submit" class="btn btn-primary">Créer la leçon</button>
    </form>
</div>

<script>
// When selecting an FPS from the library, copy its description into the textarea
document.getElementById('fps_select').addEventListener('change', function () {
    var select = this;
    var selected = select.options[select.selectedIndex];
    var desc = selected.getAttribute('data-description') || '';
    // Decode HTML entities and replace escaped newlines
    var txt = desc.replace(/\\n/g, "\n");
    document.getElementById('fps').value = txt;
});
</script>

<?php
include 'footer.php';
?>