<?php
require_once __DIR__ . '/functions.php';

// If user not logged in, redirect to login page
if (!isLoggedIn()) {
    redirect('login.php');
}

$user = currentUser($pdo);
$classes = getTeacherClasses($pdo, $user['id']);

$pageTitle = 'Tableau de bord';
include 'header.php';
?>

<div class="mt-4">
    <h2 class="mb-3">Bonjour, <?php echo htmlspecialchars($user['name']); ?> !</h2>
    <p class="mb-4">Utilisez ce tableau de bord pour gérer vos classes, cycles et leçons.</p>

    <?php if (empty($classes)): ?>
        <div class="alert alert-info">Aucune classe n'a encore été créée. <a href="create_class.php" class="alert-link">Ajoutez une première classe</a>.</div>
    <?php else: ?>
        <h3 class="mb-3">Vos classes</h3>
        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
            <?php foreach ($classes as $class): ?>
                <div class="col">
                    <div class="card-modern h-100">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <span class="fs-5 fw-semibold"><?php echo htmlspecialchars($class['name']); ?></span>
                            <span class="badge bg-light text-dark"><?php echo htmlspecialchars($class['level']); ?></span>
                        </div>
                        <div class="card-body d-flex flex-column">
                            <p class="flex-grow-1">Cette classe contient toutes les informations concernant les cycles et les leçons associées.</p>
                            <a href="class_detail.php?id=<?php echo $class['id']; ?>" class="btn btn-primary w-100 mt-auto">Consulter</a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

<?php
include 'footer.php';
?>