--
-- This script inserts a full illustrative volley-ball cycle based on the
-- CEDREPS volleyball example (pages 347‑359 of CEDRE_19).  It creates one
-- cycle associated with the first class (adjust the class_id if necessary)
-- and ten detailed lessons illustrating the progression from OE A
-- (se déplacer et s’orienter pour renvoyer seul ou à deux) vers OE B
-- (enchaîner réception‑attaque).  All the key notions, contraintes,
-- fils rouges, contenus prioritaires (CP) et stratégies pédagogiques
-- sont synthétisés dans the cycle fields below.  Run this script after
-- the initial install scripts to populate the demo data.

-- Adjust this value if your demonstration class has a different id.
SET @demo_class_id = 1;

-- Create the demo cycle.  Text fields contain summaries of OE A et OE B,
-- contraintes emblématiques et d’étayage, fils rouges, CP et méthodes
-- d’évaluation tirés des pages 347‑359 du CEDREPS.
INSERT INTO cycles
    (class_id, name, ppsad, objective, ecc_type, start_date, end_date,
     activity, title, oe, fps, goals, assessment, created_at)
VALUES
    (@demo_class_id,
     'Volley-ball – Cycle illustratif OE A & B',
     'Volley-ball',
     'Apprendre à se déplacer et s’orienter pour renvoyer seul ou à deux (OE A) puis enchaîner réception‑attaque (OE B). Le cycle combine des situations de renvoi en 1 contre 1, 2 contre 2 et 3 contre 3 avec une montée en puissance vers un jeu collectif construit. Les objectifs portent sur la maîtrise des déplacements au point de chute, l’orientation des appuis, la réception et la passe relai pour donner du temps à l’équipe, ainsi que la décision tactique de renvoyer seul ou à plusieurs et de différer ou d’accélérer l’attaque.',
     'Affrontement',
     '2025-01-05', '2025-03-09',
     'Volley-ball',
     'Cycle Volley-ball – OE A & B',
     /* OE details */
     'OE A : déplacement au point de chute du ballon et orientation des appuis pour renvoyer en profondeur. Le joueur apprend à se placer sur la pointe des pieds, à fléchir ses jambes et à orienter ses surfaces de frappe pour renvoyer seul depuis l’espace avant ou à l’aide d’un partenaire depuis l’espace arrière. OE B : enchaînement réception‑attaque. Après une réception à 10 doigts, le joueur relaye ou passe en cloche afin de donner du temps à son équipe et de préparer un smash au point haut, en privant l’adversaire de temps. Les trajectoires (cloche ou tendue), l’orientation du passeur/bloqueur et le contrôle des courses d’élan caractérisent ce deuxième OE.',
     /* FPS details */
     'Contraintes emblématiques (OE A et B) : blocage bref du ballon en première touche pour renvoyer seul ou passer à un partenaire (OE A) ; blocage du ballon en seconde touche pour faire une passe (OE B) ; terrain réduit (4 m × 6 m en OE A, 6 m × 6 m en OE B) avec délimitation d’une zone avant et d’une zone arrière ; service aménagé à 10 doigts depuis le début de la zone arrière ou le milieu du terrain et nombre de services équivalent par joueur ; points marqués en zone arrière et smashs valorisés.  Contraintes d’étayage : matchs en 15 points, filets à 2,10 m/2,20 m (OE A) ou 2,24 m (OE B) selon le niveau ; groupes et équipes respectueux et variés ; contrats de jeu individuels et collectifs ; temps de parole pour analyser les critères d’évaluation ; table de marque précisant équipes, ordre des matchs, répartition des rôles sociaux, contrats et évaluation.  Fils rouges macro (OE A) : nombre de ballons non touchés, nombre de ballons bloqués non renvoyés, nombre de points marqués en zone arrière.  Fils rouges micro (OE A) : attitude dynamique pour être au point de réception ; orientation des appuis pour renvoyer vers l’endroit visé ; rôle des jambes dans la frappe à 10 doigts pour renvoyer loin ; renvoi en 1 touche depuis l’espace avant et en 2 touches depuis l’espace arrière.  Fils rouges macro (OE B) : nombre de ballons qui progressent de la zone arrière à la zone avant (ballons bloqués à deux mains par le passeur au-dessus de sa tête) ; nombre de frappes à une main après conservation.  Fils rouges micro (OE B) : trajectoires différenciées selon conservation (cloche et haute) ou renvoi (tendue) ; orientation du passeur/bloqueur permettant un envoi en avant du partenaire ; frappe devant soi et au point haut pour le smasher ; contrôle des courses d’élan en attaque pour ne pas franchir la ligne médiane.',
     /* Goals / CP details */
     'Contenus prioritaires pour OE A : CP1 – déplacement rapide pour empêcher le ballon de toucher le sol (M : position pré‑active sur la pointe des pieds, Se : prendre l’information sur la frappe d’envoi, I : orienter les appuis vers l’endroit visé) ; CP2 – réception de service pour renvoyer ou conserver (M : frapper au‑dessus de la tête avec les doigts, Se : ne pas faire de bruit et ressentir la poussée des jambes, I : comprendre que le partenaire a besoin de temps, So : se répartir collectivement les zones) ; CP3 – relais d’un ballon provenant d’un partenaire (M : prolonger le renvoi, I : se percevoir comme aide, So : donner du temps au partenaire) ; CP4 – choix du renvoi seul ou à deux (M : utiliser les jambes pour renvoyer loin, I : identifier sa position et choisir la trajectoire, So : coopérer pour relayer).  Contenus prioritaires pour OE B : CP1 – choix d’une attaque immédiate (1 touche) ou différée (3 touches) ; CP2 – réception de service pour produire une trajectoire en cloche vers l’avant (M : frapper au‑dessus de la tête, Se : relever la tête pour prendre des informations, I : privilégier la frappe à 10 doigts, So : se répartir les zones) ; CP3 – passe‑relais pour mettre un partenaire en situation favorable d’attaque (M : orientation partagée entre la réception et la zone visée, I : transmettre le ballon devant le partenaire, So : donner du temps au partenaire) ; CP4 – smash pour donner de la vitesse au ballon vers le bas (M : appel et course d’élan, Se et So : régler le timing de la frappe).',
     /* Assessment details */
     'Évaluation et contrats : les critères d’évaluation reposent sur les fils rouges macro et micro.  Pour OE A, on comptabilise le nombre de ballons non touchés, le nombre de ballons bloqués non renvoyés et les points marqués en zone arrière.  Pour OE B, on mesure le nombre de ballons progressant de la zone arrière à la zone avant et le nombre de frappes à une main après conservation.  Des contrats de match sont donnés (par exemple : marquer au moins 3 fois en zone arrière et réaliser X frappes à 10 doigts sans bruit).  Les matchs sont organisés avec une table de marque et des rôles sociaux (joueurs, observateurs, scoreurs, coaches).  Des temps de parole avant, pendant et après les matches permettent aux élèves d’analyser les critères, d’ajuster leurs choix et d’apprendre à s’évaluer.  La rotation des rôles et des positions garantit que chaque élève expérimente les différents rôles (réceptionneur, relayer, passeur/bloqueur, attaquant) et développe des compétences méthodologiques et sociales.',
     NOW());

-- Capture the auto-generated ID of the cycle for lesson insertion
SET @cycle_id := LAST_INSERT_ID();

-- Insert the 10 detailed lessons that constituent ce cycle.  Each lesson
-- corresponds à une séance d’environ 1 heure en progression croissante.  Les
-- dates sont espacées de 7 jours pour illustrer une planification hebdomadaire.

INSERT INTO lessons (cycle_id, lesson_date, title, fps, cp, description, created_at) VALUES
(@cycle_id, '2025-01-05', 'Séance 1 : Engagement et dynamique de déplacement',
'Jeu en 1 contre 1 pour apprendre l’engagement à 10 doigts et le blocage du ballon en première touche pour renvoyer seul. Les élèves commencent à tenir des rôles d’observateur et d’arbitre en comptant les ballons non touchés et les points. Introduction des déplacements pré‑actifs (sur la pointe des pieds, bras fléchis) et de la lecture de la trajectoire du ballon.',
'CP1 (déplacement) ; CP2 (réception) ; micro fils rouges 1 et 2',
'La séance est centrée sur l’OE A. Après un échauffement, les élèves travaillent l’engagement depuis leur terrain, le blocage bref du ballon et la frappe à 10 doigts pour renvoyer loin. Les rôles sociaux (joueur, observateur) sont mis en place pour compter les ballons non touchés. Discussion collective sur les indicateurs (nombre de ballons non touchés).', NOW()),

(@cycle_id, '2025-01-12', 'Séance 2 : Réception de service et conservation',
'Jeu en 1 contre 1 puis 2 contre 2. Travail de la réception de service : frapper le ballon au‑dessus de la tête, orienter ses appuis et surfaces de frappe vers le haut pour conserver et vers l’avant pour renvoyer. Utilisation d’un terrain 4 m × 6 m avec zones avant et arrière. Introduction du comptage des points marqués en zone arrière.',
'CP2 (réception) ; dimensions Sensibilité et Sociabilité ; micro fil rouge 3 ; renvoi en 1 ou 2 touches',
'Poursuite de l’OE A avec accent sur la réception. Les élèves apprennent à renvoyer en conservant la balle en zone avant ou en envoyant en zone arrière pour mettre l’adversaire en difficulté. Les rôles de service et de réception s’alternent. Dialogue sur l’importance de se déplacer et d’orienter ses appuis.', NOW()),

(@cycle_id, '2025-01-19', 'Séance 3 : Relais et orientation partagée',
'Introduction du jeu à 3 contre 3 avec positionnement en triangle (2 avants et 1 arrière). Travail de la passe‑relais : prolonger le renvoi du ballon à partir d’une orientation partagée, se déplacer pour relayer un partenaire et utiliser l’espace arrière. Organisation des rôles (réceptionneur/relayer, passeur/bloqueur).',
'CP3 (relai) ; micro fils rouges 2 et 3',
'Les élèves découvrent la dimension collective du jeu en 3 contre 3. Le placement en triangle facilite la passe en avant ou en arrière. On insiste sur l’orientation des appuis et la coordination entre réceptionneur et relayer. Les élèves tiennent une table de marque simplifiée pour compter les points marqués en zone arrière et les ballons bloqués non renvoyés.', NOW()),

(@cycle_id, '2025-01-26', 'Séance 4 : Choix du renvoi et décision tactique',
'Jeu en 3 contre 3. Mise en situation de décision : renvoyer seul depuis l’espace avant (1 touche) ou utiliser un partenaire depuis l’espace arrière (2 touches). Les élèves travaillent la lecture de trajectoire et la décision en fonction de leur position sur le terrain. Utilisation d’un contrat : marquer X points en zone arrière ou réaliser Y renvois à 2 touches.',
'CP4 (choix du renvoi) ; macro et micro fils rouges de l’OE A',
'La séance met en avant la prise de décision. Les élèves apprennent à évaluer s’il est plus pertinent de renvoyer seul ou à deux. Des contrats de match récompensent les bonnes décisions (par exemple : points bonus pour les renvois à 2 touches et les points marqués en zone arrière).', NOW()),

(@cycle_id, '2025-02-02', 'Séance 5 : Rotation des rôles et temps de parole',
'Jeu en 3 contre 3. Mise en rotation systématique des rôles (joueur, observateur, coach, marqueur) pour que tous les élèves expérimentent les rôles moteurs et sociaux. Organisation de temps de parole avant, pendant et après les matchs pour analyser les critères d’évaluation (fils rouges) et ajuster les contrats.',
'Consolidation des CP1 à CP4 et des dimensions Sensibilité et Sociabilité',
'L’enseignant met l’accent sur l’autonomie et l’apprentissage méthodologique. Les élèves tiennent la table de marque, analysent les résultats et proposent des solutions. Ils discutent des fils rouges et des contenus prioritaires pour réguler leur jeu.', NOW()),

(@cycle_id, '2025-02-09', 'Séance 6 : Situation spécifique CP1 – déplacement',
'Exercices de duels et de relais sans ballon : déplacements rapides sur la pointe des pieds, orientation des appuis vers l’endroit visé, déplacement après la frappe et lecture de la trajectoire. Enchaînement de déplacements dans un espace réduit avec blocage en première touche.',
'CP1 (déplacement) détaillé ; micro fils rouges 1 et 2',
'On sort du jeu pour travailler le déplacement en isolation. Les élèves enchaînent des exercices de vivacité et d’orientation, puis réintègrent ces déplacements dans des situations de 2 contre 2. Les indicateurs (nombre de ballons non touchés) servent à mesurer les progrès.', NOW()),

(@cycle_id, '2025-02-16', 'Séance 7 : Situation spécifique CP2 – réception de service',
'Travail de la réception en touche haute depuis un envoi lancé ou frappé. Les élèves doivent produire une trajectoire en cloche vers l’avant pour conserver la balle ou une trajectoire tendue pour renvoyer. Le rôle des jambes est souligné (pousser pour renvoyer loin).',
'CP2 (réception) ; micro fil rouge 3',
'Après des ateliers de réception, les élèves s’entraînent en 2 contre 2 puis 3 contre 3. On évalue la qualité des réceptions (trajectoire, orientation). Les élèves utilisent les temps morts pour débriefer sur leurs sensations et ajuster leurs choix.', NOW()),

(@cycle_id, '2025-02-23', 'Séance 8 : Situation spécifique CP3 – passe‑relais',
'Exercices de passe‑relais : se placer préalablement en orientation partagée, transmettre le ballon en avant du partenaire et se replacer pour une nouvelle réception. Travail de la coordination et du timing entre réceptionneur et relayer.',
'CP3 (passe‑relais) ; micro fils rouges 2 et 3',
'Les élèves répètent des séquences de passe‑relais puis les intègrent dans un jeu en 3 contre 3. Les critères d’évaluation portent sur la qualité du relai (orientation, timing) et le nombre de ballons progressant de la zone arrière à l’avant.', NOW()),

(@cycle_id, '2025-03-02', 'Séance 9 : Situation spécifique CP4 – choix du renvoi et transition vers OE B',
'Situations de décision rapide : choix d’une attaque immédiate ou différée. Les élèves apprennent à identifier les situations favorables (balle haute et proche du filet) et défavorables (balle basse ou éloignée) et à transférer le ballon dans la zone avant via relai ou passe haute. Introduction de l’enchaînement réception‑attaque : réception à 10 doigts puis smash ou passe relayée.',
'CP4 (choix du renvoi) + CP1/CP2 de l’OE B',
'Cette séance prépare la deuxième partie du cycle (OE B). Les élèves identifient les moments où ils peuvent smasher immédiatement ou doivent différer l’attaque en conservant la balle. On introduit les trajectoires en cloche et les passes relayées pour préparer l’enchaînement réception‑attaque.', NOW()),

(@cycle_id, '2025-03-09', 'Séance 10 : Enchaînement réception‑attaque',
'Jeu en 3 contre 3 sur un terrain de 6 m × 6 m avec zones avant et arrière. Travail complet de l’enchaînement réception‑attaque : réception à 10 doigts, passe en cloche vers le passeur/bloqueur, course d’élan et smash. Les rôles (réceptionneur/attaquant et passeur/bloqueur) tournent régulièrement. Les contrats valorisent le nombre de ballons progressant de l’arrière à l’avant et le nombre de smashs réussis après conservation.',
'CP1 à CP4 de l’OE B ; micro fils rouges (trajectoires cloche/tendues, orientation du passeur, frappe devant soi, contrôle des courses d’élan)',
'Les élèves mettent en œuvre l’OE B en entier. On insiste sur la coordination entre réception, relai et smash. Les évaluations portent sur les ballons progressant de la zone arrière à la zone avant et sur les frappes à une main après conservation. Les discussions collectives soulignent l’importance du temps donné à l’équipe et des décisions tactiques.', NOW());