<?php
require_once __DIR__ . '/functions.php';

// If already logged in, redirect to dashboard
if (isLoggedIn()) {
    redirect('dashboard.php');
}

$error = '';
$success = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm = $_POST['confirm'] ?? '';
    $role = $_POST['role'] ?? 'teacher';
    if ($password !== $confirm) {
        $error = "Les mots de passe ne correspondent pas.";
    } elseif (!$name || !$email || !$password) {
        $error = "Tous les champs sont requis.";
    } else {
        if (registerUser($pdo, $name, $email, $password, $role)) {
            $success = "Compte créé avec succès. Vous pouvez maintenant vous connecter.";
        } else {
            $error = "Cette adresse email est déjà utilisée.";
        }
    }
}

$pageTitle = 'Inscription';
include 'header.php';
?>

<h2>Créer un compte</h2>

<?php if ($error): ?>
    <div class="alert alert-danger mt-3"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>
<?php if ($success): ?>
    <div class="alert alert-success mt-3"><?php echo htmlspecialchars($success); ?></div>
<?php endif; ?>

<form method="post" action="" class="mt-3">
    <div class="mb-3">
        <label for="name" class="form-label">Nom complet</label>
        <input type="text" id="name" name="name" class="form-control" required>
    </div>
    <div class="mb-3">
        <label for="email" class="form-label">Adresse email</label>
        <input type="email" id="email" name="email" class="form-control" required>
    </div>
    <div class="mb-3">
        <label for="password" class="form-label">Mot de passe</label>
        <input type="password" id="password" name="password" class="form-control" required>
    </div>
    <div class="mb-3">
        <label for="confirm" class="form-label">Confirmer le mot de passe</label>
        <input type="password" id="confirm" name="confirm" class="form-control" required>
    </div>
    <div class="mb-3">
        <label for="role" class="form-label">Rôle</label>
        <select id="role" name="role" class="form-select">
            <option value="teacher">Enseignant</option>
            <option value="student">Élève</option>
        </select>
    </div>
    <button type="submit" class="btn btn-primary">Créer le compte</button>
</form>

<?php
include 'footer.php';
?>