<?php
/**
 * ╔══════════════════════════════════════════════════════════════╗
 * ║        CEDREPS ULTIMATE - Configuration Simplifiée            ║
 * ║              Version compatible avec votre setup              ║
 * ╚══════════════════════════════════════════════════════════════╝
 */

// ===================================================================
// CONFIGURATION DIRECTE (sans .env)
// ===================================================================

// Configuration de votre NOUVELLE base de données CEDREPS Ultimate
// MODIFIEZ CES VALEURS avec vos identifiants de la nouvelle base
$config = [
    'app' => [
        'name' => 'CEDREPS Ultimate',
        'version' => '2.0',
        'tagline' => 'L\'EPS guidée et intelligente',
        'url' => 'https://' . ($_SERVER['HTTP_HOST'] ?? 'localhost') . '/app_v5',
        'env' => 'production',
        'debug' => false,
        'key' => 'h5j8K9lM2nP4qR7sT9uV3wX5yZ2aB4cD'
    ],
    
    'database' => [
        // 🔴 MODIFIEZ ICI AVEC VOS IDENTIFIANTS DE LA NOUVELLE BASE
        'host' => 'localhost',
        'name' => 'epsweb_cedreps_ultimate',  // Nom de votre NOUVELLE base
        'user' => 'epsweb_cedreps_ultimate',  // Utilisateur de la NOUVELLE base
        'pass' => '48oRDRRn)u,5', // Mot de passe de la NOUVELLE base
        'charset' => 'utf8mb4'
    ],
    
    // Configuration de l'ANCIENNE base pour la migration
    'old_database' => [
        'host' => 'localhost',
        'name' => 'epsweb_appli',
        'user' => 'epsweb_appli',
        'pass' => 'MF03444janvierA',
        'charset' => 'utf8mb4'
    ],
    
    'mail' => [
        'host' => 'localhost',
        'port' => 465,
        'username' => 'noreply@' . ($_SERVER['HTTP_HOST'] ?? 'localhost'),
        'password' => '',
        'from' => 'noreply@' . ($_SERVER['HTTP_HOST'] ?? 'localhost'),
        'encryption' => 'ssl'
    ],
    
    'paths' => [
        'root' => __DIR__,
        'uploads' => __DIR__ . '/uploads',
        'temp' => __DIR__ . '/temp',
        'logs' => __DIR__ . '/logs',
        'cache' => __DIR__ . '/cache',
        'exports' => __DIR__ . '/exports'
    ],
    
    'security' => [
        'session_name' => 'cedreps_session',
        'csrf_token_name' => 'cedreps_token',
        'password_min_length' => 8,
        'max_login_attempts' => 5,
        'lockout_duration' => 900,
        'force_ssl' => true
    ]
];

// ===================================================================
// CRÉATION DES DOSSIERS NÉCESSAIRES
// ===================================================================

$required_dirs = [
    $config['paths']['uploads'],
    $config['paths']['temp'],
    $config['paths']['logs'],
    $config['paths']['cache'],
    $config['paths']['exports']
];

foreach ($required_dirs as $dir) {
    if (!is_dir($dir)) {
        @mkdir($dir, 0755, true);
        
        // Créer un index.html pour protéger le dossier
        $index_content = '<!DOCTYPE html><html><head><title>403 Forbidden</title></head><body>Directory access is forbidden.</body></html>';
        @file_put_contents($dir . '/index.html', $index_content);
    }
}

// ===================================================================
// CONNEXION À LA BASE DE DONNÉES
// ===================================================================

try {
    $pdo = new PDO(
        sprintf(
            "mysql:host=%s;dbname=%s;charset=%s",
            $config['database']['host'],
            $config['database']['name'],
            $config['database']['charset']
        ),
        $config['database']['user'],
        $config['database']['pass'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
        ]
    );
    
    // Connexion réussie
    define('DB_CONNECTED', true);
    
} catch (PDOException $e) {
    // Erreur de connexion
    define('DB_CONNECTED', false);
    
    // Log l'erreur
    $log_file = $config['paths']['logs'] . '/error.log';
    $log_message = date('Y-m-d H:i:s') . ' - DB Error: ' . $e->getMessage() . PHP_EOL;
    @file_put_contents($log_file, $log_message, FILE_APPEND);
    
    // Si on est pas en ligne de commande, afficher une page d'erreur
    if (PHP_SAPI !== 'cli') {
        http_response_code(503);
        ?>
        <!DOCTYPE html>
        <html lang="fr">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Configuration Base de Données - CEDREPS Ultimate</title>
            <style>
                body {
                    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    min-height: 100vh;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    margin: 0;
                    padding: 20px;
                }
                .container {
                    background: white;
                    border-radius: 20px;
                    box-shadow: 0 25px 50px -12px rgba(0,0,0,0.25);
                    max-width: 600px;
                    padding: 40px;
                }
                h1 { 
                    color: #1F2937; 
                    margin-top: 0;
                    font-size: 24px;
                }
                .alert {
                    background: #FEF2F2;
                    border-left: 4px solid #EF4444;
                    padding: 15px;
                    margin: 20px 0;
                    border-radius: 8px;
                }
                .info {
                    background: #EFF6FF;
                    border-left: 4px solid #3B82F6;
                    padding: 15px;
                    margin: 20px 0;
                    border-radius: 8px;
                }
                .success {
                    background: #F0FDF4;
                    border-left: 4px solid #10B981;
                    padding: 15px;
                    margin: 20px 0;
                    border-radius: 8px;
                }
                code {
                    background: #F3F4F6;
                    padding: 4px 8px;
                    border-radius: 4px;
                    font-family: monospace;
                    font-size: 14px;
                    color: #EF4444;
                }
                .steps {
                    background: #F9FAFB;
                    border-radius: 12px;
                    padding: 20px;
                    margin: 20px 0;
                }
                ol { 
                    margin: 10px 0; 
                    padding-left: 20px;
                }
                li { 
                    margin: 8px 0;
                    line-height: 1.6;
                }
                .code-box {
                    background: #1F2937;
                    color: #10B981;
                    padding: 15px;
                    border-radius: 8px;
                    font-family: monospace;
                    font-size: 13px;
                    overflow-x: auto;
                }
                .btn {
                    display: inline-block;
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    color: white;
                    padding: 12px 24px;
                    border-radius: 8px;
                    text-decoration: none;
                    font-weight: 600;
                    margin-top: 20px;
                }
            </style>
        </head>
        <body>
            <div class="container">
                <h1>⚙️ Configuration de la Base de Données</h1>
                
                <div class="alert">
                    <strong>⚠️ Impossible de se connecter à la base de données</strong>
                    <p>La connexion à la base de données CEDREPS Ultimate a échoué.</p>
                </div>
                
                <div class="info">
                    <strong>📋 Configuration actuelle :</strong>
                    <ul style="margin-top: 10px;">
                        <li>Host : <code>localhost</code></li>
                        <li>Base : <code><?php echo $config['database']['name']; ?></code></li>
                        <li>User : <code><?php echo $config['database']['user']; ?></code></li>
                    </ul>
                </div>
                
                <div class="steps">
                    <strong>🚀 Comment corriger :</strong>
                    <ol>
                        <li>
                            <strong>Créez la nouvelle base de données dans cPanel</strong><br>
                            → MySQL Database Wizard<br>
                            → Créez : <code>epsweb_cedreps</code>
                        </li>
                        <li>
                            <strong>Créez l'utilisateur MySQL</strong><br>
                            → User : <code>epsweb_cedreps</code><br>
                            → Accordez tous les privilèges
                        </li>
                        <li>
                            <strong>Modifiez ce fichier config.php</strong><br>
                            Ligne 28-31 : Mettez vos identifiants
                            <div class="code-box" style="margin-top: 10px;">
'database' => [<br>
&nbsp;&nbsp;&nbsp;&nbsp;'host' => 'localhost',<br>
&nbsp;&nbsp;&nbsp;&nbsp;'name' => 'epsweb_cedreps',  // Votre nouvelle base<br>
&nbsp;&nbsp;&nbsp;&nbsp;'user' => 'epsweb_cedreps',  // Votre utilisateur<br>
&nbsp;&nbsp;&nbsp;&nbsp;'pass' => 'VotreMotDePasse', // Votre mot de passe<br>
]
                            </div>
                        </li>
                        <li>
                            <strong>Importez la structure dans phpMyAdmin</strong><br>
                            → Sélectionnez la nouvelle base<br>
                            → Import → <code>database_structure_v2.sql</code>
                        </li>
                    </ol>
                </div>
                
                <div class="success">
                    <strong>💡 Note :</strong> Votre ancienne base <code>epsweb_appli</code> est configurée et sera utilisée pour la migration.
                </div>
                
                <?php if ($config['app']['debug']): ?>
                <div class="alert">
                    <strong>🐛 Erreur technique :</strong>
                    <p style="font-family: monospace; font-size: 12px; margin-top: 10px;">
                        <?php echo htmlspecialchars($e->getMessage()); ?>
                    </p>
                </div>
                <?php endif; ?>
                
                <a href="<?php echo $_SERVER['REQUEST_URI']; ?>" class="btn">🔄 Réessayer</a>
            </div>
        </body>
        </html>
        <?php
        exit;
    }
}

// ===================================================================
// FONCTIONS UTILITAIRES
// ===================================================================

/**
 * Obtenir la connexion PDO
 */
function getDB() {
    global $pdo;
    return $pdo;
}

/**
 * Obtenir l'URL de base
 */
function getBaseUrl() {
    global $config;
    return $config['app']['url'];
}

/**
 * Obtenir un chemin
 */
function getPath($key) {
    global $config;
    return $config['paths'][$key] ?? null;
}

/**
 * Vérifier si on est en mode debug
 */
function isDebug() {
    global $config;
    return $config['app']['debug'];
}

/**
 * Logger un message
 */
function logMessage($message, $type = 'info') {
    global $config;
    
    $log_file = $config['paths']['logs'] . '/' . $type . '.log';
    $log_message = date('Y-m-d H:i:s') . ' - ' . $message . PHP_EOL;
    @file_put_contents($log_file, $log_message, FILE_APPEND);
}

// ===================================================================
// SESSION ET SÉCURITÉ
// ===================================================================

// Démarrer la session si pas déjà démarrée
if (session_status() === PHP_SESSION_NONE && PHP_SAPI !== 'cli') {
    session_name($config['security']['session_name']);
    session_start();
}

// ===================================================================
// INCLUSION DES FONCTIONS SI ELLES EXISTENT
// ===================================================================

if (file_exists(__DIR__ . '/functions.php')) {
    require_once __DIR__ . '/functions.php';
}

// Configuration chargée avec succès !
?>