<?php
/**
 * ╔══════════════════════════════════════════════════════════════╗
 * ║           CEDREPS ULTIMATE - Création Guidée de FPS          ║
 * ║                Assistant IA & Guidage Complet                 ║
 * ╚══════════════════════════════════════════════════════════════╝
 */

require_once 'config.php';
require_once 'functions.php';

// Vérification authentification
if (!isAuthenticated()) {
    header('Location: login.php');
    exit;
}

$user = getCurrentUser();
$step = $_GET['step'] ?? 1;
$cycleId = $_GET['cycle'] ?? null;

// Récupération des données CEDREPS
$eccTypes = getConfig('cedreps.ecc_types');
$guidedSteps = getConfig('cedreps.guided_steps');
?>
<!DOCTYPE html>
<html lang="fr" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Création de FPS Guidée - CEDREPS Ultimate</title>
    
    <!-- Styles -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link rel="stylesheet" href="https://unpkg.com/aos@2.3.1/dist/aos.css">
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    
    <!-- Typed.js for typing effect -->
    <script src="https://unpkg.com/typed.js@2.0.16/dist/typed.umd.js"></script>
    
    <!-- SweetAlert2 for beautiful alerts -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Shepherd.js for guided tour -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/shepherd.js@11.2.0/dist/css/shepherd.css"/>
    <script src="https://cdn.jsdelivr.net/npm/shepherd.js@11.2.0/dist/js/shepherd.min.js"></script>
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@100..900&family=Outfit:wght@100..900&display=swap');
        
        * { font-family: 'Inter', system-ui, sans-serif; }
        h1, h2, h3, h4, h5, h6 { font-family: 'Outfit', sans-serif; }
        
        .step-indicator {
            position: relative;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 4px;
            border-radius: 2px;
            overflow: hidden;
        }
        
        .step-progress {
            position: absolute;
            left: 0;
            top: 0;
            height: 100%;
            background: white;
            transition: width 0.5s ease;
        }
        
        .concept-card {
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
        }
        
        .concept-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        
        .concept-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #667eea, #764ba2, #f093fb, #f5576c);
            background-size: 200% 100%;
            animation: gradient-shift 3s ease infinite;
        }
        
        @keyframes gradient-shift {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        
        .glow-button {
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
        }
        
        .glow-button::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.5);
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }
        
        .glow-button:hover::before {
            width: 300px;
            height: 300px;
        }
        
        .tooltip-cedreps {
            position: relative;
            cursor: help;
        }
        
        .tooltip-cedreps:hover::after {
            content: attr(data-tooltip);
            position: absolute;
            bottom: 125%;
            left: 50%;
            transform: translateX(-50%);
            background: #1F2937;
            color: white;
            padding: 8px 12px;
            border-radius: 8px;
            white-space: nowrap;
            font-size: 14px;
            z-index: 1000;
            animation: fadeIn 0.3s;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        .ai-thinking {
            display: inline-block;
            animation: pulse 1.5s ease-in-out infinite;
        }
        
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.5; }
        }
    </style>
</head>
<body class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100" x-data="fpsCreator">
    
    <!-- Progress Header -->
    <header class="bg-white shadow-sm sticky top-0 z-40">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="py-4">
                <!-- Steps Progress -->
                <div class="flex items-center justify-between mb-4">
                    <h1 class="text-2xl font-bold bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">
                        Création Guidée de FPS
                    </h1>
                    <div class="flex items-center space-x-4">
                        <button @click="showHelp()" class="text-gray-500 hover:text-blue-600 transition">
                            <i class="fas fa-question-circle text-xl"></i>
                        </button>
                        <button @click="saveProgress()" class="bg-gray-100 hover:bg-gray-200 px-4 py-2 rounded-lg transition">
                            <i class="fas fa-save mr-2"></i> Sauvegarder
                        </button>
                        <button @click="exitCreation()" class="text-gray-500 hover:text-red-600 transition">
                            <i class="fas fa-times text-xl"></i>
                        </button>
                    </div>
                </div>
                
                <!-- Visual Steps -->
                <div class="flex items-center justify-between">
                    <template x-for="(step, index) in steps" :key="index">
                        <div class="flex-1 flex items-center">
                            <div class="relative">
                                <div class="w-10 h-10 rounded-full flex items-center justify-center transition-all duration-300"
                                     :class="{
                                         'bg-gradient-to-r from-green-500 to-green-600 text-white': index < currentStep,
                                         'bg-gradient-to-r from-blue-500 to-purple-600 text-white animate-pulse': index === currentStep,
                                         'bg-gray-200 text-gray-400': index > currentStep
                                     }">
                                    <i :class="step.icon" class="text-sm"></i>
                                </div>
                                <span class="absolute -bottom-6 left-1/2 transform -translate-x-1/2 text-xs whitespace-nowrap"
                                      :class="index <= currentStep ? 'text-gray-900 font-semibold' : 'text-gray-400'"
                                      x-text="step.name"></span>
                            </div>
                            <div x-show="index < steps.length - 1" class="flex-1 h-0.5 mx-2"
                                 :class="index < currentStep ? 'bg-green-500' : 'bg-gray-300'"></div>
                        </div>
                    </template>
                </div>
            </div>
        </div>
    </header>
    
    <!-- Main Content -->
    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        
        <!-- AI Assistant Floating -->
        <div class="fixed bottom-8 right-8 z-50" x-show="aiAssistantVisible" x-transition>
            <div class="bg-white rounded-2xl shadow-2xl p-6 max-w-sm" data-aos="fade-up">
                <div class="flex items-start space-x-3">
                    <div class="w-10 h-10 rounded-full bg-gradient-to-r from-purple-500 to-pink-500 flex items-center justify-center text-white flex-shrink-0">
                        <i class="fas fa-robot"></i>
                    </div>
                    <div class="flex-1">
                        <h4 class="font-semibold text-gray-900 mb-1">Assistant IA CEDREPS</h4>
                        <p class="text-sm text-gray-600" x-html="aiMessage"></p>
                        <div class="mt-3 flex space-x-2">
                            <button @click="acceptAISuggestion()" 
                                    class="bg-purple-500 hover:bg-purple-600 text-white px-3 py-1 rounded-lg text-sm transition">
                                Accepter
                            </button>
                            <button @click="rejectAISuggestion()" 
                                    class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-3 py-1 rounded-lg text-sm transition">
                                Autre suggestion
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Step 1: Context Analysis -->
        <div x-show="currentStep === 0" x-transition>
            <div class="bg-white rounded-2xl shadow-xl p-8" data-aos="fade-up">
                <h2 class="text-3xl font-bold mb-2">📊 Étape 1 : Analyse du Contexte</h2>
                <p class="text-gray-600 mb-8">Commençons par comprendre votre situation d'enseignement</p>
                
                <!-- Interactive Context Form -->
                <div class="space-y-6">
                    <!-- Classe Selection -->
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Sélectionnez votre classe
                            <span class="tooltip-cedreps ml-1" data-tooltip="La classe pour laquelle vous créez cette FPS">
                                <i class="fas fa-info-circle text-blue-500"></i>
                            </span>
                        </label>
                        <div class="grid grid-cols-3 gap-4">
                            <div @click="selectClass('6A')" 
                                 class="concept-card bg-white border-2 border-gray-200 rounded-xl p-4 cursor-pointer hover:border-blue-500 transition">
                                <h3 class="font-semibold">6ème A</h3>
                                <p class="text-sm text-gray-500 mt-1">28 élèves • Niveau hétérogène</p>
                                <div class="mt-3 flex flex-wrap gap-1">
                                    <span class="text-xs bg-blue-100 text-blue-600 px-2 py-0.5 rounded">Débutants: 12</span>
                                    <span class="text-xs bg-green-100 text-green-600 px-2 py-0.5 rounded">Intermédiaires: 10</span>
                                    <span class="text-xs bg-purple-100 text-purple-600 px-2 py-0.5 rounded">Avancés: 6</span>
                                </div>
                            </div>
                            <!-- Autres classes... -->
                        </div>
                    </div>
                    
                    <!-- Période -->
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Période du cycle
                            <span class="tooltip-cedreps ml-1" data-tooltip="Quand se déroulera votre cycle ?">
                                <i class="fas fa-info-circle text-blue-500"></i>
                            </span>
                        </label>
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="text-xs text-gray-500">Date de début</label>
                                <input type="date" v-model="cycleStartDate" 
                                       class="w-full mt-1 px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>
                            <div>
                                <label class="text-xs text-gray-500">Date de fin</label>
                                <input type="date" v-model="cycleEndDate" 
                                       class="w-full mt-1 px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>
                        </div>
                    </div>
                    
                    <!-- Installations disponibles -->
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Installations disponibles
                            <span class="tooltip-cedreps ml-1" data-tooltip="Les espaces et matériels à votre disposition">
                                <i class="fas fa-info-circle text-blue-500"></i>
                            </span>
                        </label>
                        <div class="grid grid-cols-4 gap-3">
                            <label class="flex items-center space-x-2 cursor-pointer">
                                <input type="checkbox" class="rounded text-blue-600">
                                <span class="text-sm">Gymnase</span>
                            </label>
                            <label class="flex items-center space-x-2 cursor-pointer">
                                <input type="checkbox" class="rounded text-blue-600">
                                <span class="text-sm">Terrain extérieur</span>
                            </label>
                            <label class="flex items-center space-x-2 cursor-pointer">
                                <input type="checkbox" class="rounded text-blue-600">
                                <span class="text-sm">Piscine</span>
                            </label>
                            <label class="flex items-center space-x-2 cursor-pointer">
                                <input type="checkbox" class="rounded text-blue-600">
                                <span class="text-sm">Dojo</span>
                            </label>
                        </div>
                    </div>
                    
                    <!-- Objectifs prioritaires -->
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Vos objectifs prioritaires
                            <span class="tooltip-cedreps ml-1" data-tooltip="Qu'est-ce qui est le plus important pour vous ?">
                                <i class="fas fa-info-circle text-blue-500"></i>
                            </span>
                        </label>
                        <div class="space-y-2">
                            <label class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 cursor-pointer">
                                <input type="radio" name="priority" class="text-blue-600">
                                <span class="ml-3">
                                    <span class="font-medium">Inclusion</span>
                                    <span class="text-sm text-gray-500 block">Permettre à tous les élèves de progresser</span>
                                </span>
                            </label>
                            <label class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 cursor-pointer">
                                <input type="radio" name="priority" class="text-blue-600">
                                <span class="ml-3">
                                    <span class="font-medium">Performance</span>
                                    <span class="text-sm text-gray-500 block">Développer les capacités physiques</span>
                                </span>
                            </label>
                            <label class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 cursor-pointer">
                                <input type="radio" name="priority" class="text-blue-600">
                                <span class="ml-3">
                                    <span class="font-medium">Coopération</span>
                                    <span class="text-sm text-gray-500 block">Favoriser le travail en équipe</span>
                                </span>
                            </label>
                        </div>
                    </div>
                </div>
                
                <!-- Navigation -->
                <div class="mt-8 flex justify-between">
                    <button class="text-gray-500 hover:text-gray-700 transition">
                        <i class="fas fa-arrow-left mr-2"></i> Retour
                    </button>
                    <button @click="nextStep()" 
                            class="glow-button bg-gradient-to-r from-blue-500 to-purple-600 text-white px-6 py-3 rounded-lg font-semibold hover:shadow-lg transition">
                        Continuer <i class="fas fa-arrow-right ml-2"></i>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Step 2: Choose ECC -->
        <div x-show="currentStep === 1" x-transition>
            <div class="bg-white rounded-2xl shadow-xl p-8" data-aos="fade-up">
                <h2 class="text-3xl font-bold mb-2">🎯 Étape 2 : Choisir une Expérience Corporelle et Culturelle</h2>
                <p class="text-gray-600 mb-8">Les ECC représentent les grandes familles d'expériences en EPS</p>
                
                <!-- ECC Explanation Video/Animation -->
                <div class="bg-gradient-to-r from-blue-50 to-purple-50 rounded-xl p-6 mb-8">
                    <div class="flex items-start space-x-4">
                        <div class="w-12 h-12 rounded-full bg-white flex items-center justify-center flex-shrink-0">
                            <i class="fas fa-play text-purple-500"></i>
                        </div>
                        <div class="flex-1">
                            <h3 class="font-semibold mb-2">💡 Comprendre les ECC en 2 minutes</h3>
                            <p class="text-sm text-gray-600 mb-3">
                                Les Expériences Corporelles et Culturelles sont au cœur de l'approche CEDREPS. 
                                Elles permettent de structurer l'enseignement autour de 6 grandes familles d'activités, 
                                chacune avec ses propres enjeux éducatifs et symboliques.
                            </p>
                            <button class="bg-purple-500 hover:bg-purple-600 text-white px-4 py-2 rounded-lg text-sm transition">
                                <i class="fas fa-play mr-2"></i> Voir la vidéo explicative
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- ECC Grid Selection -->
                <div class="grid grid-cols-2 gap-6">
                    <?php foreach ($eccTypes as $ecc): ?>
                    <div @click="selectECC('<?= $ecc['code'] ?>')" 
                         class="concept-card bg-white border-2 border-gray-200 rounded-xl p-6 cursor-pointer hover:border-blue-500 transition group">
                        <div class="flex items-start space-x-4">
                            <div class="w-14 h-14 rounded-xl flex items-center justify-center text-white text-xl flex-shrink-0"
                                 style="background: <?= $ecc['gradient'] ?>">
                                <i class="fas fa-<?= $ecc['icon'] ?>"></i>
                            </div>
                            <div class="flex-1">
                                <h3 class="font-bold text-lg mb-1"><?= $ecc['name'] ?></h3>
                                <p class="text-sm text-gray-600 mb-3"><?= $ecc['description'] ?></p>
                                
                                <!-- Mobiles -->
                                <div class="mb-3">
                                    <h4 class="text-xs font-semibold text-gray-500 mb-1">Mobiles du pratiquant :</h4>
                                    <p class="text-xs text-gray-600"><?= $ecc['mobiles'] ?></p>
                                </div>
                                
                                <!-- PPSAD Examples -->
                                <div>
                                    <h4 class="text-xs font-semibold text-gray-500 mb-1">PPSAD associées :</h4>
                                    <div class="flex flex-wrap gap-1">
                                        <?php foreach ($ecc['ppsad_examples'] as $ppsad): ?>
                                        <span class="text-xs bg-gray-100 text-gray-600 px-2 py-0.5 rounded">
                                            <?= $ppsad ?>
                                        </span>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                                
                                <!-- Selection Indicator -->
                                <div class="mt-4 opacity-0 group-hover:opacity-100 transition">
                                    <span class="text-sm text-blue-600 font-semibold">
                                        <i class="fas fa-hand-pointer mr-1"></i> Cliquez pour sélectionner
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                
                <!-- AI Recommendation -->
                <div class="mt-8 bg-gradient-to-r from-purple-50 to-pink-50 rounded-xl p-6">
                    <h3 class="font-semibold mb-3">
                        <i class="fas fa-magic mr-2 text-purple-500"></i>
                        Recommandation de l'IA basée sur votre contexte
                    </h3>
                    <div class="bg-white rounded-lg p-4 border-l-4 border-purple-500">
                        <p class="text-sm text-gray-700">
                            <span class="ai-thinking">Analyse en cours...</span> 
                            Pour votre classe de 6ème A avec des objectifs de coopération, 
                            je recommande <strong>l'ECC4 - Confrontation & Coopération</strong>. 
                            Cette expérience permet de développer les compétences collectives tout en maintenant 
                            l'engagement de tous les élèves.
                        </p>
                    </div>
                </div>
                
                <!-- Navigation -->
                <div class="mt-8 flex justify-between">
                    <button @click="previousStep()" class="text-gray-500 hover:text-gray-700 transition">
                        <i class="fas fa-arrow-left mr-2"></i> Retour
                    </button>
                    <button @click="nextStep()" 
                            class="glow-button bg-gradient-to-r from-blue-500 to-purple-600 text-white px-6 py-3 rounded-lg font-semibold hover:shadow-lg transition">
                        Continuer <i class="fas fa-arrow-right ml-2"></i>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Step 3: Choose PPSAD -->
        <div x-show="currentStep === 2" x-transition>
            <div class="bg-white rounded-2xl shadow-xl p-8" data-aos="fade-up">
                <h2 class="text-3xl font-bold mb-2">⚽ Étape 3 : Choisir une PPSAD</h2>
                <p class="text-gray-600 mb-8">Sélectionnez la Pratique Physique Sportive Artistique et de Développement</p>
                
                <!-- PPSAD Filter and Search -->
                <div class="mb-6 flex space-x-4">
                    <div class="flex-1">
                        <div class="relative">
                            <input type="search" placeholder="Rechercher une PPSAD..." 
                                   class="w-full pl-10 pr-4 py-3 bg-gray-100 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <i class="fas fa-search absolute left-3 top-3.5 text-gray-400"></i>
                        </div>
                    </div>
                    <select class="px-4 py-3 bg-gray-100 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option>Toutes les catégories</option>
                        <option>Sports collectifs</option>
                        <option>Sports de raquette</option>
                        <option>Activités athlétiques</option>
                        <option>Activités aquatiques</option>
                        <option>Activités artistiques</option>
                    </select>
                </div>
                
                <!-- PPSAD Grid -->
                <div class="grid grid-cols-3 gap-4 mb-8">
                    <div class="bg-white border-2 border-blue-500 rounded-xl p-4 cursor-pointer">
                        <div class="flex items-center space-x-3 mb-3">
                            <div class="w-10 h-10 rounded-lg bg-blue-100 flex items-center justify-center text-blue-600">
                                <i class="fas fa-futbol"></i>
                            </div>
                            <h4 class="font-semibold">Handball</h4>
                        </div>
                        <p class="text-xs text-gray-600 mb-2">Sport collectif d'opposition</p>
                        <div class="flex items-center justify-between">
                            <span class="text-xs bg-green-100 text-green-600 px-2 py-0.5 rounded">Recommandé</span>
                            <span class="text-xs text-gray-500">15 FPS disponibles</span>
                        </div>
                    </div>
                    <!-- Autres PPSAD... -->
                </div>
                
                <!-- Detailed PPSAD Info -->
                <div class="bg-gradient-to-r from-blue-50 to-cyan-50 rounded-xl p-6">
                    <h3 class="font-semibold mb-3">📖 Fonds Culturel du Handball</h3>
                    <div class="grid grid-cols-3 gap-4">
                        <div>
                            <h4 class="text-sm font-semibold text-gray-700 mb-2">Mobiles du pratiquant</h4>
                            <p class="text-xs text-gray-600">
                                Gagner collectivement, élaborer des stratégies, s'opposer dans le respect des règles
                            </p>
                        </div>
                        <div>
                            <h4 class="text-sm font-semibold text-gray-700 mb-2">Principes d'efficacité</h4>
                            <p class="text-xs text-gray-600">
                                Progression vers la cible, déséquilibre de la défense, tir en position favorable
                            </p>
                        </div>
                        <div>
                            <h4 class="text-sm font-semibold text-gray-700 mb-2">Rapport à l'autre</h4>
                            <p class="text-xs text-gray-600">
                                Coopération avec les partenaires, opposition fair-play, respect de l'arbitrage
                            </p>
                        </div>
                    </div>
                </div>
                
                <!-- Navigation -->
                <div class="mt-8 flex justify-between">
                    <button @click="previousStep()" class="text-gray-500 hover:text-gray-700 transition">
                        <i class="fas fa-arrow-left mr-2"></i> Retour
                    </button>
                    <button @click="nextStep()" 
                            class="glow-button bg-gradient-to-r from-blue-500 to-purple-600 text-white px-6 py-3 rounded-lg font-semibold hover:shadow-lg transition">
                        Continuer <i class="fas fa-arrow-right ml-2"></i>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Continue with more steps... -->
        
    </main>
    
    <!-- JavaScript -->
    <script>
        // Initialize AOS
        AOS.init({ duration: 800, once: true });
        
        // Alpine.js Component
        document.addEventListener('alpine:init', () => {
            Alpine.data('fpsCreator', () => ({
                currentStep: 0,
                steps: [
                    { name: 'Contexte', icon: 'fas fa-chart-line' },
                    { name: 'ECC', icon: 'fas fa-compass' },
                    { name: 'PPSAD', icon: 'fas fa-futbol' },
                    { name: 'OE', icon: 'fas fa-bullseye' },
                    { name: 'FPS', icon: 'fas fa-cogs' },
                    { name: 'Contraintes', icon: 'fas fa-lock' },
                    { name: 'Validation', icon: 'fas fa-check' }
                ],
                
                selectedClass: null,
                selectedECC: null,
                selectedPPSAD: null,
                selectedOE: null,
                
                aiAssistantVisible: true,
                aiMessage: "Je suis là pour vous guider dans la création de votre FPS. N'hésitez pas à me poser des questions !",
                
                init() {
                    this.startGuidedTour();
                    this.typeAIMessage();
                },
                
                startGuidedTour() {
                    const tour = new Shepherd.Tour({
                        useModalOverlay: true,
                        defaultStepOptions: {
                            cancelIcon: { enabled: true },
                            scrollTo: { behavior: 'smooth', block: 'center' }
                        }
                    });
                    
                    tour.addStep({
                        title: 'Bienvenue dans la création guidée !',
                        text: 'Je vais vous accompagner pas à pas dans la création de votre Forme de Pratique Scolaire selon la méthode CEDREPS.',
                        buttons: [
                            {
                                text: 'Commencer',
                                action: tour.next
                            }
                        ]
                    });
                    
                    // tour.start();
                },
                
                typeAIMessage() {
                    // Typing effect for AI messages
                    const typed = new Typed('.ai-thinking', {
                        strings: ['Analyse en cours...', 'Calcul des recommandations...', 'Résultat :'],
                        typeSpeed: 50,
                        backSpeed: 30,
                        loop: false
                    });
                },
                
                nextStep() {
                    if (this.currentStep < this.steps.length - 1) {
                        this.currentStep++;
                        this.updateAIAssistant();
                        AOS.refresh();
                    }
                },
                
                previousStep() {
                    if (this.currentStep > 0) {
                        this.currentStep--;
                        AOS.refresh();
                    }
                },
                
                selectClass(className) {
                    this.selectedClass = className;
                    Swal.fire({
                        icon: 'success',
                        title: 'Classe sélectionnée',
                        text: `Vous avez choisi la classe ${className}`,
                        timer: 1500,
                        showConfirmButton: false
                    });
                },
                
                selectECC(eccCode) {
                    this.selectedECC = eccCode;
                    this.updateAIAssistant();
                },
                
                updateAIAssistant() {
                    const messages = {
                        0: "Analysons d'abord votre contexte d'enseignement. Ces informations m'aideront à personnaliser mes suggestions.",
                        1: "Les ECC sont le cœur de l'approche CEDREPS. Choisissez celle qui correspond le mieux à vos objectifs éducatifs.",
                        2: "Excellent choix d'ECC ! Maintenant, sélectionnons la PPSAD qui permettra de vivre cette expérience.",
                        3: "Il est temps de cibler votre Objet d'Enseignement - le 'pas en avant' que vous visez pour vos élèves.",
                        4: "Créons maintenant votre FPS avec ses contraintes emblématiques qui orienteront l'activité des élèves.",
                        5: "Définissons les règles et contraintes qui encapsuleront votre OE.",
                        6: "Vérifions ensemble que votre FPS est cohérente et prête à être mise en œuvre !"
                    };
                    
                    this.aiMessage = messages[this.currentStep] || "Je suis là pour vous aider !";
                },
                
                showHelp() {
                    Swal.fire({
                        title: 'Aide - Création de FPS',
                        html: `
                            <div class="text-left">
                                <h4 class="font-semibold mb-2">Qu'est-ce qu'une FPS ?</h4>
                                <p class="text-sm text-gray-600 mb-4">
                                    Une Forme de Pratique Scolaire est une création originale de l'enseignant qui encapsule 
                                    un objet d'enseignement précis à travers des contraintes emblématiques.
                                </p>
                                <h4 class="font-semibold mb-2">Les étapes clés :</h4>
                                <ol class="text-sm text-gray-600 list-decimal list-inside">
                                    <li>Analyser le contexte (classe, installations, objectifs)</li>
                                    <li>Choisir une ECC (type d'expérience)</li>
                                    <li>Sélectionner une PPSAD adaptée</li>
                                    <li>Cibler un OE (transformation visée)</li>
                                    <li>Concevoir les contraintes emblématiques</li>
                                    <li>Valider la cohérence de l'ensemble</li>
                                </ol>
                            </div>
                        `,
                        icon: 'info',
                        confirmButtonText: 'Compris !',
                        confirmButtonColor: '#3B82F6'
                    });
                },
                
                saveProgress() {
                    // Save to localStorage or backend
                    const data = {
                        step: this.currentStep,
                        class: this.selectedClass,
                        ecc: this.selectedECC,
                        ppsad: this.selectedPPSAD,
                        oe: this.selectedOE
                    };
                    localStorage.setItem('fps_creation_progress', JSON.stringify(data));
                    
                    Swal.fire({
                        icon: 'success',
                        title: 'Progression sauvegardée',
                        timer: 1500,
                        showConfirmButton: false
                    });
                },
                
                exitCreation() {
                    Swal.fire({
                        title: 'Êtes-vous sûr ?',
                        text: 'Votre progression sera sauvegardée',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3B82F6',
                        cancelButtonColor: '#EF4444',
                        confirmButtonText: 'Oui, quitter',
                        cancelButtonText: 'Continuer'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            this.saveProgress();
                            window.location.href = 'dashboard.php';
                        }
                    });
                },
                
                acceptAISuggestion() {
                    Swal.fire({
                        icon: 'success',
                        title: 'Suggestion acceptée',
                        timer: 1500,
                        showConfirmButton: false
                    });
                },
                
                rejectAISuggestion() {
                    this.aiMessage = "Pas de problème ! Voici une autre suggestion basée sur vos préférences...";
                }
            }));
        });
    </script>
</body>
</html>