<?php
/**
 * ╔══════════════════════════════════════════════════════════════╗
 * ║            DASHBOARD SIMPLE - CEDREPS ULTIMATE                ║
 * ╚══════════════════════════════════════════════════════════════╝
 */

// Démarrer la session
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_email'])) {
    header('Location: login_test.php');
    exit;
}

// Inclure la configuration
$pdo = null;
if (file_exists('config.php')) {
    require_once 'config.php';
}

// Récupérer les informations de l'utilisateur
$user = [
    'id' => $_SESSION['user_id'],
    'name' => $_SESSION['user_name'] ?? 'Utilisateur',
    'email' => $_SESSION['user_email']
];

// Récupérer les statistiques si la base est connectée
$stats = [];
if ($pdo) {
    try {
        // Classes de l'enseignant
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM classes WHERE teacher_id = ?");
        $stmt->execute([$user['id']]);
        $stats['classes'] = $stmt->fetchColumn();
        
        // Cycles
        $stmt = $pdo->prepare("
            SELECT COUNT(*) FROM cycles c 
            JOIN classes cl ON c.class_id = cl.id 
            WHERE cl.teacher_id = ?
        ");
        $stmt->execute([$user['id']]);
        $stats['cycles'] = $stmt->fetchColumn();
        
        // Élèves
        $stmt = $pdo->prepare("
            SELECT COUNT(*) FROM students s 
            JOIN classes cl ON s.class_id = cl.id 
            WHERE cl.teacher_id = ?
        ");
        $stmt->execute([$user['id']]);
        $stats['students'] = $stmt->fetchColumn();
        
        // Total utilisateurs (pour admin)
        $stmt = $pdo->query("SELECT COUNT(*) FROM users");
        $stats['users'] = $stmt->fetchColumn();
        
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}

?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - CEDREPS Ultimate</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            background: #f5f5f5;
        }
        
        /* Header */
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .header-content {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .logo-icon {
            width: 50px;
            height: 50px;
            background: rgba(255,255,255,0.2);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 20px;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255,255,255,0.3);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .logout-btn {
            background: rgba(255,255,255,0.2);
            color: white;
            padding: 8px 16px;
            border-radius: 5px;
            text-decoration: none;
            transition: background 0.3s;
        }
        
        .logout-btn:hover {
            background: rgba(255,255,255,0.3);
        }
        
        /* Main content */
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .welcome-card {
            background: white;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        
        .welcome-card h1 {
            color: #1F2937;
            margin-bottom: 10px;
        }
        
        .welcome-card p {
            color: #6B7280;
        }
        
        /* Stats grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            border-radius: 10px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            border-left: 4px solid #667eea;
        }
        
        .stat-card.green {
            border-left-color: #10B981;
        }
        
        .stat-card.blue {
            border-left-color: #3B82F6;
        }
        
        .stat-card.purple {
            border-left-color: #8B5CF6;
        }
        
        .stat-card.yellow {
            border-left-color: #F59E0B;
        }
        
        .stat-value {
            font-size: 36px;
            font-weight: bold;
            color: #1F2937;
            margin-bottom: 5px;
        }
        
        .stat-label {
            color: #6B7280;
            font-size: 14px;
        }
        
        .stat-icon {
            float: right;
            font-size: 40px;
            opacity: 0.2;
        }
        
        /* Quick actions */
        .quick-actions {
            background: white;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 30px;
        }
        
        .quick-actions h2 {
            color: #1F2937;
            margin-bottom: 20px;
        }
        
        .actions-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }
        
        .action-btn {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 15px 20px;
            background: #F9FAFB;
            border: 1px solid #E5E7EB;
            border-radius: 8px;
            text-decoration: none;
            color: #374151;
            transition: all 0.3s;
        }
        
        .action-btn:hover {
            background: #667eea;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        }
        
        .action-icon {
            font-size: 24px;
        }
        
        /* Info section */
        .info-section {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .info-card {
            background: white;
            border-radius: 10px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        
        .info-card h3 {
            color: #1F2937;
            margin-bottom: 15px;
            font-size: 18px;
        }
        
        .info-card ul {
            list-style: none;
        }
        
        .info-card li {
            padding: 8px 0;
            color: #6B7280;
            border-bottom: 1px solid #F3F4F6;
        }
        
        .info-card li:last-child {
            border-bottom: none;
        }
        
        .badge {
            display: inline-block;
            padding: 2px 8px;
            background: #EFF6FF;
            color: #3B82F6;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        
        /* Footer */
        .footer {
            text-align: center;
            padding: 30px;
            color: #6B7280;
            font-size: 14px;
        }
        
        .error {
            background: #FEF2F2;
            color: #DC2626;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        
        @media (max-width: 768px) {
            .info-section {
                grid-template-columns: 1fr;
            }
            
            .header-content {
                flex-direction: column;
                gap: 15px;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="header-content">
            <div class="logo">
                <div class="logo-icon">CE</div>
                <div>
                    <h2>CEDREPS Ultimate</h2>
                    <p style="font-size: 14px; opacity: 0.9;">L'EPS guidée et intelligente</p>
                </div>
            </div>
            
            <div class="user-info">
                <div class="user-avatar">
                    <?php echo strtoupper(substr($user['name'], 0, 1)); ?>
                </div>
                <div style="text-align: right;">
                    <div style="font-weight: 600;"><?php echo htmlspecialchars($user['name']); ?></div>
                    <div style="font-size: 14px; opacity: 0.9;"><?php echo htmlspecialchars($user['email']); ?></div>
                </div>
                <a href="login_test.php?action=logout" class="logout-btn">Déconnexion</a>
            </div>
        </div>
    </header>
    
    <!-- Main content -->
    <div class="container">
        <!-- Welcome message -->
        <div class="welcome-card">
            <h1>Bienvenue, <?php echo htmlspecialchars($user['name']); ?> ! 👋</h1>
            <p>Voici votre tableau de bord CEDREPS Ultimate. Gérez vos classes, cycles et évaluations depuis cette interface.</p>
        </div>
        
        <?php if (isset($error)): ?>
        <div class="error">
            ⚠️ Erreur de connexion à la base de données : <?php echo htmlspecialchars($error); ?>
        </div>
        <?php endif; ?>
        
        <!-- Statistics -->
        <div class="stats-grid">
            <div class="stat-card blue">
                <span class="stat-icon">📚</span>
                <div class="stat-value"><?php echo $stats['classes'] ?? 0; ?></div>
                <div class="stat-label">Classes</div>
            </div>
            
            <div class="stat-card green">
                <span class="stat-icon">🔄</span>
                <div class="stat-value"><?php echo $stats['cycles'] ?? 0; ?></div>
                <div class="stat-label">Cycles</div>
            </div>
            
            <div class="stat-card purple">
                <span class="stat-icon">👥</span>
                <div class="stat-value"><?php echo $stats['students'] ?? 0; ?></div>
                <div class="stat-label">Élèves</div>
            </div>
            
            <div class="stat-card yellow">
                <span class="stat-icon">⭐</span>
                <div class="stat-value">100%</div>
                <div class="stat-label">Conformité CEDREPS</div>
            </div>
        </div>
        
        <!-- Quick Actions -->
        <div class="quick-actions">
            <h2>Actions rapides</h2>
            <div class="actions-grid">
                <a href="create_fps_guided.php" class="action-btn">
                    <span class="action-icon">➕</span>
                    <span>Créer une FPS</span>
                </a>
                
                <a href="classes.php" class="action-btn">
                    <span class="action-icon">📚</span>
                    <span>Gérer les classes</span>
                </a>
                
                <a href="evaluation_4dimensions.php" class="action-btn">
                    <span class="action-icon">📊</span>
                    <span>Évaluations</span>
                </a>
                
                <a href="sharing_system.php" class="action-btn">
                    <span class="action-icon">🤝</span>
                    <span>Partager</span>
                </a>
                
                <a href="migrate_diagnostic.php?pass=MigrationCedreps2025" class="action-btn">
                    <span class="action-icon">🔄</span>
                    <span>Migration</span>
                </a>
                
                <a href="test_session.php" class="action-btn">
                    <span class="action-icon">🧪</span>
                    <span>Tests système</span>
                </a>
            </div>
        </div>
        
        <!-- Info Section -->
        <div class="info-section">
            <div class="info-card">
                <h3>📋 Informations système</h3>
                <ul>
                    <li>Version PHP : <span class="badge"><?php echo PHP_VERSION; ?></span></li>
                    <li>Session ID : <code style="font-size: 11px;"><?php echo substr(session_id(), 0, 20); ?>...</code></li>
                    <li>Utilisateurs total : <strong><?php echo $stats['users'] ?? 0; ?></strong></li>
                    <li>Base de données : <span class="badge"><?php echo $pdo ? 'Connectée' : 'Déconnectée'; ?></span></li>
                </ul>
            </div>
            
            <div class="info-card">
                <h3>🚀 Nouveautés CEDREPS Ultimate</h3>
                <ul>
                    <li>✅ Assistant IA pour création de FPS</li>
                    <li>✅ Évaluation 4 dimensions</li>
                    <li>✅ Système de partage multi-rôles</li>
                    <li>✅ Gamification intégrée</li>
                    <li>✅ Interface ultra-moderne</li>
                </ul>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="footer">
            <p>CEDREPS Ultimate v2.0 - L'excellence pédagogique en EPS</p>
            <p style="margin-top: 10px;">
                <a href="login_test.php" style="color: #667eea;">Page de test</a> | 
                <a href="test_session.php" style="color: #667eea;">Tester les sessions</a> | 
                <a href="README.md" style="color: #667eea;">Documentation</a>
            </p>
        </div>
    </div>
</body>
</html>