<?php
/**
 * Script de correction pour l'erreur HTTP 500 sur EPSWeb
 * Problème: Fonction getDB() déclarée deux fois
 * 
 * INSTRUCTIONS:
 * 1. Uploadez ce fichier dans /app_v5/
 * 2. Exécutez-le: https://epsweb.fr/app_v5/fix_error_500.php
 * 3. Suivez les instructions
 * 4. Supprimez ce fichier après utilisation
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Configuration
$files_to_check = [
    'config.php' => 306,
    'functions.php' => 80
];

?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Correction Erreur 500 - EPSWeb</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }
        
        h1 {
            color: #333;
            margin-bottom: 20px;
            border-bottom: 3px solid #667eea;
            padding-bottom: 10px;
        }
        
        .alert {
            padding: 15px;
            margin: 20px 0;
            border-radius: 5px;
            border-left: 4px solid;
        }
        
        .alert-danger {
            background: #fee;
            border-color: #f56565;
            color: #c53030;
        }
        
        .alert-success {
            background: #f0fdf4;
            border-color: #48bb78;
            color: #22543d;
        }
        
        .alert-warning {
            background: #fffaf0;
            border-color: #ed8936;
            color: #c05621;
        }
        
        .alert-info {
            background: #ebf8ff;
            border-color: #4299e1;
            color: #2c5282;
        }
        
        .code-box {
            background: #1a202c;
            color: #e2e8f0;
            padding: 15px;
            border-radius: 5px;
            margin: 10px 0;
            font-family: 'Courier New', monospace;
            font-size: 14px;
            overflow-x: auto;
        }
        
        .file-section {
            margin: 20px 0;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 8px;
        }
        
        .file-section h3 {
            color: #667eea;
            margin-bottom: 10px;
        }
        
        .button {
            background: #667eea;
            color: white;
            padding: 12px 24px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-weight: 500;
            margin: 5px;
            text-decoration: none;
            display: inline-block;
        }
        
        .button:hover {
            background: #5a67d8;
        }
        
        .button-danger {
            background: #f56565;
        }
        
        .button-danger:hover {
            background: #e53e3e;
        }
        
        .button-success {
            background: #48bb78;
        }
        
        .button-success:hover {
            background: #38a169;
        }
        
        ul {
            margin-left: 20px;
        }
        
        li {
            margin: 10px 0;
        }
        
        .solution-box {
            background: #f0fdf4;
            border: 2px solid #48bb78;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .solution-box h3 {
            color: #22543d;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 Correction de l'Erreur HTTP 500</h1>
        
        <div class="alert alert-danger">
            <strong>⚠️ Problème identifié :</strong><br>
            La fonction <code>getDB()</code> est déclarée deux fois, causant une erreur fatale PHP.
        </div>

        <?php
        // Vérifier l'existence des fichiers
        $config_exists = file_exists('config.php');
        $functions_exists = file_exists('functions.php');
        
        if (!$config_exists || !$functions_exists) {
            ?>
            <div class="alert alert-danger">
                <strong>Erreur :</strong> Les fichiers nécessaires ne sont pas trouvés.<br>
                Assurez-vous que ce script est dans le dossier /app_v5/
            </div>
            <?php
        } else {
            ?>
            <div class="alert alert-success">
                <strong>✅ Fichiers trouvés :</strong><br>
                - config.php : <?php echo $config_exists ? 'Présent' : 'Absent'; ?><br>
                - functions.php : <?php echo $functions_exists ? 'Présent' : 'Absent'; ?>
            </div>
            
            <?php
            // Analyser les fichiers
            $config_content = file_get_contents('config.php');
            $functions_content = file_get_contents('functions.php');
            
            // Rechercher la fonction getDB dans chaque fichier
            $config_has_getdb = strpos($config_content, 'function getDB') !== false;
            $functions_has_getdb = strpos($functions_content, 'function getDB') !== false;
            ?>
            
            <div class="file-section">
                <h3>📄 Analyse des fichiers</h3>
                <ul>
                    <li>config.php contient getDB() : <?php echo $config_has_getdb ? '✅ OUI (ligne ~306)' : '❌ NON'; ?></li>
                    <li>functions.php contient getDB() : <?php echo $functions_has_getdb ? '✅ OUI (ligne ~80)' : '❌ NON'; ?></li>
                </ul>
                
                <?php if ($config_has_getdb && $functions_has_getdb): ?>
                    <div class="alert alert-danger">
                        <strong>Conflit confirmé !</strong> La fonction est bien présente dans les deux fichiers.
                    </div>
                <?php endif; ?>
            </div>
            
            <div class="solution-box">
                <h3>💡 Solutions disponibles</h3>
                
                <h4>Option 1 : Correction manuelle (Recommandée)</h4>
                <ol>
                    <li>Ouvrez le fichier <code>functions.php</code></li>
                    <li>Allez à la ligne 80 (ou recherchez "function getDB")</li>
                    <li>Modifiez la déclaration de la fonction ainsi :
                        <div class="code-box">
// Remplacez cette ligne :<br>
function getDB() {<br>
<br>
// Par celle-ci :<br>
if (!function_exists('getDB')) {<br>
&nbsp;&nbsp;&nbsp;&nbsp;function getDB() {<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// ... le code de la fonction ...<br>
&nbsp;&nbsp;&nbsp;&nbsp;}<br>
}
                        </div>
                    </li>
                    <li>Sauvegardez le fichier</li>
                    <li>Testez l'accès à dashboard.php</li>
                </ol>
                
                <h4>Option 2 : Suppression de la duplication</h4>
                <ol>
                    <li>Déterminez quelle version de <code>getDB()</code> est la bonne</li>
                    <li>Supprimez complètement la fonction de l'un des deux fichiers</li>
                    <li>Assurez-vous que le fichier contenant la fonction est bien inclus partout où c'est nécessaire</li>
                </ol>
                
                <h4>Option 3 : Utilisation de require_once</h4>
                <p>Vérifiez que les fichiers sont inclus avec <code>require_once</code> ou <code>include_once</code> au lieu de <code>require</code> ou <code>include</code>.</p>
                <div class="code-box">
// Dans dashboard.php ou autres fichiers :<br>
require_once 'config.php';<br>
require_once 'functions.php';
                </div>
            </div>
            
            <?php
            // Tentative de correction automatique
            if (isset($_POST['auto_fix'])) {
                echo '<div class="alert alert-info">Tentative de correction automatique...</div>';
                
                // Créer une sauvegarde
                $backup_name = 'functions.php.backup_' . date('YmdHis');
                if (copy('functions.php', $backup_name)) {
                    echo '<div class="alert alert-success">✅ Sauvegarde créée : ' . $backup_name . '</div>';
                    
                    // Lire le contenu du fichier
                    $lines = file('functions.php');
                    $modified = false;
                    $new_content = [];
                    $in_function = false;
                    $brace_count = 0;
                    
                    for ($i = 0; $i < count($lines); $i++) {
                        $line = $lines[$i];
                        
                        // Détecter le début de la fonction getDB
                        if (strpos($line, 'function getDB') !== false && !$modified) {
                            $new_content[] = "if (!function_exists('getDB')) {\n";
                            $new_content[] = $line;
                            $in_function = true;
                            $brace_count = 1;
                            $modified = true;
                        } elseif ($in_function) {
                            $new_content[] = $line;
                            
                            // Compter les accolades
                            $brace_count += substr_count($line, '{');
                            $brace_count -= substr_count($line, '}');
                            
                            // Si on a fermé toutes les accolades
                            if ($brace_count == 0) {
                                $new_content[] = "}\n";
                                $in_function = false;
                            }
                        } else {
                            $new_content[] = $line;
                        }
                    }
                    
                    // Écrire le nouveau contenu
                    if ($modified && file_put_contents('functions.php', implode('', $new_content))) {
                        echo '<div class="alert alert-success">✅ Fichier functions.php modifié avec succès !</div>';
                        echo '<div class="alert alert-info">La fonction getDB() est maintenant protégée contre la redéclaration.</div>';
                        echo '<p><a href="dashboard.php" class="button button-success">Tester dashboard.php</a></p>';
                    } else {
                        echo '<div class="alert alert-danger">Impossible de modifier le fichier. Essayez la correction manuelle.</div>';
                    }
                } else {
                    echo '<div class="alert alert-danger">Impossible de créer une sauvegarde. Correction annulée.</div>';
                }
            }
            ?>
            
            <form method="POST" onsubmit="return confirm('Voulez-vous vraiment appliquer la correction automatique ? Une sauvegarde sera créée.');">
                <h3>🤖 Correction automatique</h3>
                <p>Cette option va modifier <code>functions.php</code> pour envelopper la fonction getDB() dans une condition <code>function_exists</code>.</p>
                <button type="submit" name="auto_fix" value="1" class="button">
                    🔧 Appliquer la correction automatique
                </button>
            </form>
            
            <?php
        }
        ?>
        
        <div class="file-section">
            <h3>📝 Code de correction manuel</h3>
            <p>Si la correction automatique ne fonctionne pas, voici le code exact à utiliser :</p>
            
            <h4>Pour functions.php (ligne ~80) :</h4>
            <div class="code-box">
// Remplacez toute la déclaration de la fonction getDB() par :<br>
<br>
if (!function_exists('getDB')) {<br>
&nbsp;&nbsp;&nbsp;&nbsp;function getDB() {<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// Le code existant de votre fonction<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// (connexion à la base de données)<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;return $connection; // ou PDO, selon votre code<br>
&nbsp;&nbsp;&nbsp;&nbsp;}<br>
}
            </div>
            
            <h4>Alternative - Pour dashboard.php :</h4>
            <div class="code-box">
&lt;?php<br>
// Au début du fichier dashboard.php<br>
require_once 'config.php';     // Utiliser require_once<br>
require_once 'functions.php';  // au lieu de require<br>
<br>
// Reste du code...<br>
?&gt;
            </div>
        </div>
        
        <div class="alert alert-warning">
            <strong>⚠️ Important après correction :</strong>
            <ul>
                <li>Testez immédiatement l'accès à dashboard.php</li>
                <li>Vérifiez que les autres pages fonctionnent toujours</li>
                <li>Supprimez ce fichier de correction</li>
                <li>Désactivez display_errors en production</li>
            </ul>
        </div>
        
        <div style="margin-top: 30px; padding-top: 20px; border-top: 2px solid #e2e8f0;">
            <h3>🔗 Liens utiles</h3>
            <a href="dashboard.php" class="button button-success">Tester Dashboard</a>
            <a href="diagnostic_server.php" class="button">Relancer le diagnostic</a>
            <a href="?delete=1" class="button button-danger" onclick="return confirm('Supprimer ce fichier ?')">Supprimer ce fichier</a>
        </div>
        
        <?php
        // Option pour supprimer ce fichier
        if (isset($_GET['delete'])) {
            if (unlink(__FILE__)) {
                echo "<script>alert('Fichier supprimé'); window.location='dashboard.php';</script>";
            }
        }
        ?>
    </div>
</body>
</html>