<?php
/**
 * ╔══════════════════════════════════════════════════════════════╗
 * ║         SYSTÈME DE CONNEXION SIMPLIFIÉ - CEDREPS             ║
 * ║                   Version corrigée et testée                  ║
 * ╚══════════════════════════════════════════════════════════════╝
 */

session_start();

// Configuration de la base de données
require_once 'config.php';

// Fonction simple de vérification de connexion
function isLoggedIn() {
    return isset($_SESSION['user_id']) && isset($_SESSION['user_email']);
}

// Fonction pour connecter un utilisateur
function loginUser($email, $password) {
    global $pdo;
    
    try {
        // Rechercher l'utilisateur
        $stmt = $pdo->prepare("SELECT id, name, email, password FROM users WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($user) {
            // Vérifier le mot de passe (on accepte plusieurs méthodes)
            $password_valid = false;
            
            // Méthode 1 : password_verify (bcrypt)
            if (password_verify($password, $user['password'])) {
                $password_valid = true;
            }
            // Méthode 2 : MD5 (ancien système)
            elseif ($user['password'] === md5($password)) {
                $password_valid = true;
            }
            // Méthode 3 : SHA1 (autre ancien système)
            elseif ($user['password'] === sha1($password)) {
                $password_valid = true;
            }
            // Méthode 4 : Mot de passe en clair (développement)
            elseif ($user['password'] === $password) {
                $password_valid = true;
            }
            
            if ($password_valid) {
                // Créer la session
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['user_name'] = $user['name'];
                $_SESSION['logged_in'] = true;
                $_SESSION['login_time'] = time();
                
                // Régénérer l'ID de session pour la sécurité
                session_regenerate_id(true);
                
                return ['success' => true, 'user' => $user];
            }
        }
        
        return ['success' => false, 'message' => 'Email ou mot de passe incorrect'];
        
    } catch (Exception $e) {
        return ['success' => false, 'message' => 'Erreur de connexion : ' . $e->getMessage()];
    }
}

// Si c'est une requête POST (tentative de connexion)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    
    $result = loginUser($email, $password);
    
    if ($result['success']) {
        // Redirection vers le dashboard
        header('Location: dashboard_simple.php');
        exit;
    } else {
        $error = $result['message'];
    }
}

// Si déjà connecté, aller au dashboard
if (isLoggedIn()) {
    header('Location: dashboard_simple.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion - CEDREPS Ultimate</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .login-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 25px 50px -12px rgba(0,0,0,0.25);
            width: 100%;
            max-width: 400px;
            padding: 40px;
        }
        
        .logo {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .logo-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 36px;
            font-weight: bold;
            margin: 0 auto 20px;
        }
        
        h1 {
            color: #1F2937;
            font-size: 28px;
            margin-bottom: 10px;
            text-align: center;
        }
        
        .subtitle {
            color: #6B7280;
            text-align: center;
            margin-bottom: 30px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            color: #374151;
            font-weight: 500;
            margin-bottom: 8px;
        }
        
        input {
            width: 100%;
            padding: 12px;
            border: 1px solid #D1D5DB;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        .password-toggle {
            position: relative;
        }
        
        .toggle-btn {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #6B7280;
            cursor: pointer;
            padding: 4px;
        }
        
        .toggle-btn:hover {
            color: #374151;
        }
        
        .remember-me {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .remember-me input {
            width: auto;
            margin-right: 8px;
        }
        
        .btn {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
        }
        
        .error {
            background: #FEF2F2;
            color: #DC2626;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #FECACA;
        }
        
        .success {
            background: #F0FDF4;
            color: #166534;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #86EFAC;
        }
        
        .info {
            background: #EFF6FF;
            color: #1E40AF;
            padding: 15px;
            border-radius: 8px;
            margin-top: 20px;
            border: 1px solid #BFDBFE;
        }
        
        .info h3 {
            margin-top: 0;
            margin-bottom: 10px;
        }
        
        .info p {
            margin: 5px 0;
        }
        
        .demo-accounts {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #E5E7EB;
        }
        
        .demo-account {
            background: #F9FAFB;
            padding: 10px;
            border-radius: 8px;
            margin-bottom: 10px;
            font-family: monospace;
            font-size: 14px;
        }
        
        .links {
            text-align: center;
            margin-top: 20px;
        }
        
        .links a {
            color: #667eea;
            text-decoration: none;
            font-size: 14px;
        }
        
        .links a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <div class="logo-icon">CE</div>
            <h1>CEDREPS Ultimate</h1>
            <p class="subtitle">L'EPS guidée et intelligente</p>
        </div>
        
        <?php if (isset($error)): ?>
        <div class="error">
            ⚠️ <?php echo htmlspecialchars($error); ?>
        </div>
        <?php endif; ?>
        
        <form method="POST" action="">
            <div class="form-group">
                <label for="email">Adresse email</label>
                <input 
                    type="email" 
                    id="email" 
                    name="email" 
                    required 
                    placeholder="exemple@email.com"
                    value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>"
                >
            </div>
            
            <div class="form-group">
                <label for="password">Mot de passe</label>
                <div class="password-toggle">
                    <input 
                        type="password" 
                        id="password" 
                        name="password" 
                        required 
                        placeholder="Votre mot de passe"
                    >
                    <button type="button" class="toggle-btn" onclick="togglePassword()">
                        👁️
                    </button>
                </div>
            </div>
            
            <div class="remember-me">
                <input type="checkbox" id="remember" name="remember">
                <label for="remember">Se souvenir de moi</label>
            </div>
            
            <button type="submit" class="btn">
                Se connecter
            </button>
        </form>
        
        <div class="info">
            <h3>ℹ️ Information</h3>
            <p>Utilisez vos identifiants de l'ancienne application.</p>
            <p>Les mots de passe ont été conservés lors de la migration.</p>
        </div>
        
        <div class="demo-accounts">
            <h3 style="margin-bottom: 10px;">Comptes de test disponibles :</h3>
            
            <?php
            // Afficher les utilisateurs disponibles pour le test
            try {
                if (isset($pdo)) {
                    $stmt = $pdo->query("SELECT email FROM users LIMIT 3");
                    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    
                    foreach ($users as $user) {
                        echo '<div class="demo-account">';
                        echo 'Email : ' . htmlspecialchars($user['email']);
                        echo '</div>';
                    }
                    
                    echo '<p style="margin-top: 10px; font-size: 14px; color: #6B7280;">Mot de passe : utilisez votre ancien mot de passe</p>';
                }
            } catch (Exception $e) {
                // Ne rien afficher si erreur
            }
            ?>
        </div>
        
        <div class="links">
            <a href="test_session.php">Tester la session</a> | 
            <a href="reset_password.php">Mot de passe oublié ?</a>
        </div>
    </div>
    
    <script>
        function togglePassword() {
            const passwordInput = document.getElementById('password');
            const toggleBtn = document.querySelector('.toggle-btn');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                toggleBtn.textContent = '🙈';
            } else {
                passwordInput.type = 'password';
                toggleBtn.textContent = '👁️';
            }
        }
    </script>
</body>
</html>