<?php
/**
 * ╔══════════════════════════════════════════════════════════════╗
 * ║         CONNEXION SIMPLE - CEDREPS ULTIMATE                   ║
 * ║              Test et connexion en un fichier                  ║
 * ╚══════════════════════════════════════════════════════════════╝
 */

// Démarrer la session en premier
session_start();

// ===================================================================
// CONFIGURATION DIRECTE (pas de dépendance externe)
// ===================================================================

$db_config = [
    'host' => 'localhost',
    'name' => 'epsweb_cedreps_ultimate',  // CHANGEZ avec le nom de votre nouvelle base
    'user' => 'epsweb_cedreps_ultimate',  // CHANGEZ avec votre utilisateur
    'pass' => '48oRDRRn)u,5', // CHANGEZ avec votre mot de passe
    'charset' => 'utf8mb4'
];

// ===================================================================
// CONNEXION À LA BASE DE DONNÉES
// ===================================================================

$pdo = null;
$db_error = null;

try {
    $pdo = new PDO(
        "mysql:host={$db_config['host']};dbname={$db_config['name']};charset={$db_config['charset']}",
        $db_config['user'],
        $db_config['pass'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
} catch (PDOException $e) {
    $db_error = $e->getMessage();
}

// ===================================================================
// ACTIONS
// ===================================================================

$action = $_GET['action'] ?? 'login';
$message = '';
$message_type = '';

// Action : Déconnexion
if ($action === 'logout') {
    session_destroy();
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Action : Test de la session
if ($action === 'test') {
    $message = "Session ID : " . session_id() . "<br>";
    $message .= "Session active : " . (isset($_SESSION['user_id']) ? 'OUI' : 'NON') . "<br>";
    if (isset($_SESSION['user_id'])) {
        $message .= "User ID : " . $_SESSION['user_id'] . "<br>";
        $message .= "User Email : " . $_SESSION['user_email'] . "<br>";
    }
    $message_type = 'info';
}

// Action : Reset du mot de passe
if ($action === 'reset' && isset($_GET['email']) && $pdo) {
    $email = $_GET['email'];
    $new_password = 'Test123!';
    $hashed = password_hash($new_password, PASSWORD_DEFAULT);
    
    try {
        $stmt = $pdo->prepare("UPDATE users SET password = ? WHERE email = ?");
        $stmt->execute([$hashed, $email]);
        
        if ($stmt->rowCount() > 0) {
            $message = "Mot de passe réinitialisé pour $email<br>Nouveau mot de passe : <strong>$new_password</strong>";
            $message_type = 'success';
        } else {
            $message = "Utilisateur non trouvé : $email";
            $message_type = 'error';
        }
    } catch (Exception $e) {
        $message = "Erreur : " . $e->getMessage();
        $message_type = 'error';
    }
}

// Action : Connexion
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['email']) && isset($_POST['password']) && $pdo) {
    $email = $_POST['email'];
    $password = $_POST['password'];
    
    try {
        // Rechercher l'utilisateur
        $stmt = $pdo->prepare("SELECT id, name, email, password FROM users WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch();
        
        if ($user) {
            $password_valid = false;
            
            // Tester différentes méthodes de hachage
            if (password_verify($password, $user['password'])) {
                $password_valid = true;
                $method = 'bcrypt';
            } elseif ($user['password'] === md5($password)) {
                $password_valid = true;
                $method = 'md5';
            } elseif ($user['password'] === sha1($password)) {
                $password_valid = true;
                $method = 'sha1';
            } elseif ($user['password'] === $password) {
                $password_valid = true;
                $method = 'plain';
            }
            
            if ($password_valid) {
                // Créer la session
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['user_name'] = $user['name'];
                $_SESSION['logged_in'] = true;
                $_SESSION['login_time'] = time();
                
                session_regenerate_id(true);
                
                $message = "✅ Connexion réussie ! (méthode : $method)<br>";
                $message .= "ID : {$user['id']}<br>";
                $message .= "Nom : {$user['name']}<br>";
                $message .= "Email : {$user['email']}";
                $message_type = 'success';
            } else {
                $message = "❌ Mot de passe incorrect";
                $message_type = 'error';
            }
        } else {
            $message = "❌ Utilisateur non trouvé : $email";
            $message_type = 'error';
        }
    } catch (Exception $e) {
        $message = "Erreur : " . $e->getMessage();
        $message_type = 'error';
    }
}

// Vérifier si connecté
$is_logged_in = isset($_SESSION['user_id']);

?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test Connexion - CEDREPS Ultimate</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
        }
        
        .card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        h1 {
            color: #1F2937;
            margin-bottom: 20px;
        }
        
        h2 {
            color: #374151;
            font-size: 20px;
            margin: 20px 0 10px 0;
        }
        
        .status {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        
        .status.success {
            background: #F0FDF4;
            border: 1px solid #86EFAC;
            color: #166534;
        }
        
        .status.error {
            background: #FEF2F2;
            border: 1px solid #FECACA;
            color: #DC2626;
        }
        
        .status.warning {
            background: #FFFBEB;
            border: 1px solid #FCD34D;
            color: #92400E;
        }
        
        .status.info {
            background: #EFF6FF;
            border: 1px solid #BFDBFE;
            color: #1E40AF;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            color: #374151;
            font-weight: 500;
            margin-bottom: 8px;
        }
        
        input {
            width: 100%;
            padding: 12px;
            border: 1px solid #D1D5DB;
            border-radius: 8px;
            font-size: 16px;
        }
        
        input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        .btn {
            padding: 12px 24px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            margin-right: 10px;
            margin-bottom: 10px;
            display: inline-block;
            text-decoration: none;
        }
        
        .btn:hover {
            transform: translateY(-2px);
        }
        
        .btn.secondary {
            background: #6B7280;
        }
        
        .btn.danger {
            background: #EF4444;
        }
        
        .btn.success {
            background: #10B981;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        
        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #E5E7EB;
        }
        
        th {
            background: #F9FAFB;
            font-weight: 600;
            color: #374151;
        }
        
        code {
            background: #F3F4F6;
            padding: 2px 6px;
            border-radius: 4px;
            font-family: monospace;
            font-size: 14px;
            color: #DC2626;
        }
        
        .user-list {
            background: #F9FAFB;
            padding: 15px;
            border-radius: 8px;
            margin-top: 20px;
        }
        
        .user-item {
            background: white;
            padding: 10px;
            margin-bottom: 10px;
            border-radius: 6px;
            border: 1px solid #E5E7EB;
        }
        
        .tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
            border-bottom: 2px solid #E5E7EB;
        }
        
        .tab {
            padding: 10px 20px;
            background: none;
            border: none;
            cursor: pointer;
            font-size: 16px;
            color: #6B7280;
            border-bottom: 2px solid transparent;
            margin-bottom: -2px;
        }
        
        .tab.active {
            color: #667eea;
            border-bottom-color: #667eea;
        }
        
        .section {
            display: none;
        }
        
        .section.active {
            display: block;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <h1>🔧 Test & Connexion - CEDREPS Ultimate</h1>
            
            <!-- État de la base de données -->
            <?php if ($db_error): ?>
            <div class="status error">
                <strong>❌ Erreur de connexion à la base de données</strong><br>
                <?php echo htmlspecialchars($db_error); ?><br><br>
                <strong>Vérifiez les paramètres :</strong><br>
                Host : <code><?php echo $db_config['host']; ?></code><br>
                Base : <code><?php echo $db_config['name']; ?></code><br>
                User : <code><?php echo $db_config['user']; ?></code><br><br>
                <strong>Modifiez les lignes 19-22 de ce fichier avec vos identifiants</strong>
            </div>
            <?php else: ?>
            <div class="status success">
                ✅ Connexion à la base de données réussie
            </div>
            <?php endif; ?>
            
            <!-- État de la session -->
            <div class="status <?php echo $is_logged_in ? 'success' : 'warning'; ?>">
                <strong>🔐 Session :</strong><br>
                ID : <code><?php echo session_id(); ?></code><br>
                État : <?php echo $is_logged_in ? '✅ Connecté' : '⚠️ Non connecté'; ?>
                <?php if ($is_logged_in): ?>
                    <br>User : <?php echo $_SESSION['user_email']; ?> (ID: <?php echo $_SESSION['user_id']; ?>)
                <?php endif; ?>
            </div>
            
            <!-- Messages -->
            <?php if ($message): ?>
            <div class="status <?php echo $message_type; ?>">
                <?php echo $message; ?>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Navigation -->
        <div class="card">
            <div class="tabs">
                <button class="tab active" onclick="showSection('login')">Connexion</button>
                <button class="tab" onclick="showSection('users')">Utilisateurs</button>
                <button class="tab" onclick="showSection('test')">Tests</button>
                <button class="tab" onclick="showSection('help')">Aide</button>
            </div>
            
            <!-- Section Connexion -->
            <div id="login" class="section active">
                <?php if (!$is_logged_in): ?>
                <form method="POST" action="">
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" name="email" required placeholder="test@test.com">
                    </div>
                    <div class="form-group">
                        <label>Mot de passe</label>
                        <input type="password" name="password" required placeholder="Votre mot de passe">
                    </div>
                    <button type="submit" class="btn">Se connecter</button>
                </form>
                <?php else: ?>
                <h2>✅ Vous êtes connecté</h2>
                <p>Nom : <strong><?php echo $_SESSION['user_name']; ?></strong></p>
                <p>Email : <strong><?php echo $_SESSION['user_email']; ?></strong></p>
                <p>ID : <strong><?php echo $_SESSION['user_id']; ?></strong></p>
                <p>Heure connexion : <strong><?php echo date('H:i:s', $_SESSION['login_time']); ?></strong></p>
                <br>
                <a href="?action=logout" class="btn danger">Se déconnecter</a>
                <?php endif; ?>
            </div>
            
            <!-- Section Utilisateurs -->
            <div id="users" class="section">
                <h2>👥 Utilisateurs dans la base</h2>
                <?php if ($pdo): ?>
                    <?php
                    try {
                        $stmt = $pdo->query("SELECT id, name, email, created_at FROM users LIMIT 10");
                        $users = $stmt->fetchAll();
                        
                        if ($users): ?>
                        <div class="user-list">
                            <?php foreach ($users as $user): ?>
                            <div class="user-item">
                                <strong><?php echo htmlspecialchars($user['name']); ?></strong><br>
                                Email : <?php echo htmlspecialchars($user['email']); ?><br>
                                ID : <?php echo $user['id']; ?><br>
                                <a href="?action=reset&email=<?php echo urlencode($user['email']); ?>" 
                                   class="btn secondary" 
                                   style="font-size: 14px; padding: 6px 12px; margin-top: 5px;">
                                    Réinitialiser le mot de passe
                                </a>
                            </div>
                            <?php endforeach; ?>
                        </div>
                        <?php else: ?>
                        <p>Aucun utilisateur trouvé</p>
                        <?php endif;
                    } catch (Exception $e) {
                        echo '<div class="status error">Erreur : ' . $e->getMessage() . '</div>';
                    }
                    ?>
                <?php else: ?>
                <p>Base de données non connectée</p>
                <?php endif; ?>
            </div>
            
            <!-- Section Tests -->
            <div id="test" class="section">
                <h2>🧪 Tests système</h2>
                
                <h3>PHP Info</h3>
                <table>
                    <tr><th>PHP Version</th><td><?php echo PHP_VERSION; ?></td></tr>
                    <tr><th>Session Handler</th><td><?php echo ini_get('session.save_handler'); ?></td></tr>
                    <tr><th>Session Path</th><td><?php echo ini_get('session.save_path'); ?></td></tr>
                    <tr><th>Session Cookie</th><td><?php echo ini_get('session.cookie_lifetime'); ?> secondes</td></tr>
                </table>
                
                <h3 style="margin-top: 30px;">Actions de test</h3>
                <a href="?action=test" class="btn">Tester la session</a>
                <button class="btn secondary" onclick="testAjax()">Test AJAX</button>
                <button class="btn success" onclick="setCookie()">Créer un cookie</button>
                <button class="btn danger" onclick="clearAll()">Tout effacer</button>
                
                <div id="ajax-result" style="margin-top: 20px;"></div>
            </div>
            
            <!-- Section Aide -->
            <div id="help" class="section">
                <h2>❓ Aide</h2>
                
                <h3>Comment se connecter ?</h3>
                <ol>
                    <li>Utilisez un email d'utilisateur existant (voir onglet "Utilisateurs")</li>
                    <li>Si le mot de passe ne fonctionne pas, cliquez sur "Réinitialiser le mot de passe"</li>
                    <li>Le nouveau mot de passe sera : <code>Test123!</code></li>
                    <li>Connectez-vous avec ce mot de passe</li>
                </ol>
                
                <h3>Problèmes fréquents</h3>
                <ul>
                    <li><strong>Erreur de base de données :</strong> Modifiez les lignes 19-22 avec vos identifiants MySQL</li>
                    <li><strong>Session ne persiste pas :</strong> Vérifiez les permissions du dossier session PHP</li>
                    <li><strong>Page blanche :</strong> Activez l'affichage des erreurs PHP</li>
                </ul>
                
                <h3>Fichiers créés</h3>
                <p>Ce fichier unique contient tout le nécessaire pour :</p>
                <ul>
                    <li>Tester la connexion à la base de données</li>
                    <li>Se connecter avec les utilisateurs existants</li>
                    <li>Réinitialiser les mots de passe</li>
                    <li>Tester les sessions PHP</li>
                </ul>
            </div>
        </div>
        
        <!-- Dashboard Simple (si connecté) -->
        <?php if ($is_logged_in): ?>
        <div class="card">
            <h2>📊 Dashboard Simple</h2>
            <p>Bienvenue sur CEDREPS Ultimate !</p>
            
            <?php if ($pdo): ?>
                <?php
                try {
                    // Statistiques
                    $stats = [];
                    $tables = ['users', 'classes', 'cycles', 'lessons', 'students'];
                    
                    foreach ($tables as $table) {
                        $count = $pdo->query("SELECT COUNT(*) FROM $table")->fetchColumn();
                        $stats[$table] = $count;
                    }
                    ?>
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 15px; margin-top: 20px;">
                        <?php foreach ($stats as $table => $count): ?>
                        <div style="background: #F9FAFB; padding: 15px; border-radius: 8px; text-align: center;">
                            <div style="font-size: 32px; font-weight: bold; color: #667eea;"><?php echo $count; ?></div>
                            <div style="color: #6B7280; text-transform: capitalize;"><?php echo $table; ?></div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                <?php } catch (Exception $e) {
                    echo '<div class="status error">Erreur : ' . $e->getMessage() . '</div>';
                } ?>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
    
    <script>
        function showSection(section) {
            // Masquer toutes les sections
            document.querySelectorAll('.section').forEach(s => {
                s.classList.remove('active');
            });
            document.querySelectorAll('.tab').forEach(t => {
                t.classList.remove('active');
            });
            
            // Afficher la section demandée
            document.getElementById(section).classList.add('active');
            event.target.classList.add('active');
        }
        
        function testAjax() {
            fetch('<?php echo $_SERVER['PHP_SELF']; ?>?action=test')
                .then(response => response.text())
                .then(data => {
                    document.getElementById('ajax-result').innerHTML = '<div class="status info">Réponse AJAX reçue - La page fonctionne !</div>';
                })
                .catch(error => {
                    document.getElementById('ajax-result').innerHTML = '<div class="status error">Erreur AJAX : ' + error + '</div>';
                });
        }
        
        function setCookie() {
            document.cookie = "test_cookie=CEDREPS_OK; path=/";
            alert('Cookie créé : test_cookie=CEDREPS_OK');
        }
        
        function clearAll() {
            if (confirm('Effacer toutes les données locales ?')) {
                localStorage.clear();
                sessionStorage.clear();
                document.cookie.split(";").forEach(c => {
                    document.cookie = c.replace(/^ +/, "").replace(/=.*/, "=;expires=" + new Date().toUTCString() + ";path=/");
                });
                alert('Données locales effacées');
            }
        }
    </script>
</body>
</html>