<?php
/**
 * ╔══════════════════════════════════════════════════════════════╗
 * ║   MIGRATION FINALE - CEDREPS ULTIMATE v2.0                    ║
 * ║   Version corrigée avec les vraies colonnes                   ║
 * ╚══════════════════════════════════════════════════════════════╝
 */

session_start();
$migration_password = 'MigrationCedreps2025';

// Vérification du mot de passe
if (!isset($_GET['pass']) || $_GET['pass'] !== $migration_password) {
    die('Accès refusé - Ajoutez ?pass=MigrationCedreps2025 à l\'URL');
}

$_SESSION['migration_authorized'] = true;

// Si requête AJAX pour migration
if (isset($_POST['action']) && $_POST['action'] === 'migrate') {
    header('Content-Type: application/json');
    performMigration();
    exit;
}

function performMigration() {
    set_time_limit(0);
    ini_set('memory_limit', '512M');
    
    $response = [
        'status' => 'running',
        'messages' => [],
        'progress' => 0,
        'stats' => []
    ];
    
    // Configuration des bases
    $old_config = [
        'host' => 'localhost',
        'name' => 'epsweb_appli',
        'user' => 'epsweb_appli',
        'pass' => 'MF03444janvierA'
    ];
    
    // Charger config nouvelle base
    if (!file_exists(__DIR__ . '/config.php')) {
        $response['status'] = 'error';
        $response['messages'][] = ['type' => 'error', 'text' => 'Fichier config.php manquant'];
        echo json_encode($response);
        return;
    }
    
    require_once __DIR__ . '/config.php';
    $new_config = [
        'host' => $config['database']['host'] ?? 'localhost',
        'name' => $config['database']['name'],
        'user' => $config['database']['user'],
        'pass' => $config['database']['pass']
    ];
    
    try {
        // Connexions
        $pdo_old = new PDO(
            "mysql:host={$old_config['host']};dbname={$old_config['name']};charset=utf8mb4",
            $old_config['user'],
            $old_config['pass'],
            [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
        );
        
        $pdo_new = new PDO(
            "mysql:host={$new_config['host']};dbname={$new_config['name']};charset=utf8mb4",
            $new_config['user'],
            $new_config['pass'],
            [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
        );
        
        $response['messages'][] = ['type' => 'success', 'text' => '✅ Connexion aux bases de données réussie'];
        $response['progress'] = 10;
        
        // ===================================================================
        // RÉCUPÉRATION DES MAPPINGS EXISTANTS
        // ===================================================================
        
        $response['messages'][] = ['type' => 'header', 'text' => '🔄 Récupération des données existantes...'];
        
        // Mapping des utilisateurs
        $user_mapping = [];
        $users_old = $pdo_old->query("SELECT id, email FROM users")->fetchAll(PDO::FETCH_ASSOC);
        foreach ($users_old as $user) {
            $check = $pdo_new->prepare("SELECT id FROM users WHERE email = ?");
            $check->execute([$user['email']]);
            $existing = $check->fetch();
            if ($existing) {
                $user_mapping[$user['id']] = $existing['id'];
            }
        }
        $response['messages'][] = ['type' => 'info', 'text' => '  • ' . count($user_mapping) . ' utilisateurs mappés'];
        
        // Mapping des classes
        $class_mapping = [];
        $classes_old = $pdo_old->query("SELECT id, name FROM classes")->fetchAll(PDO::FETCH_ASSOC);
        foreach ($classes_old as $class) {
            $check = $pdo_new->prepare("SELECT id FROM classes WHERE name = ?");
            $check->execute([$class['name']]);
            $existing = $check->fetch();
            if ($existing) {
                $class_mapping[$class['id']] = $existing['id'];
            }
        }
        $response['messages'][] = ['type' => 'info', 'text' => '  • ' . count($class_mapping) . ' classes mappées'];
        
        // Mapping des cycles
        $cycle_mapping = [];
        $cycles_old = $pdo_old->query("SELECT id, name FROM cycles")->fetchAll(PDO::FETCH_ASSOC);
        foreach ($cycles_old as $cycle) {
            $check = $pdo_new->prepare("SELECT id FROM cycles WHERE name = ?");
            $check->execute([$cycle['name']]);
            $existing = $check->fetch();
            if ($existing) {
                $cycle_mapping[$cycle['id']] = $existing['id'];
            }
        }
        $response['messages'][] = ['type' => 'info', 'text' => '  • ' . count($cycle_mapping) . ' cycles mappés'];
        $response['progress'] = 30;
        
        // ===================================================================
        // MIGRATION DES LEÇONS (avec lesson_no)
        // ===================================================================
        
        $response['messages'][] = ['type' => 'header', 'text' => '📖 Migration des leçons restantes...'];
        
        // Récupérer TOUTES les leçons de l'ancienne base
        $lessons_query = "
            SELECT 
                id,
                cycle_id,
                lesson_no,
                lesson_date,
                title,
                fps,
                cp,
                description,
                content,
                equipment,
                duration_min
            FROM lessons 
            ORDER BY cycle_id, lesson_no
        ";
        
        $lessons = $pdo_old->query($lessons_query)->fetchAll(PDO::FETCH_ASSOC);
        $total_lessons = count($lessons);
        $lessons_migrated = 0;
        $lessons_skipped = 0;
        $lessons_errors = 0;
        
        $response['messages'][] = ['type' => 'info', 'text' => "  • {$total_lessons} leçons à traiter"];
        
        foreach ($lessons as $index => $lesson) {
            // Progression
            if ($index % 10 == 0) {
                $progress = 30 + (($index / $total_lessons) * 60);
                $response['progress'] = round($progress);
            }
            
            // Trouver le cycle correspondant
            $new_cycle_id = $cycle_mapping[$lesson['cycle_id']] ?? null;
            
            if (!$new_cycle_id) {
                $lessons_skipped++;
                continue;
            }
            
            // Utiliser lesson_no comme lesson_number
            $lesson_number = $lesson['lesson_no'] ?? ($index + 1);
            
            // Vérifier si cette leçon existe déjà
            $check = $pdo_new->prepare("
                SELECT id FROM lessons 
                WHERE cycle_id = ? AND lesson_number = ?
            ");
            $check->execute([$new_cycle_id, $lesson_number]);
            
            if ($check->fetch()) {
                $lessons_skipped++;
                continue; // Leçon déjà existante
            }
            
            // Insérer la leçon
            try {
                $stmt = $pdo_new->prepare("
                    INSERT INTO lessons (
                        cycle_id, 
                        lesson_number, 
                        lesson_date, 
                        title,
                        fps, 
                        cp, 
                        description, 
                        material,
                        duration_minutes,
                        status, 
                        created_at
                    ) VALUES (
                        :cycle_id,
                        :lesson_number,
                        :lesson_date,
                        :title,
                        :fps,
                        :cp,
                        :description,
                        :material,
                        :duration,
                        'planned',
                        NOW()
                    )
                ");
                
                // Combiner description et content si nécessaire
                $description_full = trim(($lesson['description'] ?? '') . "\n" . ($lesson['content'] ?? ''));
                
                $stmt->execute([
                    ':cycle_id' => $new_cycle_id,
                    ':lesson_number' => $lesson_number,
                    ':lesson_date' => $lesson['lesson_date'] ?? date('Y-m-d'),
                    ':title' => $lesson['title'] ?? "Leçon {$lesson_number}",
                    ':fps' => $lesson['fps'] ?? '',
                    ':cp' => $lesson['cp'] ?? '',
                    ':description' => $description_full,
                    ':material' => $lesson['equipment'] ?? '',
                    ':duration' => $lesson['duration_min'] ?? 55
                ]);
                
                $lessons_migrated++;
                
            } catch (PDOException $e) {
                if ($e->getCode() == 23000) {
                    // Contrainte d'unicité - essayer avec un nouveau numéro
                    try {
                        $max_stmt = $pdo_new->prepare("
                            SELECT MAX(lesson_number) as max_num 
                            FROM lessons 
                            WHERE cycle_id = ?
                        ");
                        $max_stmt->execute([$new_cycle_id]);
                        $max = $max_stmt->fetch();
                        $new_number = ($max['max_num'] ?? 0) + 1;
                        
                        $stmt->execute([
                            ':cycle_id' => $new_cycle_id,
                            ':lesson_number' => $new_number,
                            ':lesson_date' => $lesson['lesson_date'] ?? date('Y-m-d'),
                            ':title' => $lesson['title'] ?? "Leçon {$new_number}",
                            ':fps' => $lesson['fps'] ?? '',
                            ':cp' => $lesson['cp'] ?? '',
                            ':description' => $description_full,
                            ':material' => $lesson['equipment'] ?? '',
                            ':duration' => $lesson['duration_min'] ?? 55
                        ]);
                        
                        $lessons_migrated++;
                        $response['messages'][] = ['type' => 'warning', 'text' => "  ⚠️ Leçon {$lesson['title']} renumérotée: {$lesson_number} → {$new_number}"];
                        
                    } catch (Exception $e2) {
                        $lessons_errors++;
                        $response['messages'][] = ['type' => 'error', 'text' => "  ❌ Erreur leçon {$lesson['title']}: " . $e2->getMessage()];
                    }
                } else {
                    $lessons_errors++;
                    $response['messages'][] = ['type' => 'error', 'text' => "  ❌ Erreur leçon {$lesson['title']}: " . $e->getMessage()];
                }
            }
        }
        
        $response['messages'][] = ['type' => 'success', 'text' => "  ✅ {$lessons_migrated} leçons migrées avec succès"];
        if ($lessons_skipped > 0) {
            $response['messages'][] = ['type' => 'warning', 'text' => "  ⚠️ {$lessons_skipped} leçons ignorées (déjà existantes ou cycle manquant)"];
        }
        if ($lessons_errors > 0) {
            $response['messages'][] = ['type' => 'error', 'text' => "  ❌ {$lessons_errors} erreurs lors de la migration"];
        }
        
        $response['progress'] = 90;
        
        // ===================================================================
        // VÉRIFICATION FINALE
        // ===================================================================
        
        $response['messages'][] = ['type' => 'header', 'text' => '🔍 Vérification finale...'];
        
        $new_counts = [];
        foreach (['users', 'classes', 'cycles', 'lessons'] as $table) {
            $count = $pdo_new->query("SELECT COUNT(*) as total FROM $table")->fetch();
            $new_counts[$table] = $count['total'];
        }
        
        $response['messages'][] = ['type' => 'info', 'text' => '  • Utilisateurs : ' . $new_counts['users']];
        $response['messages'][] = ['type' => 'info', 'text' => '  • Classes : ' . $new_counts['classes']];
        $response['messages'][] = ['type' => 'info', 'text' => '  • Cycles : ' . $new_counts['cycles']];
        $response['messages'][] = ['type' => 'info', 'text' => '  • Leçons : ' . $new_counts['lessons']];
        
        $response['progress'] = 100;
        $response['status'] = 'completed';
        
        $response['messages'][] = ['type' => 'success', 'text' => ''];
        $response['messages'][] = ['type' => 'success', 'text' => '═══════════════════════════════════════'];
        $response['messages'][] = ['type' => 'success', 'text' => '✅ MIGRATION TERMINÉE AVEC SUCCÈS !'];
        $response['messages'][] = ['type' => 'success', 'text' => '═══════════════════════════════════════'];
        
    } catch (Exception $e) {
        $response['status'] = 'error';
        $response['messages'][] = ['type' => 'error', 'text' => '❌ ERREUR : ' . $e->getMessage()];
        $response['messages'][] = ['type' => 'error', 'text' => 'Ligne : ' . $e->getLine()];
    }
    
    echo json_encode($response);
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Migration Finale - CEDREPS Ultimate</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
        }
        .card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        h1 {
            color: #1F2937;
            margin-bottom: 10px;
        }
        .subtitle {
            color: #6B7280;
            margin-bottom: 30px;
        }
        .info-box {
            background: #EFF6FF;
            border-left: 4px solid #3B82F6;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 30px;
        }
        .console {
            background: #1F2937;
            color: #10B981;
            padding: 20px;
            border-radius: 12px;
            font-family: 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.6;
            height: 500px;
            overflow-y: auto;
            margin: 20px 0;
        }
        .console-line {
            margin: 2px 0;
        }
        .console-success { color: #10B981; }
        .console-error { color: #EF4444; }
        .console-warning { color: #F59E0B; }
        .console-info { color: #3B82F6; }
        .console-header {
            color: #A78BFA;
            font-weight: bold;
            margin: 15px 0 5px 0;
        }
        .btn {
            display: inline-block;
            padding: 14px 32px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 600;
            border: none;
            cursor: pointer;
            font-size: 16px;
            transition: transform 0.2s;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.4);
        }
        .btn.disabled {
            background: #9CA3AF;
            cursor: not-allowed;
            transform: none;
        }
        .btn.success {
            background: linear-gradient(135deg, #10B981 0%, #059669 100%);
        }
        .progress-bar {
            width: 100%;
            height: 40px;
            background: #E5E7EB;
            border-radius: 20px;
            overflow: hidden;
            margin: 30px 0;
        }
        .progress-fill {
            height: 100%;
            background: linear-gradient(90deg, #10B981 0%, #059669 100%);
            transition: width 0.5s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 16px;
        }
        .spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid #E5E7EB;
            border-top-color: white;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-left: 10px;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        .status-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 20px;
            margin-bottom: 30px;
        }
        .status-card {
            background: #F9FAFB;
            padding: 20px;
            border-radius: 12px;
            text-align: center;
        }
        .status-value {
            font-size: 28px;
            font-weight: bold;
            color: #1F2937;
            margin: 10px 0;
        }
        .status-label {
            font-size: 14px;
            color: #6B7280;
        }
        #completion-message {
            display: none;
            background: #F0FDF4;
            border: 2px solid #10B981;
            padding: 20px;
            border-radius: 12px;
            margin-top: 30px;
        }
        .check-item {
            margin: 10px 0;
            padding-left: 30px;
            position: relative;
        }
        .check-item::before {
            content: '✓';
            position: absolute;
            left: 0;
            color: #10B981;
            font-weight: bold;
            font-size: 18px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <h1>🚀 Migration Finale - CEDREPS Ultimate v2.0</h1>
            <p class="subtitle">Migration des leçons avec colonnes correctes (lesson_no → lesson_number)</p>
            
            <div class="info-box">
                <strong>ℹ️ Information importante :</strong>
                <ul style="margin: 10px 0 0 20px;">
                    <li>Utilisation de la colonne <code>lesson_no</code> de votre base</li>
                    <li>Les données déjà migrées seront ignorées</li>
                    <li>121 leçons à traiter</li>
                    <li>Gestion automatique des conflits</li>
                </ul>
            </div>
            
            <!-- Statut -->
            <div class="status-grid">
                <div class="status-card">
                    <div class="status-label">Total à migrer</div>
                    <div class="status-value" style="color: #3B82F6;">121</div>
                    <div class="status-label">leçons</div>
                </div>
                <div class="status-card">
                    <div class="status-label">Migrées</div>
                    <div class="status-value" style="color: #10B981;" id="migrated-count">0</div>
                    <div class="status-label">avec succès</div>
                </div>
                <div class="status-card">
                    <div class="status-label">Ignorées</div>
                    <div class="status-value" style="color: #F59E0B;" id="skipped-count">0</div>
                    <div class="status-label">existantes</div>
                </div>
                <div class="status-card">
                    <div class="status-label">Erreurs</div>
                    <div class="status-value" style="color: #EF4444;" id="error-count">0</div>
                    <div class="status-label">à vérifier</div>
                </div>
            </div>
            
            <!-- Barre de progression -->
            <div class="progress-bar">
                <div class="progress-fill" id="progress" style="width: 0%">0%</div>
            </div>
            
            <!-- Console -->
            <div class="console" id="console">
                <div class="console-line console-info">╔══════════════════════════════════════════════╗</div>
                <div class="console-line console-info">║    MIGRATION FINALE - CEDREPS ULTIMATE       ║</div>
                <div class="console-line console-info">╚══════════════════════════════════════════════╝</div>
                <div class="console-line"></div>
                <div class="console-line">Prêt à migrer vos 121 leçons.</div>
                <div class="console-line">Cliquez sur le bouton pour démarrer.</div>
            </div>
            
            <!-- Boutons -->
            <div style="text-align: center; margin-top: 30px;">
                <button class="btn" id="start-btn" onclick="startMigration()">
                    🚀 Lancer la migration finale
                </button>
            </div>
            
            <!-- Message de completion -->
            <div id="completion-message">
                <h3 style="color: #166534; margin-bottom: 15px;">✅ Migration terminée avec succès !</h3>
                <div class="check-item">Toutes les leçons ont été traitées</div>
                <div class="check-item">Les données sont maintenant dans CEDREPS Ultimate</div>
                <div class="check-item">Vous pouvez vous connecter et vérifier</div>
                
                <div style="text-align: center; margin-top: 30px;">
                    <a href="login.html" class="btn success">
                        Se connecter à CEDREPS Ultimate
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script>
        let migrationInProgress = false;
        
        function updateProgress(percent) {
            const progressBar = document.getElementById('progress');
            progressBar.style.width = percent + '%';
            progressBar.textContent = percent + '%';
        }
        
        function addConsoleLog(message, type = '') {
            const console = document.getElementById('console');
            const line = document.createElement('div');
            line.className = 'console-line';
            if (type) {
                line.className += ' console-' + type;
            }
            line.textContent = message;
            console.appendChild(line);
            console.scrollTop = console.scrollHeight;
        }
        
        async function startMigration() {
            if (migrationInProgress) return;
            
            migrationInProgress = true;
            const btn = document.getElementById('start-btn');
            btn.className = 'btn disabled';
            btn.innerHTML = 'Migration en cours... <span class="spinner"></span>';
            
            // Vider la console
            document.getElementById('console').innerHTML = '';
            addConsoleLog('🚀 Démarrage de la migration...', 'info');
            
            try {
                const response = await fetch(window.location.href, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'action=migrate'
                });
                
                if (!response.ok) {
                    throw new Error('Erreur serveur : ' + response.status);
                }
                
                const data = await response.json();
                
                // Traiter les messages
                if (data.messages && data.messages.length > 0) {
                    data.messages.forEach(msg => {
                        addConsoleLog(msg.text, msg.type);
                    });
                }
                
                // Mettre à jour la progression
                if (data.progress) {
                    updateProgress(data.progress);
                }
                
                // Si terminé
                if (data.status === 'completed') {
                    document.getElementById('completion-message').style.display = 'block';
                    btn.style.display = 'none';
                    
                    // Parser les compteurs depuis les messages
                    const migratedMsg = data.messages.find(m => m.text.includes('migrées avec succès'));
                    if (migratedMsg) {
                        const match = migratedMsg.text.match(/(\d+)/);
                        if (match) {
                            document.getElementById('migrated-count').textContent = match[1];
                        }
                    }
                    
                    const skippedMsg = data.messages.find(m => m.text.includes('ignorées'));
                    if (skippedMsg) {
                        const match = skippedMsg.text.match(/(\d+)/);
                        if (match) {
                            document.getElementById('skipped-count').textContent = match[1];
                        }
                    }
                } else if (data.status === 'error') {
                    btn.className = 'btn';
                    btn.innerHTML = '🚀 Réessayer la migration';
                    migrationInProgress = false;
                }
                
            } catch (error) {
                addConsoleLog('❌ ERREUR : ' + error.message, 'error');
                btn.className = 'btn';
                btn.innerHTML = '🚀 Réessayer la migration';
                migrationInProgress = false;
            }
        }
    </script>
</body>
</html>