<?php
/**
 * ╔══════════════════════════════════════════════════════════════╗
 * ║   MIGRATION EPSWEB_APPLI → CEDREPS ULTIMATE v2.0             ║
 * ║   Version corrigée - Gestion des doublons et contraintes      ║
 * ╚══════════════════════════════════════════════════════════════╝
 */

session_start();

// ===================================================================
// PROTECTION & CONFIGURATION
// ===================================================================

$migration_password = 'MigrationCedreps2025';

// Si c'est une requête AJAX
if (isset($_POST['action']) && $_POST['action'] === 'migrate') {
    header('Content-Type: application/json');
    
    // Vérifier le mot de passe en session
    if (!isset($_SESSION['migration_authorized']) || $_SESSION['migration_authorized'] !== true) {
        echo json_encode(['error' => 'Non autorisé']);
        exit;
    }
    
    // Lancer la migration
    performMigration();
    exit;
}

// Vérification du mot de passe pour l'accès initial
if (!isset($_GET['pass']) || $_GET['pass'] !== $migration_password) {
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <title>Migration CEDREPS - Authentification</title>
        <style>
            body {
                font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 0;
            }
            .auth-box {
                background: white;
                padding: 40px;
                border-radius: 20px;
                box-shadow: 0 25px 50px -12px rgba(0,0,0,0.25);
                text-align: center;
                max-width: 400px;
            }
            h1 { color: #1F2937; margin-top: 0; }
            .info {
                background: #EFF6FF;
                border-left: 4px solid #3B82F6;
                padding: 15px;
                margin: 20px 0;
                text-align: left;
                border-radius: 8px;
            }
            code {
                background: #F3F4F6;
                padding: 4px 8px;
                border-radius: 4px;
                font-family: monospace;
            }
            .url-example {
                background: #1F2937;
                color: #10B981;
                padding: 15px;
                border-radius: 8px;
                margin: 20px 0;
                word-break: break-all;
                font-family: monospace;
                font-size: 13px;
            }
        </style>
    </head>
    <body>
        <div class="auth-box">
            <h1>🔒 Migration Protégée</h1>
            <div class="info">
                <strong>Pour lancer la migration :</strong><br><br>
                Ajoutez le paramètre de sécurité à l'URL
            </div>
            <div class="url-example">
                <?php echo $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF']; ?>?pass=MigrationCedreps2025
            </div>
            <p style="color: #6B7280; font-size: 14px;">
                ⚠️ Notez ce mot de passe : <code>MigrationCedreps2025</code>
            </p>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// Autoriser la session pour les requêtes AJAX
$_SESSION['migration_authorized'] = true;

// ===================================================================
// FONCTION DE MIGRATION (appelée en AJAX)
// ===================================================================

function performMigration() {
    // Configuration de l'environnement
    set_time_limit(0);
    ini_set('memory_limit', '512M');
    
    $response = [
        'status' => 'running',
        'messages' => [],
        'progress' => 0,
        'stats' => []
    ];
    
    // Configuration des bases de données
    $old_config = [
        'host' => 'localhost',
        'name' => 'epsweb_appli',
        'user' => 'epsweb_appli',
        'pass' => 'MF03444janvierA'
    ];
    
    // Charger la configuration de la nouvelle base
    if (file_exists(__DIR__ . '/config.php')) {
        require_once __DIR__ . '/config.php';
        $new_config = [
            'host' => $config['database']['host'] ?? 'localhost',
            'name' => $config['database']['name'],
            'user' => $config['database']['user'],
            'pass' => $config['database']['pass']
        ];
    } else {
        $response['status'] = 'error';
        $response['messages'][] = ['type' => 'error', 'text' => 'Fichier config.php manquant'];
        echo json_encode($response);
        return;
    }
    
    try {
        // Connexion à l'ancienne base
        $response['messages'][] = ['type' => 'info', 'text' => '🔄 Connexion à epsweb_appli...'];
        $pdo_old = new PDO(
            "mysql:host={$old_config['host']};dbname={$old_config['name']};charset=utf8mb4",
            $old_config['user'],
            $old_config['pass'],
            [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
        );
        $response['messages'][] = ['type' => 'success', 'text' => '✅ Connexion à epsweb_appli réussie'];
        $response['progress'] = 5;
        
        // Connexion à la nouvelle base
        $response['messages'][] = ['type' => 'info', 'text' => '🔄 Connexion à CEDREPS Ultimate...'];
        $pdo_new = new PDO(
            "mysql:host={$new_config['host']};dbname={$new_config['name']};charset=utf8mb4",
            $new_config['user'],
            $new_config['pass'],
            [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
        );
        $response['messages'][] = ['type' => 'success', 'text' => '✅ Connexion à CEDREPS Ultimate réussie'];
        $response['progress'] = 10;
        
        // ===================================================================
        // ANALYSE DES DONNÉES
        // ===================================================================
        
        $response['messages'][] = ['type' => 'header', 'text' => '📊 Analyse des données existantes...'];
        
        $counts = [];
        $tables = ['users', 'classes', 'cycles', 'lessons', 'students', 'evaluations'];
        
        foreach ($tables as $table) {
            try {
                $result = $pdo_old->query("SELECT COUNT(*) as total FROM $table")->fetch();
                $counts[$table] = $result['total'];
                $response['messages'][] = ['type' => 'info', 'text' => "  • Table $table : {$counts[$table]} enregistrements"];
                $response['stats'][$table] = $counts[$table];
            } catch (Exception $e) {
                $counts[$table] = 0;
                $response['messages'][] = ['type' => 'warning', 'text' => "  ⚠️ Table $table non trouvée"];
            }
        }
        $response['progress'] = 20;
        
        // ===================================================================
        // MIGRATION DES UTILISATEURS
        // ===================================================================
        
        if ($counts['users'] > 0) {
            $response['messages'][] = ['type' => 'header', 'text' => '👥 Migration des utilisateurs...'];
            
            $users = $pdo_old->query("SELECT * FROM users")->fetchAll(PDO::FETCH_ASSOC);
            $user_mapping = [];
            $users_migrated = 0;
            
            foreach ($users as $user) {
                $check = $pdo_new->prepare("SELECT id FROM users WHERE email = ?");
                $check->execute([$user['email']]);
                $existing = $check->fetch();
                
                if (!$existing) {
                    $stmt = $pdo_new->prepare("
                        INSERT INTO users (
                            name, email, password, avatar_url, 
                            establishment, academy, cedreps_level, 
                            cedreps_xp, is_active, created_at
                        ) VALUES (
                            :name, :email, :password, :avatar,
                            :establishment, :academy, :level,
                            :xp, :active, :created
                        )
                    ");
                    
                    $stmt->execute([
                        ':name' => $user['name'] ?? 'Utilisateur',
                        ':email' => $user['email'],
                        ':password' => $user['password'],
                        ':avatar' => 'https://ui-avatars.com/api/?name=' . urlencode($user['name'] ?? 'User') . '&background=3B82F6&color=ffffff',
                        ':establishment' => 'À définir',
                        ':academy' => 'À définir',
                        ':level' => 1,
                        ':xp' => 100,
                        ':active' => 1,
                        ':created' => $user['created_at'] ?? date('Y-m-d H:i:s')
                    ]);
                    
                    $new_id = $pdo_new->lastInsertId();
                    $user_mapping[$user['id']] = $new_id;
                    
                    // Assigner le rôle ENSEIGNANT
                    $pdo_new->exec("
                        INSERT IGNORE INTO user_roles (user_id, role_id)
                        SELECT $new_id, id FROM roles WHERE code = 'ENSEIGNANT'
                    ");
                    
                    $users_migrated++;
                    $response['messages'][] = ['type' => 'success', 'text' => "  ✅ {$user['name']} migré"];
                } else {
                    $user_mapping[$user['id']] = $existing['id'];
                    $response['messages'][] = ['type' => 'warning', 'text' => "  ⚠️ {$user['email']} existe déjà"];
                }
            }
            
            $response['stats']['users_migrated'] = $users_migrated;
            $response['progress'] = 35;
        }
        
        // ===================================================================
        // MIGRATION DES CLASSES
        // ===================================================================
        
        if ($counts['classes'] > 0) {
            $response['messages'][] = ['type' => 'header', 'text' => '📚 Migration des classes...'];
            
            $classes = $pdo_old->query("SELECT * FROM classes")->fetchAll(PDO::FETCH_ASSOC);
            $class_mapping = [];
            $classes_migrated = 0;
            
            foreach ($classes as $class) {
                // Utiliser un teacher_id existant ou null
                $new_teacher_id = null;
                if (isset($class['teacher_id']) && isset($user_mapping[$class['teacher_id']])) {
                    $new_teacher_id = $user_mapping[$class['teacher_id']];
                } else {
                    // Prendre le premier utilisateur disponible
                    $first_user = $pdo_new->query("SELECT id FROM users LIMIT 1")->fetch();
                    if ($first_user) {
                        $new_teacher_id = $first_user['id'];
                    }
                }
                
                if ($new_teacher_id) {
                    // Vérifier si la classe existe déjà
                    $check = $pdo_new->prepare("SELECT id FROM classes WHERE name = ? AND teacher_id = ?");
                    $check->execute([$class['name'], $new_teacher_id]);
                    $existing = $check->fetch();
                    
                    if (!$existing) {
                        $stmt = $pdo_new->prepare("
                            INSERT INTO classes (
                                name, level, school_year, teacher_id,
                                description, is_active, created_at
                            ) VALUES (
                                :name, :level, :year, :teacher,
                                :desc, :active, :created
                            )
                        ");
                        
                        $stmt->execute([
                            ':name' => $class['name'] ?? 'Classe',
                            ':level' => $class['level'] ?? '6ème',
                            ':year' => '2025-2026',
                            ':teacher' => $new_teacher_id,
                            ':desc' => 'Classe importée depuis epsweb_appli',
                            ':active' => 1,
                            ':created' => $class['created_at'] ?? date('Y-m-d H:i:s')
                        ]);
                        
                        $new_class_id = $pdo_new->lastInsertId();
                        $class_mapping[$class['id']] = $new_class_id;
                        $classes_migrated++;
                        
                        $response['messages'][] = ['type' => 'success', 'text' => "  ✅ Classe {$class['name']} migrée"];
                    } else {
                        $class_mapping[$class['id']] = $existing['id'];
                        $response['messages'][] = ['type' => 'warning', 'text' => "  ⚠️ Classe {$class['name']} existe déjà"];
                    }
                }
            }
            
            $response['stats']['classes_migrated'] = $classes_migrated;
            $response['progress'] = 50;
        }
        
        // ===================================================================
        // MIGRATION DES ÉLÈVES
        // ===================================================================
        
        if ($counts['students'] > 0) {
            $response['messages'][] = ['type' => 'header', 'text' => '👦 Migration des élèves...'];
            
            $students = $pdo_old->query("SELECT * FROM students")->fetchAll(PDO::FETCH_ASSOC);
            $students_migrated = 0;
            $student_mapping = [];
            
            foreach ($students as $student) {
                $new_class_id = $class_mapping[$student['class_id']] ?? null;
                
                if ($new_class_id) {
                    // Vérifier si l'élève existe déjà
                    $check = $pdo_new->prepare("SELECT id FROM students WHERE name = ? AND class_id = ?");
                    $check->execute([$student['name'], $new_class_id]);
                    $existing = $check->fetch();
                    
                    if (!$existing) {
                        $stmt = $pdo_new->prepare("
                            INSERT INTO students (
                                class_id, name, date_of_birth,
                                gender, level, created_at
                            ) VALUES (
                                :class, :name, :dob,
                                :gender, :level, :created
                            )
                        ");
                        
                        $stmt->execute([
                            ':class' => $new_class_id,
                            ':name' => $student['name'],
                            ':dob' => $student['date_of_birth'] ?? null,
                            ':gender' => $student['gender'] ?? 'M',
                            ':level' => 'debutant',
                            ':created' => $student['created_at'] ?? date('Y-m-d H:i:s')
                        ]);
                        
                        $new_student_id = $pdo_new->lastInsertId();
                        $student_mapping[$student['id']] = $new_student_id;
                        $students_migrated++;
                    } else {
                        $student_mapping[$student['id']] = $existing['id'];
                    }
                }
            }
            
            $response['messages'][] = ['type' => 'success', 'text' => "  ✅ $students_migrated élèves migrés"];
            $response['progress'] = 60;
        }
        
        // ===================================================================
        // MIGRATION DES CYCLES
        // ===================================================================
        
        if ($counts['cycles'] > 0) {
            $response['messages'][] = ['type' => 'header', 'text' => '🔄 Migration des cycles...'];
            
            $cycles = $pdo_old->query("SELECT * FROM cycles")->fetchAll(PDO::FETCH_ASSOC);
            $cycle_mapping = [];
            $cycles_migrated = 0;
            
            foreach ($cycles as $cycle) {
                $new_class_id = $class_mapping[$cycle['class_id']] ?? null;
                
                if ($new_class_id) {
                    // Vérifier si le cycle existe déjà
                    $check = $pdo_new->prepare("SELECT id FROM cycles WHERE name = ? AND class_id = ?");
                    $check->execute([$cycle['name'], $new_class_id]);
                    $existing = $check->fetch();
                    
                    if (!$existing) {
                        $ecc_type = determineECCType($cycle['ppsad'] ?? '');
                        
                        $stmt = $pdo_new->prepare("
                            INSERT INTO cycles (
                                class_id, name, ppsad, ecc_type, objective,
                                fps_name, fps_description, start_date, end_date,
                                nb_lessons_planned, status, created_at
                            ) VALUES (
                                :class, :name, :ppsad, :ecc, :objective,
                                :fps_name, :fps_desc, :start, :end,
                                :lessons, :status, :created
                            )
                        ");
                        
                        $stmt->execute([
                            ':class' => $new_class_id,
                            ':name' => $cycle['name'] ?? 'Cycle importé',
                            ':ppsad' => $cycle['ppsad'] ?? 'À définir',
                            ':ecc' => $ecc_type,
                            ':objective' => $cycle['objective'] ?? 'Objectif à définir',
                            ':fps_name' => $cycle['name'] ?? 'FPS importée',
                            ':fps_desc' => $cycle['oe'] ?? $cycle['objective'] ?? '',
                            ':start' => $cycle['start_date'] ?? date('Y-m-d'),
                            ':end' => $cycle['end_date'] ?? date('Y-m-d', strtotime('+2 months')),
                            ':lessons' => 10,
                            ':status' => 'active',
                            ':created' => $cycle['created_at'] ?? date('Y-m-d H:i:s')
                        ]);
                        
                        $new_cycle_id = $pdo_new->lastInsertId();
                        $cycle_mapping[$cycle['id']] = $new_cycle_id;
                        $cycles_migrated++;
                        
                        $response['messages'][] = ['type' => 'success', 'text' => "  ✅ Cycle {$cycle['name']} migré (ECC: $ecc_type)"];
                    } else {
                        $cycle_mapping[$cycle['id']] = $existing['id'];
                        $response['messages'][] = ['type' => 'warning', 'text' => "  ⚠️ Cycle {$cycle['name']} existe déjà"];
                    }
                }
            }
            
            $response['stats']['cycles_migrated'] = $cycles_migrated;
            $response['progress'] = 75;
        }
        
        // ===================================================================
        // MIGRATION DES LEÇONS (CORRIGÉ POUR LES DOUBLONS)
        // ===================================================================
        
        if ($counts['lessons'] > 0) {
            $response['messages'][] = ['type' => 'header', 'text' => '📖 Migration des leçons...'];
            
            $lessons = $pdo_old->query("SELECT * FROM lessons ORDER BY cycle_id, lesson_number")->fetchAll(PDO::FETCH_ASSOC);
            $lessons_migrated = 0;
            $lessons_skipped = 0;
            
            foreach ($lessons as $lesson) {
                $new_cycle_id = $cycle_mapping[$lesson['cycle_id']] ?? null;
                
                if ($new_cycle_id) {
                    // Vérifier si cette combinaison cycle_id + lesson_number existe déjà
                    $check = $pdo_new->prepare("
                        SELECT id FROM lessons 
                        WHERE cycle_id = ? AND lesson_number = ?
                    ");
                    $check->execute([$new_cycle_id, $lesson['lesson_number']]);
                    $existing = $check->fetch();
                    
                    if (!$existing) {
                        try {
                            $stmt = $pdo_new->prepare("
                                INSERT INTO lessons (
                                    cycle_id, lesson_number, lesson_date, title,
                                    fps, cp, description, material, status, created_at
                                ) VALUES (
                                    :cycle, :number, :date, :title,
                                    :fps, :cp, :desc, :material, :status, :created
                                )
                            ");
                            
                            $stmt->execute([
                                ':cycle' => $new_cycle_id,
                                ':number' => $lesson['lesson_number'] ?? 1,
                                ':date' => $lesson['lesson_date'] ?? date('Y-m-d'),
                                ':title' => $lesson['title'] ?? "Leçon {$lesson['lesson_number']}",
                                ':fps' => $lesson['fps'] ?? '',
                                ':cp' => $lesson['cp'] ?? '',
                                ':desc' => $lesson['description'] ?? '',
                                ':material' => $lesson['material'] ?? '',
                                ':status' => 'planned',
                                ':created' => $lesson['created_at'] ?? date('Y-m-d H:i:s')
                            ]);
                            
                            $lessons_migrated++;
                        } catch (PDOException $e) {
                            if ($e->getCode() == 23000) { // Violation de contrainte
                                // Essayer avec un numéro de leçon différent
                                $max_number = $pdo_new->prepare("
                                    SELECT MAX(lesson_number) as max_num 
                                    FROM lessons 
                                    WHERE cycle_id = ?
                                ");
                                $max_number->execute([$new_cycle_id]);
                                $max = $max_number->fetch();
                                $new_number = ($max['max_num'] ?? 0) + 1;
                                
                                try {
                                    $stmt = $pdo_new->prepare("
                                        INSERT INTO lessons (
                                            cycle_id, lesson_number, lesson_date, title,
                                            fps, cp, description, material, status, created_at
                                        ) VALUES (
                                            :cycle, :number, :date, :title,
                                            :fps, :cp, :desc, :material, :status, :created
                                        )
                                    ");
                                    
                                    $stmt->execute([
                                        ':cycle' => $new_cycle_id,
                                        ':number' => $new_number,
                                        ':date' => $lesson['lesson_date'] ?? date('Y-m-d'),
                                        ':title' => $lesson['title'] ?? "Leçon $new_number",
                                        ':fps' => $lesson['fps'] ?? '',
                                        ':cp' => $lesson['cp'] ?? '',
                                        ':desc' => $lesson['description'] ?? '',
                                        ':material' => $lesson['material'] ?? '',
                                        ':status' => 'planned',
                                        ':created' => $lesson['created_at'] ?? date('Y-m-d H:i:s')
                                    ]);
                                    
                                    $lessons_migrated++;
                                    $response['messages'][] = ['type' => 'warning', 'text' => "  ⚠️ Leçon renuméroting: {$lesson['lesson_number']} → $new_number"];
                                } catch (Exception $e2) {
                                    $lessons_skipped++;
                                    $response['messages'][] = ['type' => 'warning', 'text' => "  ⚠️ Impossible de migrer la leçon {$lesson['lesson_number']}"];
                                }
                            } else {
                                throw $e;
                            }
                        }
                    } else {
                        $lessons_skipped++;
                        // Leçon déjà existante, on la passe
                    }
                } else {
                    $lessons_skipped++;
                }
            }
            
            $response['messages'][] = ['type' => 'success', 'text' => "  ✅ $lessons_migrated leçons migrées"];
            if ($lessons_skipped > 0) {
                $response['messages'][] = ['type' => 'warning', 'text' => "  ⚠️ $lessons_skipped leçons ignorées (doublons)"];
            }
            $response['stats']['lessons_migrated'] = $lessons_migrated;
            $response['progress'] = 90;
        }
        
        // ===================================================================
        // MIGRATION DES ÉVALUATIONS (si existantes)
        // ===================================================================
        
        if ($counts['evaluations'] > 0) {
            $response['messages'][] = ['type' => 'header', 'text' => '📊 Migration des évaluations...'];
            
            $evaluations = $pdo_old->query("SELECT * FROM evaluations")->fetchAll(PDO::FETCH_ASSOC);
            $evaluations_migrated = 0;
            
            foreach ($evaluations as $evaluation) {
                // Mapper les IDs
                $new_student_id = $student_mapping[$evaluation['student_id']] ?? null;
                $new_lesson_id = null; // Il faudrait un mapping des leçons aussi
                
                if ($new_student_id) {
                    try {
                        $stmt = $pdo_new->prepare("
                            INSERT INTO evaluations (
                                student_id, lesson_id, score, 
                                comments, created_at
                            ) VALUES (
                                :student, :lesson, :score,
                                :comments, :created
                            )
                        ");
                        
                        $stmt->execute([
                            ':student' => $new_student_id,
                            ':lesson' => $new_lesson_id,
                            ':score' => $evaluation['score'] ?? null,
                            ':comments' => $evaluation['comments'] ?? '',
                            ':created' => $evaluation['created_at'] ?? date('Y-m-d H:i:s')
                        ]);
                        
                        $evaluations_migrated++;
                    } catch (Exception $e) {
                        // Ignorer les erreurs d'évaluation
                    }
                }
            }
            
            if ($evaluations_migrated > 0) {
                $response['messages'][] = ['type' => 'success', 'text' => "  ✅ $evaluations_migrated évaluations migrées"];
            }
        }
        
        // ===================================================================
        // VÉRIFICATION FINALE
        // ===================================================================
        
        $response['messages'][] = ['type' => 'header', 'text' => '🔍 Vérification des données migrées...'];
        
        $new_counts = [];
        foreach (['users', 'classes', 'cycles', 'lessons', 'students'] as $table) {
            $result = $pdo_new->query("SELECT COUNT(*) as total FROM $table")->fetch();
            $new_counts[$table] = $result['total'];
            $response['messages'][] = ['type' => 'info', 'text' => "  • $table : {$new_counts[$table]} enregistrements"];
        }
        
        $response['progress'] = 100;
        $response['status'] = 'completed';
        
        $response['messages'][] = ['type' => 'success', 'text' => '═══════════════════════════════════════'];
        $response['messages'][] = ['type' => 'success', 'text' => '✅ MIGRATION TERMINÉE AVEC SUCCÈS !'];
        $response['messages'][] = ['type' => 'success', 'text' => '═══════════════════════════════════════'];
        
        $response['summary'] = [
            'users' => ['before' => $counts['users'], 'after' => $new_counts['users']],
            'classes' => ['before' => $counts['classes'], 'after' => $new_counts['classes']],
            'cycles' => ['before' => $counts['cycles'], 'after' => $new_counts['cycles']],
            'lessons' => ['before' => $counts['lessons'], 'after' => $new_counts['lessons']],
        ];
        
    } catch (Exception $e) {
        $response['status'] = 'error';
        $response['messages'][] = ['type' => 'error', 'text' => '❌ ERREUR : ' . $e->getMessage()];
        $response['messages'][] = ['type' => 'error', 'text' => 'Ligne : ' . $e->getLine()];
    }
    
    echo json_encode($response);
}

function determineECCType($ppsad) {
    $mapping = [
        'Course de durée' => 'ECC1', 'Demi-fond' => 'ECC1', 'Natation' => 'ECC1',
        'Escalade' => 'ECC2', 'Course d\'orientation' => 'ECC2',
        'Danse' => 'ECC3',
        'Handball' => 'ECC4', 'Volley' => 'ECC4', 'Basketball' => 'ECC4',
        'Football' => 'ECC4', 'Tennis de table' => 'ECC4', 'Badminton' => 'ECC4',
        'Musculation' => 'ECC5',
        'Gymnastique' => 'ECC6', 'Acrosport' => 'ECC6'
    ];
    
    foreach ($mapping as $key => $ecc) {
        if (stripos($ppsad, $key) !== false) {
            return $ecc;
        }
    }
    return 'ECC4';
}

// Si on arrive ici, c'est l'affichage de la page principale
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Migration CEDREPS Ultimate - epsweb_appli</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 900px;
            margin: 0 auto;
        }
        
        .header {
            background: white;
            border-radius: 20px 20px 0 0;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        h1 {
            color: #1F2937;
            font-size: 28px;
            margin-bottom: 10px;
        }
        
        .subtitle {
            color: #6B7280;
            font-size: 16px;
        }
        
        .migration-box {
            background: white;
            border-radius: 0 0 20px 20px;
            padding: 30px;
            margin-top: 2px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        .status-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 30px;
        }
        
        .status-card {
            background: #F9FAFB;
            padding: 15px;
            border-radius: 12px;
            border-left: 4px solid #E5E7EB;
        }
        
        .status-card.success {
            border-color: #10B981;
            background: #F0FDF4;
        }
        
        .status-card.warning {
            border-color: #F59E0B;
            background: #FFFBEB;
        }
        
        .status-card.error {
            border-color: #EF4444;
            background: #FEF2F2;
        }
        
        .status-card.info {
            border-color: #3B82F6;
            background: #EFF6FF;
        }
        
        .status-title {
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
            font-size: 14px;
        }
        
        .status-value {
            font-size: 24px;
            font-weight: bold;
            color: #1F2937;
        }
        
        .console {
            background: #1F2937;
            color: #10B981;
            padding: 20px;
            border-radius: 12px;
            font-family: 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.6;
            height: 400px;
            overflow-y: auto;
            margin: 20px 0;
        }
        
        .console-line {
            margin: 2px 0;
        }
        
        .console-success {
            color: #10B981;
        }
        
        .console-error {
            color: #EF4444;
        }
        
        .console-warning {
            color: #F59E0B;
        }
        
        .console-info {
            color: #3B82F6;
        }
        
        .console-header {
            color: #A78BFA;
            font-weight: bold;
            margin: 15px 0 5px 0;
        }
        
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 600;
            margin-top: 20px;
            transition: transform 0.2s;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }
        
        .btn:hover {
            transform: translateY(-2px);
        }
        
        .btn.disabled {
            background: #9CA3AF;
            cursor: not-allowed;
            transform: none;
        }
        
        .progress-bar {
            width: 100%;
            height: 30px;
            background: #E5E7EB;
            border-radius: 15px;
            overflow: hidden;
            margin: 20px 0;
        }
        
        .progress-fill {
            height: 100%;
            background: linear-gradient(90deg, #10B981 0%, #059669 100%);
            transition: width 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 14px;
        }
        
        .spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid #E5E7EB;
            border-top-color: #3B82F6;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-left: 10px;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        #completion-message {
            display: none;
        }
        
        .info-box {
            background: #EFF6FF;
            border: 1px solid #3B82F6;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        
        .warning-box {
            background: #FFFBEB;
            border: 1px solid #F59E0B;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🚀 Migration CEDREPS Ultimate v2.0</h1>
            <p class="subtitle">Migration depuis epsweb_appli vers CEDREPS Ultimate</p>
        </div>
        
        <div class="migration-box">
            
            <div class="info-box">
                <strong>ℹ️ Version corrigée</strong> - Gestion des doublons et contraintes d'unicité
                <ul style="margin-top: 10px; margin-left: 20px;">
                    <li>Les leçons existantes sont ignorées</li>
                    <li>Renumération automatique si conflit</li>
                    <li>Pas de perte de données</li>
                </ul>
            </div>
            
            <!-- Cartes de statut -->
            <div class="status-grid" id="status-grid">
                <div class="status-card info">
                    <div class="status-title">Base source</div>
                    <div class="status-value">epsweb_appli</div>
                </div>
                <div class="status-card info">
                    <div class="status-title">Base cible</div>
                    <div class="status-value">cedreps_ultimate</div>
                </div>
                <div class="status-card" id="status-users">
                    <div class="status-title">Utilisateurs</div>
                    <div class="status-value">-</div>
                </div>
                <div class="status-card" id="status-classes">
                    <div class="status-title">Classes</div>
                    <div class="status-value">-</div>
                </div>
                <div class="status-card" id="status-cycles">
                    <div class="status-title">Cycles</div>
                    <div class="status-value">-</div>
                </div>
                <div class="status-card" id="status-lessons">
                    <div class="status-title">Leçons</div>
                    <div class="status-value">-</div>
                </div>
            </div>
            
            <!-- Barre de progression -->
            <div class="progress-bar">
                <div class="progress-fill" id="progress" style="width: 0%">0%</div>
            </div>
            
            <!-- Console de migration -->
            <div class="console" id="console">
                <div class="console-line console-info">╔══════════════════════════════════════════════╗</div>
                <div class="console-line console-info">║   MIGRATION EPSWEB → CEDREPS ULTIMATE 2.0   ║</div>
                <div class="console-line console-info">╚══════════════════════════════════════════════╝</div>
                <div class="console-line">&nbsp;</div>
                <div class="console-line">Initialisation de la migration...</div>
                <div class="console-line">Version corrigée avec gestion des contraintes d'unicité.</div>
                <div class="console-line">Appuyez sur "Démarrer la migration" pour commencer.</div>
            </div>
            
            <!-- Boutons d'action -->
            <div style="text-align: center;">
                <button class="btn" id="start-btn" onclick="startMigration()">
                    🚀 Démarrer la migration
                </button>
                <button class="btn" style="background: #EF4444;" onclick="clearAndRetry()">
                    🗑️ Vider et recommencer
                </button>
            </div>
            
            <!-- Message de fin -->
            <div id="completion-message">
                <div class="alert alert-success" style="background: #F0FDF4; border: 1px solid #86EFAC; padding: 15px; border-radius: 8px; margin: 20px 0;">
                    <h3>✅ Migration terminée avec succès !</h3>
                    <p>Toutes vos données ont été transférées vers CEDREPS Ultimate.</p>
                    <ul style="margin-top: 10px; padding-left: 20px;">
                        <li>Les mots de passe ont été conservés</li>
                        <li>Les relations entre les données ont été maintenues</li>
                        <li>Les utilisateurs ont le rôle "ENSEIGNANT" par défaut</li>
                        <li>Les doublons ont été gérés automatiquement</li>
                    </ul>
                </div>
                <a href="login.html" class="btn">Se connecter à CEDREPS Ultimate</a>
            </div>
        </div>
    </div>

    <script>
        let migrationInProgress = false;
        
        function updateProgress(percent) {
            const progressBar = document.getElementById('progress');
            progressBar.style.width = percent + '%';
            progressBar.textContent = percent + '%';
        }
        
        function addConsoleLog(message, type = '') {
            const console = document.getElementById('console');
            const line = document.createElement('div');
            line.className = 'console-line';
            if (type) {
                line.className += ' console-' + type;
            }
            line.innerHTML = message;
            console.appendChild(line);
            console.scrollTop = console.scrollHeight;
        }
        
        function updateStatusCard(id, value, type = '') {
            const card = document.getElementById('status-' + id);
            if (card) {
                card.querySelector('.status-value').textContent = value;
                card.className = 'status-card ' + type;
            }
        }
        
        async function startMigration() {
            if (migrationInProgress) return;
            
            migrationInProgress = true;
            const btn = document.getElementById('start-btn');
            btn.className = 'btn disabled';
            btn.innerHTML = 'Migration en cours... <span class="spinner"></span>';
            
            // Vider la console
            const consoleEl = document.getElementById('console');
            consoleEl.innerHTML = '';
            
            try {
                // Envoyer la requête AJAX
                const response = await fetch('<?php echo $_SERVER['PHP_SELF']; ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'action=migrate'
                });
                
                if (!response.ok) {
                    throw new Error('Erreur serveur : ' + response.status);
                }
                
                const data = await response.json();
                
                // Traiter la réponse
                processResponse(data);
                
            } catch (error) {
                addConsoleLog('❌ ERREUR : ' + error.message, 'error');
                btn.className = 'btn';
                btn.innerHTML = '🚀 Réessayer la migration';
                migrationInProgress = false;
            }
        }
        
        function processResponse(data) {
            // Afficher tous les messages
            if (data.messages && data.messages.length > 0) {
                data.messages.forEach(msg => {
                    addConsoleLog(msg.text, msg.type);
                });
            }
            
            // Mettre à jour la progression
            if (data.progress) {
                updateProgress(data.progress);
            }
            
            // Mettre à jour les stats
            if (data.stats) {
                if (data.stats.users !== undefined) {
                    updateStatusCard('users', data.stats.users, 'info');
                }
                if (data.stats.users_migrated !== undefined) {
                    updateStatusCard('users', data.stats.users_migrated + ' ✓', 'success');
                }
                if (data.stats.classes !== undefined) {
                    updateStatusCard('classes', data.stats.classes, 'info');
                }
                if (data.stats.classes_migrated !== undefined) {
                    updateStatusCard('classes', data.stats.classes_migrated + ' ✓', 'success');
                }
                if (data.stats.cycles !== undefined) {
                    updateStatusCard('cycles', data.stats.cycles, 'info');
                }
                if (data.stats.cycles_migrated !== undefined) {
                    updateStatusCard('cycles', data.stats.cycles_migrated + ' ✓', 'success');
                }
                if (data.stats.lessons !== undefined) {
                    updateStatusCard('lessons', data.stats.lessons, 'info');
                }
                if (data.stats.lessons_migrated !== undefined) {
                    updateStatusCard('lessons', data.stats.lessons_migrated + ' ✓', 'success');
                }
            }
            
            // Si terminé
            if (data.status === 'completed') {
                document.getElementById('completion-message').style.display = 'block';
                document.getElementById('start-btn').style.display = 'none';
                
                // Afficher le résumé
                if (data.summary) {
                    addConsoleLog('', '');
                    addConsoleLog('📊 Résumé de la migration :', 'info');
                    for (const [table, counts] of Object.entries(data.summary)) {
                        addConsoleLog(`  • ${table} : ${counts.before} → ${counts.after}`, 'info');
                    }
                }
            } else if (data.status === 'error') {
                const btn = document.getElementById('start-btn');
                btn.className = 'btn';
                btn.innerHTML = '🚀 Réessayer la migration';
                migrationInProgress = false;
            }
        }
        
        function clearAndRetry() {
            if (confirm('⚠️ ATTENTION : Cela va vider toutes les données de la nouvelle base avant de relancer la migration. Êtes-vous sûr ?')) {
                alert('Fonctionnalité à implémenter : vider les tables et relancer');
                // Ici vous pourriez ajouter une requête pour vider les tables
            }
        }
    </script>
</body>
</html>