<?php
/**
 * ╔══════════════════════════════════════════════════════════════╗
 * ║   MIGRATION EPSWEB_APPLI → CEDREPS ULTIMATE v2.0             ║
 * ║   Script de migration depuis votre ancienne base de données   ║
 * ╚══════════════════════════════════════════════════════════════╝
 */

// ===================================================================
// PROTECTION & CONFIGURATION
// ===================================================================

// Protection par mot de passe
$migration_password = 'MigrationCedreps2025';
if (!isset($_GET['pass']) || $_GET['pass'] !== $migration_password) {
    die('
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <title>Migration CEDREPS - Authentification</title>
        <style>
            body {
                font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 0;
            }
            .auth-box {
                background: white;
                padding: 40px;
                border-radius: 20px;
                box-shadow: 0 25px 50px -12px rgba(0,0,0,0.25);
                text-align: center;
                max-width: 400px;
            }
            h1 { color: #1F2937; margin-top: 0; }
            .info {
                background: #EFF6FF;
                border-left: 4px solid #3B82F6;
                padding: 15px;
                margin: 20px 0;
                text-align: left;
                border-radius: 8px;
            }
            code {
                background: #F3F4F6;
                padding: 4px 8px;
                border-radius: 4px;
                font-family: monospace;
            }
            .url-example {
                background: #1F2937;
                color: #10B981;
                padding: 15px;
                border-radius: 8px;
                margin: 20px 0;
                word-break: break-all;
                font-family: monospace;
                font-size: 13px;
            }
        </style>
    </head>
    <body>
        <div class="auth-box">
            <h1>🔒 Migration Protégée</h1>
            <div class="info">
                <strong>Pour lancer la migration :</strong><br><br>
                Ajoutez le paramètre de sécurité à l\'URL
            </div>
            <div class="url-example">
                ' . $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] . '?pass=MigrationCedreps2025
            </div>
            <p style="color: #6B7280; font-size: 14px;">
                ⚠️ Notez ce mot de passe : <code>MigrationCedreps2025</code>
            </p>
        </div>
    </body>
    </html>
    ');
}

// Configuration de l'environnement
ini_set('display_errors', 1);
error_reporting(E_ALL);
set_time_limit(0);
ini_set('memory_limit', '512M');

// ===================================================================
// CONNEXIONS AUX BASES DE DONNÉES
// ===================================================================

// 1. ANCIENNE BASE DE DONNÉES (epsweb_appli)
$old_config = [
    'host' => 'localhost',
    'name' => 'epsweb_appli',
    'user' => 'epsweb_appli',
    'pass' => 'MF03444janvierA'
];

// 2. NOUVELLE BASE DE DONNÉES (à configurer)
// Charger la configuration depuis config.php ou .env
if (file_exists(__DIR__ . '/config.php')) {
    require_once __DIR__ . '/config.php';
    $new_config = [
        'host' => $config['database']['host'] ?? 'localhost',
        'name' => $config['database']['name'],
        'user' => $config['database']['user'],
        'pass' => $config['database']['pass']
    ];
} else {
    // Configuration manuelle si config.php n'existe pas
    die('
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <title>Configuration Requise</title>
        <style>
            body {
                font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
                background: #FEF2F2;
                padding: 40px;
            }
            .error {
                background: white;
                border-left: 4px solid #EF4444;
                padding: 20px;
                max-width: 600px;
                margin: auto;
                border-radius: 8px;
            }
            h2 { color: #EF4444; }
            code {
                background: #F3F4F6;
                padding: 2px 6px;
                border-radius: 4px;
                font-family: monospace;
            }
        </style>
    </head>
    <body>
        <div class="error">
            <h2>⚠️ Fichier config.php manquant</h2>
            <p>Le fichier <code>config.php</code> n\'a pas été trouvé.</p>
            <p>Assurez-vous que :</p>
            <ol>
                <li>Vous avez bien uploadé tous les fichiers</li>
                <li>Le fichier <code>config_cpanel.php</code> a été renommé en <code>config.php</code></li>
                <li>Le fichier <code>.env</code> est configuré avec vos identifiants MySQL</li>
            </ol>
        </div>
    </body>
    </html>
    ');
}

// ===================================================================
// INTERFACE HTML
// ===================================================================
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Migration CEDREPS Ultimate - epsweb_appli</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 900px;
            margin: 0 auto;
        }
        
        .header {
            background: white;
            border-radius: 20px 20px 0 0;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        h1 {
            color: #1F2937;
            font-size: 28px;
            margin-bottom: 10px;
        }
        
        .subtitle {
            color: #6B7280;
            font-size: 16px;
        }
        
        .migration-box {
            background: white;
            border-radius: 0 0 20px 20px;
            padding: 30px;
            margin-top: 2px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        .status-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 30px;
        }
        
        .status-card {
            background: #F9FAFB;
            padding: 15px;
            border-radius: 12px;
            border-left: 4px solid #E5E7EB;
        }
        
        .status-card.success {
            border-color: #10B981;
            background: #F0FDF4;
        }
        
        .status-card.warning {
            border-color: #F59E0B;
            background: #FFFBEB;
        }
        
        .status-card.error {
            border-color: #EF4444;
            background: #FEF2F2;
        }
        
        .status-card.info {
            border-color: #3B82F6;
            background: #EFF6FF;
        }
        
        .status-title {
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
            font-size: 14px;
        }
        
        .status-value {
            font-size: 24px;
            font-weight: bold;
            color: #1F2937;
        }
        
        .console {
            background: #1F2937;
            color: #10B981;
            padding: 20px;
            border-radius: 12px;
            font-family: 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.6;
            height: 400px;
            overflow-y: auto;
            margin: 20px 0;
        }
        
        .console-line {
            margin: 2px 0;
        }
        
        .console-success {
            color: #10B981;
        }
        
        .console-error {
            color: #EF4444;
        }
        
        .console-warning {
            color: #F59E0B;
        }
        
        .console-info {
            color: #3B82F6;
        }
        
        .console-header {
            color: #A78BFA;
            font-weight: bold;
            margin: 15px 0 5px 0;
        }
        
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 600;
            margin-top: 20px;
            transition: transform 0.2s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
        }
        
        .btn.disabled {
            background: #9CA3AF;
            cursor: not-allowed;
            transform: none;
        }
        
        .progress-bar {
            width: 100%;
            height: 30px;
            background: #E5E7EB;
            border-radius: 15px;
            overflow: hidden;
            margin: 20px 0;
        }
        
        .progress-fill {
            height: 100%;
            background: linear-gradient(90deg, #10B981 0%, #059669 100%);
            transition: width 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 14px;
        }
        
        .step-indicator {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
        }
        
        .step {
            flex: 1;
            text-align: center;
            position: relative;
        }
        
        .step::after {
            content: '';
            position: absolute;
            top: 15px;
            left: 50%;
            width: 100%;
            height: 2px;
            background: #E5E7EB;
            z-index: -1;
        }
        
        .step:last-child::after {
            display: none;
        }
        
        .step.active .step-circle {
            background: #3B82F6;
            color: white;
        }
        
        .step.completed .step-circle {
            background: #10B981;
            color: white;
        }
        
        .step-circle {
            width: 30px;
            height: 30px;
            background: #E5E7EB;
            color: #9CA3AF;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 5px;
            font-weight: bold;
            font-size: 14px;
        }
        
        .step-label {
            font-size: 12px;
            color: #6B7280;
        }
        
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
        }
        
        .alert-warning {
            background: #FFFBEB;
            border: 1px solid #FCD34D;
            color: #92400E;
        }
        
        .alert-success {
            background: #F0FDF4;
            border: 1px solid #86EFAC;
            color: #166534;
        }
        
        .spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid #E5E7EB;
            border-top-color: #3B82F6;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-left: 10px;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🚀 Migration CEDREPS Ultimate v2.0</h1>
            <p class="subtitle">Migration depuis epsweb_appli vers CEDREPS Ultimate</p>
        </div>
        
        <div class="migration-box">
            <!-- Indicateur d'étapes -->
            <div class="step-indicator">
                <div class="step active" id="step-1">
                    <div class="step-circle">1</div>
                    <div class="step-label">Connexion</div>
                </div>
                <div class="step" id="step-2">
                    <div class="step-circle">2</div>
                    <div class="step-label">Analyse</div>
                </div>
                <div class="step" id="step-3">
                    <div class="step-circle">3</div>
                    <div class="step-label">Migration</div>
                </div>
                <div class="step" id="step-4">
                    <div class="step-circle">4</div>
                    <div class="step-label">Vérification</div>
                </div>
                <div class="step" id="step-5">
                    <div class="step-circle">5</div>
                    <div class="step-label">Terminé</div>
                </div>
            </div>
            
            <!-- Cartes de statut -->
            <div class="status-grid" id="status-grid">
                <div class="status-card info">
                    <div class="status-title">Base source</div>
                    <div class="status-value">epsweb_appli</div>
                </div>
                <div class="status-card info">
                    <div class="status-title">Base cible</div>
                    <div class="status-value"><?= htmlspecialchars($new_config['name']) ?></div>
                </div>
                <div class="status-card" id="status-users">
                    <div class="status-title">Utilisateurs</div>
                    <div class="status-value">-</div>
                </div>
                <div class="status-card" id="status-classes">
                    <div class="status-title">Classes</div>
                    <div class="status-value">-</div>
                </div>
                <div class="status-card" id="status-cycles">
                    <div class="status-title">Cycles</div>
                    <div class="status-value">-</div>
                </div>
                <div class="status-card" id="status-lessons">
                    <div class="status-title">Leçons</div>
                    <div class="status-value">-</div>
                </div>
            </div>
            
            <!-- Barre de progression -->
            <div class="progress-bar">
                <div class="progress-fill" id="progress" style="width: 0%">0%</div>
            </div>
            
            <!-- Console de migration -->
            <div class="console" id="console">
                <div class="console-line console-info">╔══════════════════════════════════════════════╗</div>
                <div class="console-line console-info">║   MIGRATION EPSWEB → CEDREPS ULTIMATE 2.0   ║</div>
                <div class="console-line console-info">╚══════════════════════════════════════════════╝</div>
                <div class="console-line">&nbsp;</div>
                <div class="console-line">Initialisation de la migration...</div>
                <div class="console-line">Appuyez sur "Démarrer la migration" pour commencer.</div>
            </div>
            
            <!-- Boutons d'action -->
            <div style="text-align: center;">
                <button class="btn" id="start-btn" onclick="startMigration()">
                    🚀 Démarrer la migration
                </button>
            </div>
            
            <!-- Message de fin -->
            <div id="completion-message" style="display: none;">
                <div class="alert alert-success">
                    <h3>✅ Migration terminée avec succès !</h3>
                    <p>Toutes vos données ont été transférées vers CEDREPS Ultimate.</p>
                    <ul style="margin-top: 10px; padding-left: 20px;">
                        <li>Les mots de passe ont été conservés</li>
                        <li>Les relations entre les données ont été maintenues</li>
                        <li>Les utilisateurs ont le rôle "ENSEIGNANT" par défaut</li>
                    </ul>
                </div>
                <a href="login.html" class="btn">Se connecter à CEDREPS Ultimate</a>
            </div>
        </div>
    </div>

    <script>
        let migrationInProgress = false;
        
        function updateStep(stepNumber) {
            for (let i = 1; i <= 5; i++) {
                const step = document.getElementById(`step-${i}`);
                if (i < stepNumber) {
                    step.classList.add('completed');
                    step.classList.remove('active');
                } else if (i === stepNumber) {
                    step.classList.add('active');
                    step.classList.remove('completed');
                } else {
                    step.classList.remove('active', 'completed');
                }
            }
        }
        
        function updateProgress(percent) {
            const progressBar = document.getElementById('progress');
            progressBar.style.width = percent + '%';
            progressBar.textContent = percent + '%';
        }
        
        function addConsoleLog(message, type = '') {
            const console = document.getElementById('console');
            const line = document.createElement('div');
            line.className = 'console-line';
            if (type) {
                line.className += ' console-' + type;
            }
            line.innerHTML = message;
            console.appendChild(line);
            console.scrollTop = console.scrollHeight;
        }
        
        function updateStatusCard(id, value, type = '') {
            const card = document.getElementById('status-' + id);
            if (card) {
                card.querySelector('.status-value').textContent = value;
                card.className = 'status-card ' + type;
            }
        }
        
        async function startMigration() {
            if (migrationInProgress) return;
            
            migrationInProgress = true;
            document.getElementById('start-btn').className = 'btn disabled';
            document.getElementById('start-btn').innerHTML = 'Migration en cours... <span class="spinner"></span>';
            
            // Lancer la migration côté serveur
            performMigration();
        }
        
        function performMigration() {
            // Le code PHP de migration s'exécute ici
            <?php
            flush();
            ob_flush();
            
            // ===================================================================
            // DÉBUT DE LA MIGRATION PHP
            // ===================================================================
            
            echo "addConsoleLog('', '');";
            echo "addConsoleLog('🔄 Connexion aux bases de données...', 'header');";
            echo "updateStep(1);";
            echo "updateProgress(5);";
            flush();
            ob_flush();
            
            try {
                // Connexion à l'ancienne base
                $pdo_old = new PDO(
                    "mysql:host={$old_config['host']};dbname={$old_config['name']};charset=utf8mb4",
                    $old_config['user'],
                    $old_config['pass'],
                    [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
                );
                
                echo "addConsoleLog('✅ Connexion à epsweb_appli réussie', 'success');";
                flush();
                ob_flush();
                
                // Connexion à la nouvelle base
                $pdo_new = new PDO(
                    "mysql:host={$new_config['host']};dbname={$new_config['name']};charset=utf8mb4",
                    $new_config['user'],
                    $new_config['pass'],
                    [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
                );
                
                echo "addConsoleLog('✅ Connexion à CEDREPS Ultimate réussie', 'success');";
                echo "updateProgress(10);";
                flush();
                ob_flush();
                
                // ===================================================================
                // ANALYSE DES DONNÉES
                // ===================================================================
                
                echo "addConsoleLog('', '');";
                echo "addConsoleLog('📊 Analyse des données existantes...', 'header');";
                echo "updateStep(2);";
                flush();
                ob_flush();
                
                // Compter les enregistrements
                $counts = [];
                $tables = ['users', 'classes', 'cycles', 'lessons', 'students', 'evaluations'];
                
                foreach ($tables as $table) {
                    try {
                        $result = $pdo_old->query("SELECT COUNT(*) as total FROM $table")->fetch();
                        $counts[$table] = $result['total'];
                        echo "addConsoleLog('  • Table $table : {$counts[$table]} enregistrements', 'info');";
                        
                        if ($table == 'users') {
                            echo "updateStatusCard('users', '{$counts[$table]}', 'info');";
                        } elseif ($table == 'classes') {
                            echo "updateStatusCard('classes', '{$counts[$table]}', 'info');";
                        } elseif ($table == 'cycles') {
                            echo "updateStatusCard('cycles', '{$counts[$table]}', 'info');";
                        } elseif ($table == 'lessons') {
                            echo "updateStatusCard('lessons', '{$counts[$table]}', 'info');";
                        }
                    } catch (Exception $e) {
                        $counts[$table] = 0;
                        echo "addConsoleLog('  ⚠️ Table $table non trouvée', 'warning');";
                    }
                    flush();
                    ob_flush();
                }
                
                echo "updateProgress(20);";
                
                // ===================================================================
                // MIGRATION DES UTILISATEURS
                // ===================================================================
                
                if ($counts['users'] > 0) {
                    echo "addConsoleLog('', '');";
                    echo "addConsoleLog('👥 Migration des utilisateurs...', 'header');";
                    echo "updateStep(3);";
                    flush();
                    ob_flush();
                    
                    $users = $pdo_old->query("SELECT * FROM users")->fetchAll(PDO::FETCH_ASSOC);
                    $user_mapping = [];
                    $users_migrated = 0;
                    
                    foreach ($users as $user) {
                        // Vérifier si l'utilisateur existe déjà
                        $check = $pdo_new->prepare("SELECT id FROM users WHERE email = ?");
                        $check->execute([$user['email']]);
                        $existing = $check->fetch();
                        
                        if (!$existing) {
                            $stmt = $pdo_new->prepare("
                                INSERT INTO users (
                                    name, email, password, avatar_url, 
                                    establishment, academy, cedreps_level, 
                                    cedreps_xp, is_active, created_at
                                ) VALUES (
                                    :name, :email, :password, :avatar,
                                    :establishment, :academy, :level,
                                    :xp, :active, :created
                                )
                            ");
                            
                            $stmt->execute([
                                ':name' => $user['name'] ?? 'Utilisateur',
                                ':email' => $user['email'],
                                ':password' => $user['password'],
                                ':avatar' => 'https://ui-avatars.com/api/?name=' . urlencode($user['name'] ?? 'User') . '&background=3B82F6&color=ffffff',
                                ':establishment' => 'À définir',
                                ':academy' => 'À définir',
                                ':level' => 1,
                                ':xp' => 100,
                                ':active' => 1,
                                ':created' => $user['created_at'] ?? date('Y-m-d H:i:s')
                            ]);
                            
                            $new_id = $pdo_new->lastInsertId();
                            $user_mapping[$user['id']] = $new_id;
                            
                            // Assigner le rôle ENSEIGNANT
                            $pdo_new->exec("
                                INSERT INTO user_roles (user_id, role_id)
                                SELECT $new_id, id FROM roles WHERE code = 'ENSEIGNANT'
                            ");
                            
                            $users_migrated++;
                            echo "addConsoleLog('  ✅ {$user['name']} migré', 'success');";
                        } else {
                            $user_mapping[$user['id']] = $existing['id'];
                            echo "addConsoleLog('  ⚠️ {$user['email']} existe déjà', 'warning');";
                        }
                        flush();
                        ob_flush();
                    }
                    
                    echo "updateStatusCard('users', '$users_migrated ✓', 'success');";
                    echo "updateProgress(35);";
                }
                
                // ===================================================================
                // MIGRATION DES CLASSES
                // ===================================================================
                
                if ($counts['classes'] > 0) {
                    echo "addConsoleLog('', '');";
                    echo "addConsoleLog('📚 Migration des classes...', 'header');";
                    flush();
                    ob_flush();
                    
                    $classes = $pdo_old->query("SELECT * FROM classes")->fetchAll(PDO::FETCH_ASSOC);
                    $class_mapping = [];
                    $classes_migrated = 0;
                    
                    foreach ($classes as $class) {
                        $new_teacher_id = $user_mapping[$class['teacher_id']] ?? null;
                        
                        if ($new_teacher_id) {
                            $stmt = $pdo_new->prepare("
                                INSERT INTO classes (
                                    name, level, school_year, teacher_id,
                                    description, is_active, created_at
                                ) VALUES (
                                    :name, :level, :year, :teacher,
                                    :desc, :active, :created
                                )
                            ");
                            
                            $stmt->execute([
                                ':name' => $class['name'] ?? 'Classe',
                                ':level' => $class['level'] ?? '6ème',
                                ':year' => '2025-2026',
                                ':teacher' => $new_teacher_id,
                                ':desc' => 'Classe importée depuis epsweb_appli',
                                ':active' => 1,
                                ':created' => $class['created_at'] ?? date('Y-m-d H:i:s')
                            ]);
                            
                            $new_class_id = $pdo_new->lastInsertId();
                            $class_mapping[$class['id']] = $new_class_id;
                            $classes_migrated++;
                            
                            echo "addConsoleLog('  ✅ Classe {$class['name']} migrée', 'success');";
                        }
                        flush();
                        ob_flush();
                    }
                    
                    echo "updateStatusCard('classes', '$classes_migrated ✓', 'success');";
                    echo "updateProgress(50);";
                }
                
                // ===================================================================
                // MIGRATION DES ÉLÈVES
                // ===================================================================
                
                if ($counts['students'] > 0) {
                    echo "addConsoleLog('', '');";
                    echo "addConsoleLog('👦 Migration des élèves...', 'header');";
                    flush();
                    ob_flush();
                    
                    $students = $pdo_old->query("SELECT * FROM students")->fetchAll(PDO::FETCH_ASSOC);
                    $students_migrated = 0;
                    
                    foreach ($students as $student) {
                        $new_class_id = $class_mapping[$student['class_id']] ?? null;
                        
                        if ($new_class_id) {
                            $stmt = $pdo_new->prepare("
                                INSERT INTO students (
                                    class_id, name, date_of_birth,
                                    gender, level, created_at
                                ) VALUES (
                                    :class, :name, :dob,
                                    :gender, :level, :created
                                )
                            ");
                            
                            $stmt->execute([
                                ':class' => $new_class_id,
                                ':name' => $student['name'],
                                ':dob' => $student['date_of_birth'] ?? null,
                                ':gender' => $student['gender'] ?? 'M',
                                ':level' => 'debutant',
                                ':created' => $student['created_at'] ?? date('Y-m-d H:i:s')
                            ]);
                            
                            $students_migrated++;
                        }
                    }
                    
                    echo "addConsoleLog('  ✅ $students_migrated élèves migrés', 'success');";
                    echo "updateProgress(60);";
                }
                
                // ===================================================================
                // MIGRATION DES CYCLES
                // ===================================================================
                
                if ($counts['cycles'] > 0) {
                    echo "addConsoleLog('', '');";
                    echo "addConsoleLog('🔄 Migration des cycles...', 'header');";
                    flush();
                    ob_flush();
                    
                    $cycles = $pdo_old->query("SELECT * FROM cycles")->fetchAll(PDO::FETCH_ASSOC);
                    $cycle_mapping = [];
                    $cycles_migrated = 0;
                    
                    // Fonction pour déterminer l'ECC
                    function getECCType($ppsad) {
                        $mapping = [
                            'Course de durée' => 'ECC1', 'Demi-fond' => 'ECC1', 'Natation' => 'ECC1',
                            'Escalade' => 'ECC2', 'Course d\'orientation' => 'ECC2',
                            'Danse' => 'ECC3',
                            'Handball' => 'ECC4', 'Volley' => 'ECC4', 'Basketball' => 'ECC4',
                            'Football' => 'ECC4', 'Tennis de table' => 'ECC4', 'Badminton' => 'ECC4',
                            'Musculation' => 'ECC5',
                            'Gymnastique' => 'ECC6', 'Acrosport' => 'ECC6'
                        ];
                        
                        foreach ($mapping as $key => $ecc) {
                            if (stripos($ppsad, $key) !== false) {
                                return $ecc;
                            }
                        }
                        return 'ECC4';
                    }
                    
                    foreach ($cycles as $cycle) {
                        $new_class_id = $class_mapping[$cycle['class_id']] ?? null;
                        
                        if ($new_class_id) {
                            $ecc_type = getECCType($cycle['ppsad'] ?? '');
                            
                            $stmt = $pdo_new->prepare("
                                INSERT INTO cycles (
                                    class_id, name, ppsad, ecc_type, objective,
                                    fps_name, fps_description, start_date, end_date,
                                    nb_lessons_planned, status, created_at
                                ) VALUES (
                                    :class, :name, :ppsad, :ecc, :objective,
                                    :fps_name, :fps_desc, :start, :end,
                                    :lessons, :status, :created
                                )
                            ");
                            
                            $stmt->execute([
                                ':class' => $new_class_id,
                                ':name' => $cycle['name'] ?? 'Cycle importé',
                                ':ppsad' => $cycle['ppsad'] ?? 'À définir',
                                ':ecc' => $ecc_type,
                                ':objective' => $cycle['objective'] ?? 'Objectif à définir',
                                ':fps_name' => $cycle['name'] ?? 'FPS importée',
                                ':fps_desc' => $cycle['oe'] ?? $cycle['objective'] ?? '',
                                ':start' => $cycle['start_date'] ?? date('Y-m-d'),
                                ':end' => $cycle['end_date'] ?? date('Y-m-d', strtotime('+2 months')),
                                ':lessons' => 10,
                                ':status' => 'active',
                                ':created' => $cycle['created_at'] ?? date('Y-m-d H:i:s')
                            ]);
                            
                            $new_cycle_id = $pdo_new->lastInsertId();
                            $cycle_mapping[$cycle['id']] = $new_cycle_id;
                            $cycles_migrated++;
                            
                            echo "addConsoleLog('  ✅ Cycle {$cycle['name']} migré (ECC: $ecc_type)', 'success');";
                        }
                        flush();
                        ob_flush();
                    }
                    
                    echo "updateStatusCard('cycles', '$cycles_migrated ✓', 'success');";
                    echo "updateProgress(75);";
                }
                
                // ===================================================================
                // MIGRATION DES LEÇONS
                // ===================================================================
                
                if ($counts['lessons'] > 0) {
                    echo "addConsoleLog('', '');";
                    echo "addConsoleLog('📖 Migration des leçons...', 'header');";
                    flush();
                    ob_flush();
                    
                    $lessons = $pdo_old->query("SELECT * FROM lessons")->fetchAll(PDO::FETCH_ASSOC);
                    $lessons_migrated = 0;
                    
                    foreach ($lessons as $lesson) {
                        $new_cycle_id = $cycle_mapping[$lesson['cycle_id']] ?? null;
                        
                        if ($new_cycle_id) {
                            $stmt = $pdo_new->prepare("
                                INSERT INTO lessons (
                                    cycle_id, lesson_number, lesson_date, title,
                                    fps, cp, description, material, status, created_at
                                ) VALUES (
                                    :cycle, :number, :date, :title,
                                    :fps, :cp, :desc, :material, :status, :created
                                )
                            ");
                            
                            $stmt->execute([
                                ':cycle' => $new_cycle_id,
                                ':number' => $lesson['lesson_number'] ?? 1,
                                ':date' => $lesson['lesson_date'] ?? date('Y-m-d'),
                                ':title' => $lesson['title'] ?? "Leçon {$lesson['lesson_number']}",
                                ':fps' => $lesson['fps'] ?? '',
                                ':cp' => $lesson['cp'] ?? '',
                                ':desc' => $lesson['description'] ?? '',
                                ':material' => $lesson['material'] ?? '',
                                ':status' => 'planned',
                                ':created' => $lesson['created_at'] ?? date('Y-m-d H:i:s')
                            ]);
                            
                            $lessons_migrated++;
                        }
                    }
                    
                    echo "addConsoleLog('  ✅ $lessons_migrated leçons migrées', 'success');";
                    echo "updateStatusCard('lessons', '$lessons_migrated ✓', 'success');";
                    echo "updateProgress(90);";
                }
                
                // ===================================================================
                // VÉRIFICATION FINALE
                // ===================================================================
                
                echo "addConsoleLog('', '');";
                echo "addConsoleLog('🔍 Vérification des données migrées...', 'header');";
                echo "updateStep(4);";
                flush();
                ob_flush();
                
                // Compter les enregistrements dans la nouvelle base
                $new_counts = [];
                foreach (['users', 'classes', 'cycles', 'lessons', 'students'] as $table) {
                    $result = $pdo_new->query("SELECT COUNT(*) as total FROM $table")->fetch();
                    $new_counts[$table] = $result['total'];
                    echo "addConsoleLog('  • $table : {$new_counts[$table]} enregistrements', 'info');";
                }
                
                echo "updateProgress(100);";
                echo "updateStep(5);";
                
                // ===================================================================
                // FIN DE LA MIGRATION
                // ===================================================================
                
                echo "addConsoleLog('', '');";
                echo "addConsoleLog('═══════════════════════════════════════', 'success');";
                echo "addConsoleLog('✅ MIGRATION TERMINÉE AVEC SUCCÈS !', 'success');";
                echo "addConsoleLog('═══════════════════════════════════════', 'success');";
                echo "addConsoleLog('', '');";
                echo "addConsoleLog('📊 Résumé de la migration :', 'info');";
                echo "addConsoleLog('  • Utilisateurs : {$counts['users']} → {$new_counts['users']}', 'info');";
                echo "addConsoleLog('  • Classes : {$counts['classes']} → {$new_counts['classes']}', 'info');";
                echo "addConsoleLog('  • Cycles : {$counts['cycles']} → {$new_counts['cycles']}', 'info');";
                echo "addConsoleLog('  • Leçons : {$counts['lessons']} → {$new_counts['lessons']}', 'info');";
                echo "addConsoleLog('', '');";
                echo "addConsoleLog('ℹ️ Notes importantes :', 'warning');";
                echo "addConsoleLog('  • Les mots de passe ont été conservés', 'warning');";
                echo "addConsoleLog('  • Tous les utilisateurs ont le rôle ENSEIGNANT', 'warning');";
                echo "addConsoleLog('  • Connectez-vous pour assigner les rôles', 'warning');";
                echo "addConsoleLog('  • Supprimez ce fichier après utilisation !', 'warning');";
                
                // Afficher le message de completion
                echo "document.getElementById('completion-message').style.display = 'block';";
                echo "document.getElementById('start-btn').style.display = 'none';";
                
            } catch (Exception $e) {
                echo "addConsoleLog('❌ ERREUR : " . addslashes($e->getMessage()) . "', 'error');";
                echo "updateStep(0);";
                echo "document.getElementById('start-btn').className = 'btn';";
                echo "document.getElementById('start-btn').innerHTML = '🚀 Réessayer la migration';";
                echo "migrationInProgress = false;";
            }
            
            ?>
        }
    </script>
</body>
</html>