<?php
/**
 * ╔══════════════════════════════════════════════════════════════╗
 * ║         CEDREPS ULTIMATE - Système de Partage Avancé         ║
 * ║         Multi-rôles & Autorisations Collaboratives           ║
 * ╚══════════════════════════════════════════════════════════════╝
 */

require_once 'config.php';
require_once 'functions.php';

// Vérification authentification
if (!isAuthenticated()) {
    header('Location: login.php');
    exit;
}

$user = getCurrentUser();
$userRoles = getUserRoles($user['id']);

// Récupération des cycles partagés
$sharedCycles = getSharedCycles($user['id']);
$pendingRequests = getPendingShareRequests($user['id']);
$myShares = getMyShares($user['id']);
?>
<!DOCTYPE html>
<html lang="fr" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Partage & Collaboration - CEDREPS Ultimate</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@100..900&family=Outfit:wght@100..900&display=swap');
        
        * { font-family: 'Inter', system-ui, sans-serif; }
        h1, h2, h3, h4, h5, h6 { font-family: 'Outfit', sans-serif; }
        
        .role-badge {
            display: inline-flex;
            align-items: center;
            padding: 0.25rem 0.75rem;
            border-radius: 9999px;
            font-size: 0.75rem;
            font-weight: 600;
            gap: 0.5rem;
        }
        
        .share-card {
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }
        
        .share-card:hover {
            transform: translateY(-2px);
            border-color: #3B82F6;
            box-shadow: 0 10px 30px rgba(59, 130, 246, 0.1);
        }
        
        .permission-toggle {
            position: relative;
            display: inline-block;
            width: 48px;
            height: 24px;
        }
        
        .permission-toggle input {
            opacity: 0;
            width: 0;
            height: 0;
        }
        
        .permission-slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #CBD5E1;
            transition: 0.4s;
            border-radius: 24px;
        }
        
        .permission-slider:before {
            position: absolute;
            content: "";
            height: 18px;
            width: 18px;
            left: 3px;
            bottom: 3px;
            background-color: white;
            transition: 0.4s;
            border-radius: 50%;
        }
        
        input:checked + .permission-slider {
            background-color: #10B981;
        }
        
        input:checked + .permission-slider:before {
            transform: translateX(24px);
        }
    </style>
</head>
<body class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100" x-data="sharingSystem">
    
    <!-- Header -->
    <header class="bg-white shadow-sm sticky top-0 z-40">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between py-4">
                <div class="flex items-center space-x-4">
                    <a href="dashboard.php" class="text-gray-500 hover:text-gray-700">
                        <i class="fas fa-arrow-left"></i>
                    </a>
                    <h1 class="text-2xl font-bold bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">
                        Partage & Collaboration
                    </h1>
                </div>
                
                <!-- User Info -->
                <div class="flex items-center space-x-4">
                    <div class="text-right">
                        <p class="text-sm font-semibold text-gray-900"><?= htmlspecialchars($user['name']) ?></p>
                        <div class="flex items-center justify-end space-x-2">
                            <?php foreach ($userRoles as $role): ?>
                            <span class="role-badge" style="background-color: <?= $role['color'] ?>20; color: <?= $role['color'] ?>">
                                <i class="fas fa-<?= $role['icon'] ?> text-xs"></i>
                                <?= $role['name'] ?>
                            </span>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <img src="https://ui-avatars.com/api/?name=<?= urlencode($user['name']) ?>&background=3B82F6&color=ffffff" 
                         class="w-10 h-10 rounded-full" alt="Avatar">
                </div>
            </div>
        </div>
    </header>
    
    <!-- Main Content -->
    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        
        <!-- Tabs Navigation -->
        <div class="bg-white rounded-xl shadow-sm p-2 mb-8">
            <nav class="flex space-x-2">
                <button @click="activeTab = 'overview'" 
                        :class="activeTab === 'overview' ? 'bg-blue-500 text-white' : 'text-gray-600 hover:bg-gray-100'"
                        class="flex-1 px-4 py-2 rounded-lg font-medium transition">
                    <i class="fas fa-chart-pie mr-2"></i> Vue d'ensemble
                </button>
                <button @click="activeTab = 'share'" 
                        :class="activeTab === 'share' ? 'bg-blue-500 text-white' : 'text-gray-600 hover:bg-gray-100'"
                        class="flex-1 px-4 py-2 rounded-lg font-medium transition">
                    <i class="fas fa-share-alt mr-2"></i> Partager mes cycles
                </button>
                <button @click="activeTab = 'received'" 
                        :class="activeTab === 'received' ? 'bg-blue-500 text-white' : 'text-gray-600 hover:bg-gray-100'"
                        class="flex-1 px-4 py-2 rounded-lg font-medium transition">
                    <i class="fas fa-inbox mr-2"></i> Cycles reçus
                    <?php if (count($sharedCycles) > 0): ?>
                    <span class="ml-2 bg-red-500 text-white text-xs px-2 py-0.5 rounded-full"><?= count($sharedCycles) ?></span>
                    <?php endif; ?>
                </button>
                <button @click="activeTab = 'requests'" 
                        :class="activeTab === 'requests' ? 'bg-blue-500 text-white' : 'text-gray-600 hover:bg-gray-100'"
                        class="flex-1 px-4 py-2 rounded-lg font-medium transition">
                    <i class="fas fa-bell mr-2"></i> Demandes
                    <?php if (count($pendingRequests) > 0): ?>
                    <span class="ml-2 bg-red-500 text-white text-xs px-2 py-0.5 rounded-full"><?= count($pendingRequests) ?></span>
                    <?php endif; ?>
                </button>
            </nav>
        </div>
        
        <!-- Tab Content: Overview -->
        <div x-show="activeTab === 'overview'" x-transition>
            <!-- Statistics Cards -->
            <div class="grid grid-cols-4 gap-6 mb-8">
                <div class="bg-white rounded-xl shadow-sm p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 rounded-xl bg-blue-100 flex items-center justify-center text-blue-600">
                            <i class="fas fa-share-alt"></i>
                        </div>
                        <span class="text-2xl font-bold text-gray-900">12</span>
                    </div>
                    <p class="text-sm text-gray-600">Cycles partagés</p>
                    <div class="mt-2 text-xs text-green-600">
                        <i class="fas fa-arrow-up mr-1"></i> +3 ce mois
                    </div>
                </div>
                
                <div class="bg-white rounded-xl shadow-sm p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 rounded-xl bg-purple-100 flex items-center justify-center text-purple-600">
                            <i class="fas fa-users"></i>
                        </div>
                        <span class="text-2xl font-bold text-gray-900">8</span>
                    </div>
                    <p class="text-sm text-gray-600">Collaborateurs</p>
                    <div class="mt-2 text-xs text-blue-600">
                        <i class="fas fa-user-plus mr-1"></i> 2 nouvelles invitations
                    </div>
                </div>
                
                <div class="bg-white rounded-xl shadow-sm p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 rounded-xl bg-green-100 flex items-center justify-center text-green-600">
                            <i class="fas fa-eye"></i>
                        </div>
                        <span class="text-2xl font-bold text-gray-900">156</span>
                    </div>
                    <p class="text-sm text-gray-600">Consultations</p>
                    <div class="mt-2 text-xs text-gray-500">
                        Cette semaine
                    </div>
                </div>
                
                <div class="bg-white rounded-xl shadow-sm p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 rounded-xl bg-orange-100 flex items-center justify-center text-orange-600">
                            <i class="fas fa-comments"></i>
                        </div>
                        <span class="text-2xl font-bold text-gray-900">24</span>
                    </div>
                    <p class="text-sm text-gray-600">Commentaires</p>
                    <div class="mt-2 text-xs text-orange-600">
                        <i class="fas fa-comment mr-1"></i> 5 non lus
                    </div>
                </div>
            </div>
            
            <!-- Recent Activity -->
            <div class="bg-white rounded-xl shadow-sm p-6">
                <h2 class="text-lg font-bold mb-4">Activité récente</h2>
                <div class="space-y-4">
                    <div class="flex items-start space-x-4">
                        <div class="w-10 h-10 rounded-full bg-green-100 flex items-center justify-center flex-shrink-0">
                            <i class="fas fa-check text-green-600"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm">
                                <span class="font-semibold">Marie Durand</span> (Inspectrice) a approuvé votre cycle 
                                <span class="font-semibold">"Handball - 6ème"</span>
                            </p>
                            <p class="text-xs text-gray-500 mt-1">Il y a 2 heures</p>
                        </div>
                    </div>
                    
                    <div class="flex items-start space-x-4">
                        <div class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center flex-shrink-0">
                            <i class="fas fa-comment text-blue-600"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm">
                                <span class="font-semibold">Pierre Martin</span> (Coordinateur) a commenté votre FPS 
                                <span class="font-semibold">"Le jeu en mouvement"</span>
                            </p>
                            <p class="text-xs text-gray-500 mt-1">Il y a 5 heures</p>
                        </div>
                    </div>
                    
                    <div class="flex items-start space-x-4">
                        <div class="w-10 h-10 rounded-full bg-purple-100 flex items-center justify-center flex-shrink-0">
                            <i class="fas fa-share text-purple-600"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm">
                                Vous avez partagé le cycle <span class="font-semibold">"Escalade - 5ème"</span> avec 
                                <span class="font-semibold">3 collaborateurs</span>
                            </p>
                            <p class="text-xs text-gray-500 mt-1">Hier</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Tab Content: Share My Cycles -->
        <div x-show="activeTab === 'share'" x-transition>
            <div class="bg-white rounded-xl shadow-sm p-6 mb-8">
                <h2 class="text-lg font-bold mb-4">Partager un cycle</h2>
                
                <!-- Cycle Selection -->
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Sélectionnez le cycle à partager
                    </label>
                    <select class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        <option value="">-- Choisir un cycle --</option>
                        <option value="1">Handball - 6ème A - Le jeu en mouvement</option>
                        <option value="2">Escalade - 5ème A - La mouli-vache</option>
                        <option value="3">Course de durée - 4ème B - Allure cible</option>
                    </select>
                </div>
                
                <!-- Recipients Selection -->
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Avec qui partager ?
                    </label>
                    
                    <!-- Quick Role Selection -->
                    <div class="flex space-x-2 mb-4">
                        <button @click="selectAllRole('inspector')" 
                                class="px-3 py-1 bg-red-100 text-red-600 rounded-lg text-sm hover:bg-red-200 transition">
                            <i class="fas fa-user-graduate mr-1"></i> Tous les inspecteurs
                        </button>
                        <button @click="selectAllRole('principal')" 
                                class="px-3 py-1 bg-orange-100 text-orange-600 rounded-lg text-sm hover:bg-orange-200 transition">
                            <i class="fas fa-building-columns mr-1"></i> Chef d'établissement
                        </button>
                        <button @click="selectAllRole('coordinator')" 
                                class="px-3 py-1 bg-blue-100 text-blue-600 rounded-lg text-sm hover:bg-blue-200 transition">
                            <i class="fas fa-users-cog mr-1"></i> Coordinateurs EPS
                        </button>
                        <button @click="selectAllRole('teacher')" 
                                class="px-3 py-1 bg-green-100 text-green-600 rounded-lg text-sm hover:bg-green-200 transition">
                            <i class="fas fa-user-tie mr-1"></i> Équipe EPS
                        </button>
                    </div>
                    
                    <!-- Individual Selection -->
                    <div class="border border-gray-200 rounded-lg p-4 max-h-64 overflow-y-auto">
                        <div class="space-y-2">
                            <!-- Inspectors -->
                            <div class="font-semibold text-sm text-gray-700 mb-2 flex items-center">
                                <i class="fas fa-user-graduate mr-2 text-red-500"></i> Inspecteurs
                            </div>
                            <label class="flex items-center p-2 hover:bg-gray-50 rounded cursor-pointer">
                                <input type="checkbox" class="mr-3" value="inspector_1">
                                <img src="https://ui-avatars.com/api/?name=Marie+Durand&background=DC2626&color=ffffff" 
                                     class="w-8 h-8 rounded-full mr-3" alt="Avatar">
                                <div class="flex-1">
                                    <p class="text-sm font-medium">Marie Durand</p>
                                    <p class="text-xs text-gray-500">Inspectrice Académique - Secteur Nord</p>
                                </div>
                            </label>
                            
                            <!-- Principal -->
                            <div class="font-semibold text-sm text-gray-700 mb-2 mt-4 flex items-center">
                                <i class="fas fa-building-columns mr-2 text-orange-500"></i> Direction
                            </div>
                            <label class="flex items-center p-2 hover:bg-gray-50 rounded cursor-pointer">
                                <input type="checkbox" class="mr-3" value="principal_1">
                                <img src="https://ui-avatars.com/api/?name=Jean+Dupont&background=EA580C&color=ffffff" 
                                     class="w-8 h-8 rounded-full mr-3" alt="Avatar">
                                <div class="flex-1">
                                    <p class="text-sm font-medium">Jean Dupont</p>
                                    <p class="text-xs text-gray-500">Chef d'établissement</p>
                                </div>
                            </label>
                            
                            <!-- Coordinators -->
                            <div class="font-semibold text-sm text-gray-700 mb-2 mt-4 flex items-center">
                                <i class="fas fa-users-cog mr-2 text-blue-500"></i> Coordinateurs
                            </div>
                            <label class="flex items-center p-2 hover:bg-gray-50 rounded cursor-pointer">
                                <input type="checkbox" class="mr-3" value="coord_1">
                                <img src="https://ui-avatars.com/api/?name=Pierre+Martin&background=0891B2&color=ffffff" 
                                     class="w-8 h-8 rounded-full mr-3" alt="Avatar">
                                <div class="flex-1">
                                    <p class="text-sm font-medium">Pierre Martin</p>
                                    <p class="text-xs text-gray-500">Coordinateur EPS</p>
                                </div>
                            </label>
                        </div>
                    </div>
                </div>
                
                <!-- Permissions Settings -->
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-3">
                        Autorisations
                    </label>
                    <div class="space-y-3">
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center">
                                <i class="fas fa-eye text-blue-500 mr-3"></i>
                                <div>
                                    <p class="text-sm font-medium">Consultation</p>
                                    <p class="text-xs text-gray-500">Peut voir le cycle et les leçons</p>
                                </div>
                            </div>
                            <label class="permission-toggle">
                                <input type="checkbox" checked>
                                <span class="permission-slider"></span>
                            </label>
                        </div>
                        
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center">
                                <i class="fas fa-comment text-green-500 mr-3"></i>
                                <div>
                                    <p class="text-sm font-medium">Commentaires</p>
                                    <p class="text-xs text-gray-500">Peut ajouter des commentaires et suggestions</p>
                                </div>
                            </div>
                            <label class="permission-toggle">
                                <input type="checkbox" checked>
                                <span class="permission-slider"></span>
                            </label>
                        </div>
                        
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center">
                                <i class="fas fa-download text-purple-500 mr-3"></i>
                                <div>
                                    <p class="text-sm font-medium">Téléchargement</p>
                                    <p class="text-xs text-gray-500">Peut exporter le cycle en PDF/Excel</p>
                                </div>
                            </div>
                            <label class="permission-toggle">
                                <input type="checkbox">
                                <span class="permission-slider"></span>
                            </label>
                        </div>
                        
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center">
                                <i class="fas fa-copy text-orange-500 mr-3"></i>
                                <div>
                                    <p class="text-sm font-medium">Duplication</p>
                                    <p class="text-xs text-gray-500">Peut dupliquer pour ses propres classes</p>
                                </div>
                            </div>
                            <label class="permission-toggle">
                                <input type="checkbox">
                                <span class="permission-slider"></span>
                            </label>
                        </div>
                        
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center">
                                <i class="fas fa-edit text-red-500 mr-3"></i>
                                <div>
                                    <p class="text-sm font-medium">Modification</p>
                                    <p class="text-xs text-gray-500">Peut modifier le contenu (danger !)</p>
                                </div>
                            </div>
                            <label class="permission-toggle">
                                <input type="checkbox">
                                <span class="permission-slider"></span>
                            </label>
                        </div>
                    </div>
                </div>
                
                <!-- Expiration -->
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Durée du partage
                    </label>
                    <select class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        <option value="7">1 semaine</option>
                        <option value="30">1 mois</option>
                        <option value="90">3 mois</option>
                        <option value="365" selected>1 an</option>
                        <option value="0">Permanent</option>
                    </select>
                </div>
                
                <!-- Message -->
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Message (optionnel)
                    </label>
                    <textarea class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" 
                              rows="3" placeholder="Ajoutez un message pour les destinataires..."></textarea>
                </div>
                
                <!-- Actions -->
                <div class="flex justify-end space-x-3">
                    <button class="px-6 py-2 bg-gray-100 text-gray-700 rounded-lg hover:bg-gray-200 transition">
                        Annuler
                    </button>
                    <button @click="shareGycle()" class="px-6 py-2 bg-gradient-to-r from-blue-500 to-purple-600 text-white rounded-lg hover:shadow-lg transition">
                        <i class="fas fa-share mr-2"></i> Partager le cycle
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Tab Content: Received Cycles -->
        <div x-show="activeTab === 'received'" x-transition>
            <div class="grid grid-cols-2 gap-6">
                <?php foreach ($sharedCycles as $cycle): ?>
                <div class="share-card bg-white rounded-xl shadow-sm p-6">
                    <div class="flex items-start justify-between mb-4">
                        <div>
                            <h3 class="font-bold text-lg"><?= htmlspecialchars($cycle['name']) ?></h3>
                            <p class="text-sm text-gray-600"><?= htmlspecialchars($cycle['ppsad']) ?> - <?= htmlspecialchars($cycle['class_name']) ?></p>
                        </div>
                        <span class="px-3 py-1 bg-blue-100 text-blue-600 rounded-full text-xs font-semibold">
                            <?= htmlspecialchars($cycle['ecc_type']) ?>
                        </span>
                    </div>
                    
                    <div class="mb-4">
                        <p class="text-sm text-gray-700"><?= htmlspecialchars($cycle['objective']) ?></p>
                    </div>
                    
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center space-x-2">
                            <img src="https://ui-avatars.com/api/?name=<?= urlencode($cycle['shared_by']) ?>&background=3B82F6&color=ffffff" 
                                 class="w-8 h-8 rounded-full" alt="Avatar">
                            <div>
                                <p class="text-sm font-medium"><?= htmlspecialchars($cycle['shared_by']) ?></p>
                                <p class="text-xs text-gray-500">Partagé le <?= date('d/m/Y', strtotime($cycle['shared_at'])) ?></p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Permissions -->
                    <div class="flex space-x-2 mb-4">
                        <?php if ($cycle['can_view']): ?>
                        <span class="text-xs bg-green-100 text-green-600 px-2 py-1 rounded">
                            <i class="fas fa-eye mr-1"></i> Consultation
                        </span>
                        <?php endif; ?>
                        <?php if ($cycle['can_comment']): ?>
                        <span class="text-xs bg-blue-100 text-blue-600 px-2 py-1 rounded">
                            <i class="fas fa-comment mr-1"></i> Commentaires
                        </span>
                        <?php endif; ?>
                        <?php if ($cycle['can_download']): ?>
                        <span class="text-xs bg-purple-100 text-purple-600 px-2 py-1 rounded">
                            <i class="fas fa-download mr-1"></i> Téléchargement
                        </span>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Actions -->
                    <div class="flex space-x-2">
                        <button class="flex-1 px-3 py-2 bg-blue-500 text-white rounded-lg text-sm hover:bg-blue-600 transition">
                            <i class="fas fa-eye mr-1"></i> Consulter
                        </button>
                        <?php if ($cycle['can_download']): ?>
                        <button class="flex-1 px-3 py-2 bg-gray-100 text-gray-700 rounded-lg text-sm hover:bg-gray-200 transition">
                            <i class="fas fa-download mr-1"></i> Télécharger
                        </button>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <!-- Tab Content: Requests -->
        <div x-show="activeTab === 'requests'" x-transition>
            <div class="bg-white rounded-xl shadow-sm p-6">
                <h2 class="text-lg font-bold mb-4">Demandes de partage en attente</h2>
                
                <?php if (count($pendingRequests) === 0): ?>
                <div class="text-center py-12">
                    <i class="fas fa-inbox text-6xl text-gray-300 mb-4"></i>
                    <p class="text-gray-500">Aucune demande en attente</p>
                </div>
                <?php else: ?>
                <div class="space-y-4">
                    <?php foreach ($pendingRequests as $request): ?>
                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                        <div class="flex items-center space-x-4">
                            <img src="https://ui-avatars.com/api/?name=<?= urlencode($request['requester_name']) ?>&background=8B5CF6&color=ffffff" 
                                 class="w-10 h-10 rounded-full" alt="Avatar">
                            <div>
                                <p class="font-medium"><?= htmlspecialchars($request['requester_name']) ?></p>
                                <p class="text-sm text-gray-600">
                                    Souhaite accéder à <span class="font-semibold"><?= htmlspecialchars($request['cycle_name']) ?></span>
                                </p>
                                <p class="text-xs text-gray-500 mt-1">
                                    <?= date('d/m/Y à H:i', strtotime($request['requested_at'])) ?>
                                </p>
                            </div>
                        </div>
                        <div class="flex space-x-2">
                            <button @click="acceptRequest(<?= $request['id'] ?>)" 
                                    class="px-4 py-2 bg-green-500 text-white rounded-lg text-sm hover:bg-green-600 transition">
                                <i class="fas fa-check mr-1"></i> Accepter
                            </button>
                            <button @click="rejectRequest(<?= $request['id'] ?>)" 
                                    class="px-4 py-2 bg-red-500 text-white rounded-lg text-sm hover:bg-red-600 transition">
                                <i class="fas fa-times mr-1"></i> Refuser
                            </button>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
    </main>
    
    <!-- JavaScript -->
    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('sharingSystem', () => ({
                activeTab: 'overview',
                
                shareGycle() {
                    Swal.fire({
                        icon: 'success',
                        title: 'Cycle partagé !',
                        text: 'Les destinataires ont été notifiés',
                        confirmButtonColor: '#3B82F6'
                    });
                },
                
                acceptRequest(requestId) {
                    Swal.fire({
                        title: 'Accepter la demande ?',
                        text: 'Cette personne pourra consulter votre cycle',
                        icon: 'question',
                        showCancelButton: true,
                        confirmButtonColor: '#10B981',
                        cancelButtonColor: '#EF4444',
                        confirmButtonText: 'Oui, accepter',
                        cancelButtonText: 'Annuler'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Process acceptance
                            Swal.fire('Accepté !', 'La demande a été acceptée.', 'success');
                        }
                    });
                },
                
                rejectRequest(requestId) {
                    Swal.fire({
                        title: 'Refuser la demande ?',
                        text: 'Cette action est définitive',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#EF4444',
                        cancelButtonColor: '#6B7280',
                        confirmButtonText: 'Oui, refuser',
                        cancelButtonText: 'Annuler'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Process rejection
                            Swal.fire('Refusé', 'La demande a été refusée.', 'info');
                        }
                    });
                },
                
                selectAllRole(role) {
                    // Select all users with specific role
                    console.log('Selecting all users with role:', role);
                }
            }));
        });
    </script>
</body>
</html>