<?php
/**
 * TEST DE SESSION PHP - DIAGNOSTIC COMPLET
 */

// Démarrer la session
session_start();

// Actions
$action = $_GET['action'] ?? '';

if ($action === 'set') {
    $_SESSION['test_time'] = time();
    $_SESSION['test_value'] = 'CEDREPS_OK';
    $_SESSION['test_id'] = uniqid();
    header('Location: test_session.php?action=check');
    exit;
}

if ($action === 'destroy') {
    session_destroy();
    header('Location: test_session.php');
    exit;
}

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Test Session PHP</title>
    <style>
        body {
            font-family: sans-serif;
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            background: #f5f5f5;
        }
        .box {
            background: white;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .success { background: #d4edda; color: #155724; }
        .error { background: #f8d7da; color: #721c24; }
        .warning { background: #fff3cd; color: #856404; }
        .info { background: #d1ecf1; color: #0c5460; }
        table { width: 100%; border-collapse: collapse; }
        td, th { padding: 8px; border: 1px solid #ddd; text-align: left; }
        th { background: #f0f0f0; }
        .btn {
            display: inline-block;
            padding: 10px 20px;
            background: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 5px;
        }
        .btn:hover { background: #0056b3; }
        .btn-success { background: #28a745; }
        .btn-danger { background: #dc3545; }
        code {
            background: #f4f4f4;
            padding: 2px 5px;
            border-radius: 3px;
            font-family: monospace;
        }
    </style>
</head>
<body>
    <h1>🔍 Test des Sessions PHP</h1>
    
    <!-- État de la session -->
    <div class="box <?php echo isset($_SESSION['test_value']) ? 'success' : 'warning'; ?>">
        <h2>État de la Session</h2>
        <p><strong>Session ID :</strong> <code><?php echo session_id(); ?></code></p>
        <p><strong>Session démarrée :</strong> <?php echo session_id() ? '✅ OUI' : '❌ NON'; ?></p>
        <p><strong>Variables de session :</strong> <?php echo count($_SESSION); ?> variable(s)</p>
    </div>
    
    <!-- Variables de session -->
    <div class="box">
        <h2>Contenu de $_SESSION</h2>
        <?php if (empty($_SESSION)): ?>
            <p>❌ Aucune variable de session</p>
        <?php else: ?>
            <table>
                <tr>
                    <th>Clé</th>
                    <th>Valeur</th>
                    <th>Type</th>
                </tr>
                <?php foreach ($_SESSION as $key => $value): ?>
                <tr>
                    <td><code><?php echo htmlspecialchars($key); ?></code></td>
                    <td><?php echo htmlspecialchars(is_array($value) ? json_encode($value) : $value); ?></td>
                    <td><?php echo gettype($value); ?></td>
                </tr>
                <?php endforeach; ?>
            </table>
        <?php endif; ?>
    </div>
    
    <!-- Configuration PHP -->
    <div class="box">
        <h2>Configuration PHP</h2>
        <table>
            <tr>
                <th>Paramètre</th>
                <th>Valeur</th>
                <th>État</th>
            </tr>
            <tr>
                <td>PHP Version</td>
                <td><?php echo PHP_VERSION; ?></td>
                <td><?php echo version_compare(PHP_VERSION, '7.0.0', '>=') ? '✅' : '⚠️'; ?></td>
            </tr>
            <tr>
                <td>session.save_handler</td>
                <td><?php echo ini_get('session.save_handler'); ?></td>
                <td>✅</td>
            </tr>
            <tr>
                <td>session.save_path</td>
                <td><code><?php echo ini_get('session.save_path') ?: 'Par défaut'; ?></code></td>
                <td><?php 
                    $path = ini_get('session.save_path');
                    echo ($path && is_writable($path)) || !$path ? '✅' : '❌';
                ?></td>
            </tr>
            <tr>
                <td>session.cookie_lifetime</td>
                <td><?php echo ini_get('session.cookie_lifetime'); ?> secondes</td>
                <td>✅</td>
            </tr>
            <tr>
                <td>session.gc_maxlifetime</td>
                <td><?php echo ini_get('session.gc_maxlifetime'); ?> secondes</td>
                <td>✅</td>
            </tr>
            <tr>
                <td>session.use_cookies</td>
                <td><?php echo ini_get('session.use_cookies') ? 'OUI' : 'NON'; ?></td>
                <td><?php echo ini_get('session.use_cookies') ? '✅' : '❌'; ?></td>
            </tr>
            <tr>
                <td>session.cookie_httponly</td>
                <td><?php echo ini_get('session.cookie_httponly') ? 'OUI' : 'NON'; ?></td>
                <td>✅</td>
            </tr>
        </table>
    </div>
    
    <!-- Cookies -->
    <div class="box">
        <h2>Cookies</h2>
        <?php if (empty($_COOKIE)): ?>
            <p>❌ Aucun cookie détecté</p>
        <?php else: ?>
            <table>
                <tr>
                    <th>Nom</th>
                    <th>Valeur</th>
                </tr>
                <?php foreach ($_COOKIE as $name => $value): ?>
                <tr>
                    <td><code><?php echo htmlspecialchars($name); ?></code></td>
                    <td><?php echo htmlspecialchars($value); ?></td>
                </tr>
                <?php endforeach; ?>
            </table>
        <?php endif; ?>
    </div>
    
    <!-- Tests -->
    <div class="box">
        <h2>Actions de Test</h2>
        <p>
            <a href="?action=set" class="btn btn-success">✅ Créer des variables de session</a>
            <a href="?action=destroy" class="btn btn-danger">🗑️ Détruire la session</a>
            <a href="test_session.php" class="btn">🔄 Rafraîchir</a>
        </p>
        
        <?php if ($action === 'check' && isset($_SESSION['test_value'])): ?>
        <div class="box success">
            <strong>✅ Session fonctionne correctement !</strong><br>
            Les variables de session persistent entre les pages.
        </div>
        <?php elseif ($action === 'check' && !isset($_SESSION['test_value'])): ?>
        <div class="box error">
            <strong>❌ Problème avec les sessions !</strong><br>
            Les variables de session ne persistent pas.
        </div>
        <?php endif; ?>
    </div>
    
    <!-- Instructions -->
    <div class="box info">
        <h2>📘 Instructions</h2>
        <ol>
            <li>Cliquez sur "Créer des variables de session"</li>
            <li>La page va se recharger</li>
            <li>Si vous voyez les variables dans le tableau, les sessions fonctionnent</li>
            <li>Si le tableau reste vide, il y a un problème de configuration</li>
        </ol>
        
        <h3>Solutions possibles si les sessions ne fonctionnent pas :</h3>
        <ul>
            <li><strong>Permissions :</strong> Le dossier de sessions doit être accessible en écriture</li>
            <li><strong>Configuration PHP :</strong> Vérifiez session.save_path dans php.ini</li>
            <li><strong>Cookies désactivés :</strong> Vérifiez que les cookies sont acceptés</li>
            <li><strong>Cache :</strong> Videz le cache du navigateur</li>
        </ul>
    </div>
</body>
</html>