# Application EPS – CEDREPS

Cette application web permet aux enseignants d'éducation physique et sportive (EPS) de planifier et suivre leurs cours conformément aux principes du CEDREPS.  Elle est écrite en **PHP** et utilise **MySQL** pour la base de données, ainsi que du **JavaScript** vanilla pour les quelques interactions côté client.  Les instructions ci‑dessous expliquent comment installer l'application sur un hébergement cPanel.

## Pré-requis

* Un hébergement mutualisé cPanel avec PHP 7.4 ou supérieur et une base de données MySQL disponible.
* Un accès à phpMyAdmin ou à l'outil MySQL de votre hébergeur pour créer la base et importer le fichier SQL.
* Un client FTP ou le gestionnaire de fichiers cPanel pour transférer les fichiers.

## Installation pas à pas

1. **Créer la base de données**

   Connectez‑vous à votre cPanel puis ouvrez “Bases de données MySQL”.  Créez une nouvelle base (par exemple `eps_app_db`) et un utilisateur MySQL avec tous les privilèges sur cette base.  Notez bien le nom de la base, l'utilisateur et le mot de passe : ils seront utilisés dans le fichier de configuration.

2. **Importer le schéma**

   Ouvrez phpMyAdmin via cPanel.  Sélectionnez la base de données que vous venez de créer et utilisez l'onglet **Importer** pour importer le fichier `install.sql` situé dans le dossier `eps_app`.  Ce fichier crée toutes les tables nécessaires (`users`, `classes`, `cycles`, `lessons`, etc.).

3. **Configurer la connexion à la base**

   Dans le dossier `eps_app`, ouvrez le fichier `config.php` et modifiez les variables suivantes pour qu'elles correspondent aux paramètres de votre base :

   ```php
   $db_host = 'localhost';       // généralement localhost sur un hébergement cPanel
   $db_name = 'eps_app_db';      // nom de la base de données
   $db_user = 'eps_user';        // nom de l'utilisateur MySQL
   $db_pass = 'secret_password'; // mot de passe de cet utilisateur
   ```

   Enregistrez le fichier et fermez‑le.

4. **Déployer les fichiers**

   Transférez l'intégralité du dossier `eps_app` sur votre serveur via FTP ou le gestionnaire de fichiers cPanel.  Vous pouvez le placer à la racine `public_html` si vous souhaitez y accéder via `https://votredomaine.com/eps_app`, ou bien directement dans `public_html` pour y accéder à la racine du site.

5. **Créer un premier compte**

   Rendez‑vous dans votre navigateur à l'URL correspondant au dossier (`/eps_app/`).  Vous serez redirigé vers la page de connexion.  Utilisez le lien “Créer un compte” pour inscrire votre premier utilisateur (nom, email et mot de passe).  Ce compte aura automatiquement le rôle d'enseignant.

6. **Commencer à utiliser l'application**

   Une fois connecté, vous accéderez au tableau de bord.  Vous pourrez créer vos classes, y ajouter des élèves, créer des cycles (saisir l'activité support, l'objectif d'enseignement, etc.), puis ajouter les leçons et saisir les évaluations pour chaque élève.

## Structure des fichiers

* `install.sql` : script SQL pour créer la base de données.
* `config.php` : configuration de la connexion MySQL.
* `functions.php` : fonctions communes (authentification, accès aux données).
* `index.php` : redirection vers la connexion ou le tableau de bord.
* `login.php`, `register.php`, `logout.php` : authentification.
* `dashboard.php` : liste des classes du professeur.
* `create_class.php` : formulaire de création de classe.
* `class_detail.php` : gestion des élèves et cycles d’une classe.
* `create_cycle.php` : création d’un cycle pour une classe.
* `cycle_detail.php` : consultation des leçons d’un cycle.
* `create_lesson.php` : création d’une leçon dans un cycle.
* `lesson_detail.php` : consultation d’une leçon et saisie des évaluations.
* `style.css` : feuille de styles simple.
* `js/scripts.js` : fonctions JavaScript de base.

## Sécurité et recommandations

* Les mots de passe sont stockés sous forme de hachage sécurisé (`password_hash`) dans la base.
* Les actions de création et de consultation sont protégées par la vérification du statut de connexion.  Néanmoins, pour un usage en production, renforcez la sécurité : utilisez HTTPS, limitez les injections potentielles et mettez à jour PHP régulièrement.
* Cette application est un prototype simplifié.  Vous pouvez l’étendre selon les besoins (ajout de rôles, de rapports, de graphiques, etc.).

Bonne utilisation !