<?php
require_once __DIR__ . '/functions.php';

// Ensure user is logged in
if (!isLoggedIn()) {
    redirect('login.php');
}
$user = currentUser($pdo);

$cycleId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$cycle = getCycleById($pdo, $cycleId);
if (!$cycle) {
    redirect('dashboard.php');
}
$class = getClassById($pdo, $cycle['class_id']);
if (!$class || $class['teacher_id'] !== $user['id']) {
    redirect('dashboard.php');
}

$lessons = getLessons($pdo, $cycleId);

$pageTitle = 'Cycle: ' . $cycle['name'];
include 'header.php';
?>

<h2>Détails du cycle: <?php echo htmlspecialchars($cycle['name']); ?></h2>

<p><strong>Classe:</strong> <?php echo htmlspecialchars($class['name']); ?></p>
<p><strong>Activité support (PPSAD):</strong> <?php echo htmlspecialchars($cycle['ppsad']); ?></p>
<p><strong>Objet d'enseignement:</strong><br><?php echo nl2br(htmlspecialchars($cycle['objective'])); ?></p>
<?php if (!empty($cycle['oe_id'])): ?>
    <?php $oeInfo = getOEById($pdo, $cycle['oe_id']); ?>
    <?php if ($oeInfo): ?>
        <p><strong>Obj. référence (bibliothèque):</strong> <?php echo htmlspecialchars($oeInfo['ppsad'] . ' – ' . $oeInfo['name']); ?></p>
    <?php endif; ?>
<?php endif; ?>
<p><strong>Type d'expérience (ECC):</strong> <?php echo htmlspecialchars($cycle['ecc_type']); ?></p>
<?php if ($cycle['start_date'] || $cycle['end_date']): ?>
    <p><strong>Période:</strong> <?php echo htmlspecialchars($cycle['start_date'] . ' - ' . $cycle['end_date']); ?></p>
<?php endif; ?>

<h3>Leçons</h3>
<?php if (empty($lessons)): ?>
    <p>Aucune leçon n'est créée pour ce cycle. <a href="create_lesson.php?cycle_id=<?php echo $cycleId; ?>">Ajouter une leçon</a>.</p>
<?php else: ?>
    <div class="table-container">
    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Titre</th>
                <th>FPS (forme de pratique scolaire)</th>
                <th>CP (contenus prioritaires)</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($lessons as $lesson): ?>
            <tr>
                <td><?php echo htmlspecialchars($lesson['lesson_date']); ?></td>
                <td><?php echo htmlspecialchars($lesson['title']); ?></td>
                <td><?php echo nl2br(htmlspecialchars($lesson['fps'])); ?></td>
                <td><?php echo nl2br(htmlspecialchars($lesson['cp'])); ?></td>
                <td>
                    <a href="lesson_detail.php?id=<?php echo $lesson['id']; ?>">Voir / évaluer</a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    </div>
    <p><a href="create_lesson.php?cycle_id=<?php echo $cycleId; ?>">Ajouter une leçon</a></p>
    <p>
        <a href="export_cycle.php?cycle_id=<?php echo $cycleId; ?>">Exporter les évaluations du cycle (CSV)</a>
    </p>
<?php endif; ?>

<?php
include 'footer.php';
?>