<?php
require_once __DIR__ . '/functions.php';

// If already logged in, redirect to dashboard
if (isLoggedIn()) {
    redirect('dashboard.php');
}

$error = '';
$success = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm = $_POST['confirm'] ?? '';
    if ($password !== $confirm) {
        $error = "Les mots de passe ne correspondent pas.";
    } elseif (!$name || !$email || !$password) {
        $error = "Tous les champs sont requis.";
    } else {
        if (registerUser($pdo, $name, $email, $password)) {
            $success = "Compte créé avec succès. Vous pouvez maintenant vous connecter.";
        } else {
            $error = "Cette adresse email est déjà utilisée.";
        }
    }
}

$pageTitle = 'Inscription';
include 'header.php';
?>

<h2>Créer un compte enseignant</h2>

<?php if ($error): ?>
    <div class="message error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>
<?php if ($success): ?>
    <div class="message success"><?php echo htmlspecialchars($success); ?></div>
<?php endif; ?>

<form method="post" action="">
    <label for="name">Nom complet</label>
    <input type="text" id="name" name="name" required>

    <label for="email">Adresse email</label>
    <input type="email" id="email" name="email" required>

    <label for="password">Mot de passe</label>
    <input type="password" id="password" name="password" required>

    <label for="confirm">Confirmer le mot de passe</label>
    <input type="password" id="confirm" name="confirm" required>

    <button type="submit">Créer le compte</button>
</form>

<?php
include 'footer.php';
?>